Name: mpeg4ip
Version: 1.5.0.1
Release: alt15

Summary: Set of linux video stream processing utilities
License: MPL
Group: Video
Url: http://www.mpeg4ip.net
Packager: Afanasov Dmitry <ender@altlinux.org>

Source: http://download.sourceforge.net/mpeg4ip/%name-%version.tar.gz
Patch: %name-ffmpeg-0.7.1.patch
Patch1: %name-1.5.0.1-alt-v4l.patch
Patch2: %name-1.5.0.1-alt-v4l-libav.patch
Patch3: %name-1.5.0.1-alt-DSO.patch
Patch4: %name-1.5.0.1-alt-libav9.patch

# Automatically added by buildreq on Thu Dec 15 2005
BuildRequires: esound-devel fontconfig-devel freetype2-devel gcc-c++ glib2-devel id3lib-devel libSDL-devel liba52-devel libalsa-devel libatk-devel libaudio-devel libaudiofile-devel libcairo-devel libfaad-devel libglitz-devel libgtk+2-devel liblame-devel libmad-devel libmpeg2-devel libpango-devel libpng-devel libstdc++-devel libvorbis-devel nasm xvid-devel zlib-devel libx264-devel

BuildPreReq: libICE-devel libavformat-devel libpostproc-devel
BuildPreReq: libswscale-devel libavdevice-devel libavfilter-devel
BuildPreReq: libv4l-devel

%description
The MPEG4IP project provides a standarts-based system
for encoding, streaming and playing encoded auido and video.
This package contains libraries of MPEG4IP project.

%package -n lib%name
Summary: MPEG4IP libraries
Group: Development/C

%description -n lib%name
MPEG4IP libraries.

%package -n libmp4v2
Summary: MP4V2 libraries
Group: Development/C

%description -n libmp4v2
MP4v2 libraries, part of mpeg4ip project

%package tools
Summary: MPEG4IP tools
Group: Video
Requires: lib%name = %version-%release

%description tools
MPEG4IP video, audio tools.

%package doc
Summary: MPEG4IP Documentation
Group: Video
BuildArch: noarch

%description doc
MPEG4IP Documentation.

%package -n lib%name-devel
Summary: MPEG4IP Development files
Group: Development/C
Requires: lib%name = %version-%release

%description -n lib%name-devel
MPEG4IP Development files

%package player
Summary: MPEG4IP Player (console version)
Group: Video
Requires: lib%name = %version-%release
Requires: %name-player-plugins = %version-%release

%description player
MPEG4IP Player (Console version)

%package player-gui
Summary: MPEG4IP Player (GUI version)
Group: Video
Requires: lib%name = %version-%release
Requires: %name-player-plugins = %version-%release

%description player-gui
MPEG4IP Player (GUI version)

%package player-plugins
Summary: MPEG4IP Player plugins
Group: Video
Requires: lib%name = %version-%release

%description player-plugins
MPEG4IP Player plugins.

%package live
Summary: MPEG4IP Live streaming server
Group: Video
Requires: lib%name = %version-%release

%description live
MPEG4IP Live streaming server

%prep
%setup -n %name-%version
%patch0 -p2
%patch1 -p2
%patch2 -p2
%patch3 -p2
%patch4 -p1
touch bootstrapped
# build player plugins as plugins, not libraries.
find ./player -name Makefile\* -print0 | xargs -r0 subst 's,\(\-module\),\1 -avoid-version,' --
find . -type f -name Makefile.\* |xargs fgrep -l -- -Werror |xargs sed -i 's,-Werror,,'
sed -i '/CFLAGS="$CFLAGS -Wall -Werror"/d' lib/rtp/configure.in

%build
touch {common/video/iso-mpeg4,lib/{rtp,SDLAudio}}/{NEWS,AUTHORS,ChangeLog}
%add_optflags -D__STDC_CONSTANT_MACROS
%autoreconf
%configure \
	--disable-static \
	--disable-server \
	--disable-player \
	--enable-mp4live \
	--without-arts \
	--enable-warns-as-err=no \
	--enable-ffmpeg=%prefix \
%ifarch %ix86 x86_64	
	--enable-mmx \
%endif
	#
make

%install
%make_install install DESTDIR=%buildroot -j1

#strange .mpt file. go to docs for now...
mkdir -p %buildroot%_docdir/%name-%version
mv %buildroot/%_mandir/manm/* %buildroot%_docdir/%name-%version/

cp -Rv ./doc/* %buildroot%_datadir/doc/%name-%version/
find %buildroot%_datadir/doc/%name-%version -iname "*makefile*" -print0 | xargs -0 rm -f --
rm -rf %buildroot%_datadir/doc/%name-%version/{mp4v2,programs}

%files -n lib%name
%_libdir/*.so.*
%exclude %_libdir/libmp4v2.so.*

%files -n libmp4v2
%_libdir/libmp4v2.so.*

%files doc
%_man1dir/*
%_datadir/doc/%name-%version

%files -n lib%name-devel
%_bindir/mpeg4ip-config
%_libdir/*.so
%_includedir/*
%_man3dir/*

%files tools
%_bindir/*
%exclude %_bindir/mpeg4ip-config

%changelog
