Name: mpfr
Version: 3.1.3
Release: alt1

Summary: Multiple Precision Floating-Point library
License: LGPLv2.1+
Group: System/Libraries
Url: http://www.mpfr.org/

# Don't build static library by default
%def_disable static

# Automatically added by buildreq on Wed Dec 16 2015
# optimized out: elfutils perl-Encode perl-Text-Unidecode perl-Unicode-EastAsianWidth perl-Unicode-Normalize perl-libintl perl-unicore python-base xz
BuildRequires: libgmp-devel makeinfo

# http://www.mpfr.org/mpfr-current/mpfr-%version.tar.bz2
Source0: mpfr-%version.tar
Source1: mpfrxx.h

Patch: mpfr-%version-%release.patch

%define libmpfr libmpfr4

%package -n %libmpfr
Summary: Multiple Precision Floating-Point library
License: LGPLv2.1+
Group: System/Libraries
Provides: libmpfr = %version
Obsoletes: libmpfr

%package -n libmpfr-devel
Summary: Development MPFR library, header files and documentation
License: LGPLv2.1+, FDLv1.1+
Group: Development/C
Requires: %libmpfr = %version-%release
Requires: libgmp-devel
Conflicts: libgmp-devel = 0:4.1.4-alt3

%package -n libmpfr-devel-static
Summary: Static MPFR library
License: LGPLv2.1+
Group: Development/C
Requires: libmpfr-devel = %version-%release

%description
MPFR provides a library for multiple-precision floating-point
computation with correct rounding.  The computation is both efficient
and has a well-defined semantics.  It copies the good ideas from the
ANSI/IEEE-754 standard for double-precision floating-point arithmetic
(53-bit mantissa).

%description -n %libmpfr
MPFR provides a library for multiple-precision floating-point
computation with correct rounding.  The computation is both efficient
and has a well-defined semantics.  It copies the good ideas from the
ANSI/IEEE-754 standard for double-precision floating-point arithmetic
(53-bit mantissa).

%description -n libmpfr-devel
This package provides the header files and the symbolic links necessary
to allow compilation and linking of programs that use the libraries
provided by %libmpfr package.

%description -n libmpfr-devel-static
This package provides static library necessary to allow static linking
of MPFR-based programs.

%prep
%setup
rm m4/l*.m4
%patch -p1
awk '/__MPFR_DECLSPEC/{decl=1}decl&&/_MPFR_PROTO/{decl=0;print}' src/mpfr.h |
	sed -n 's/^.*[[:space:]*]\+\([^[:space:]*]\+\)[[:space:]]\+_MPFR_PROTO.*/\1/p' \
	>>src/libmpfr.sym
sort -u -o src/libmpfr.sym{,}

%build
%autoreconf
%define docdir %_docdir/mpfr-%version
%configure --enable-shared %{subst_enable static} --docdir=%docdir
%make_build

%install
%makeinstall_std
install -pm644 %_sourcedir/mpfrxx.h %buildroot%_includedir/

%check
%make_build -k check

%files -n %libmpfr
%_libdir/*.so.*
%dir %docdir
%docdir/[ABN]*
%exclude %docdir/COPYING*

%files -n libmpfr-devel
%_libdir/*.so
%_includedir/*
%_infodir/*
%dir %docdir
%docdir/[FTe]*

%if_enabled static
%files -n libmpfr-devel-static
%_libdir/*.a
%endif

%changelog
