%define set_disable() %{expand:%%force_disable %{1}} %{expand:%%undefine _enable_%{1}}
%define set_enable() %{expand:%%force_enable %{1}} %{expand:%%undefine _disable_%{1}}
%define set_without() %{expand:%%force_without %{1}} %{expand:%%undefine _with_%{1}}
%define subst_enable_to() %{expand:%%{?_enable_%{1}:--enable-%{2}}} %{expand:%%{?_disable_%{1}:--disable-%{2}}}
%define subst_o() %{expand:%%{?_enable_%{1}:%{1},}}
%define subst_o_pre() %{expand:%%{?_enable_%{2}:%{1}%{2},}}
%define subst_o_post() %{expand:%%{?_enable_%{1}:%{1}%{2},}}

%define prerel %nil
#define svnrev 32772
%define lname mplayer
%define gname g%lname
%define Name MPlayer
%define subrel %nil

#---------------------- BEGIN OF PARAMETERS -------------------------------------

# Optional features:
%def_enable mplayer
%def_enable mencoder
%def_enable xss
%def_enable lame
%def_disable lame_lavc
%def_enable gui
%def_disable gtk1
%def_enable termcap
%def_enable termios
%def_enable iconv
%def_enable shm
%def_enable langinfo
%def_enable lirc
%def_disable lircc
%def_enable joystick
%def_enable apple_ir
%def_enable xf86keysym
%def_enable tv
%def_disable tv_v4l1
%def_enable tv_v4l2
%def_enable v4l2
%def_enable radio
%def_disable radio_v4l1
%def_enable radio_v4l2
%def_enable radio_capture
%def_enable pvr
%def_enable rtc
%def_enable network
%def_disable winsock2
%def_enable smb
%def_disable live
%def_enable vcd
%def_enable bluray
%def_enable dvdnav
%def_enable dvdread
%def_disable dvdread_int
%def_enable cdparanoia
%def_enable bitmap_font
%def_enable freetype
%def_enable fontconfig
%def_enable unrarexec
%def_enable osdmenu
%def_enable sortsub
%def_enable fribidi
%def_enable enca
%def_enable inet6
%def_disable sctp
%def_enable ftp
%def_disable vstream
%def_enable pthreads
%def_enable ass
%def_disable ass_int
%def_disable rpath
%def_enable cddb
%def_enable librtmp
%def_disable nemesi

# Codecs:
%def_enable mng
%def_enable gif
%def_enable png
%def_enable jpeg
%def_enable openjpeg
%def_enable libcdio
%def_disable libgtop
%def_enable lzo
%def_enable win32
%def_enable qtx
%def_enable xanim
%def_enable real
%def_enable xvid
%def_enable xvid_lavc
%def_enable x264
%def_disable x264_lavc
%def_enable ffmpeg
%def_disable shared_ffmpeg
%def_enable postproc
%def_disable vf_lavfi
%def_disable libavcodec_mpegaudio_hp
%def_enable faad
%def_disable tremor_internal
%def_disable tremor_low
%def_disable tremor
%def_enable vorbis
%def_enable speex
%def_enable theora
%def_disable faac
%def_disable faac_lavc
%def_enable ladspa
%def_enable bs2b
%def_enable dca
%def_enable libdv
%def_enable crystalhd
%def_enable mad
%def_disable toolame
%def_disable twolame
%def_disable xmms
%def_enable mp3lib
%def_enable liba52
%def_enable libmpeg2
%def_disable libmpeg2_int
%def_enable musepack
%def_disable dirac
%def_disable nut
%def_disable libschroedinger_lavc
%def_disable libdvdcss_internal
%def_enable libgsm
%def_enable amrnb
%def_enable amrwb
%def_enable libvpx_lavc

# Video output:
%def_disable vidix
%def_enable gl
%def_disable dga1
%def_disable dga2
%def_disable vesa
%def_disable svga
%def_enable sdl
%def_enable aa
%def_enable caca
%def_disable ggi
%def_disable ggiwmh
%def_disable directx
%def_disable dxr2
%def_disable dxr3
%def_disable ivtv
%def_enable dvb
%def_disable mga
%def_disable xmga
%def_enable xv
%def_disable xvmc
%define xvmclib XvMCW
%def_enable vm
%def_enable xinerama
%def_enable x11
%def_enable xshape
%def_enable fbdev
%def_disable mlib
%def_disable 3dfx
%def_disable tdfxfb
%def_disable s3fb
%def_disable directfb
%def_disable zr
%def_disable bl
%def_disable tdfxvid
%def_disable tga
%def_enable pnm
%def_enable md5sum
%def_enable vdpau
%def_enable vaapi
%def_enable xrender
%def_disable matrixview
%def_enable mpg123
%def_enable yuv4mpeg
%def_disable xvr100

# Audio output:
%def_enable alsa
%def_enable oss
%def_disable arts
%def_disable esd
%def_enable pulse
%def_enable jack
%def_disable openal
%def_disable nas
%def_disable sgiaudio
%def_disable sunaudio
%def_disable waveout
%def_enable select
%def_disable dart
%def_disable kai
%def_disable kva

# Miscellaneous options:
%def_enable cpu_detection
%def_enable yasm
#define asm as
%define charset UTF-8
%define language all

# Advanced options:
%ifarch %ix86 x86_64
%def_enable mmx
%def_enable mmxext
%def_enable 3dnow
%def_enable 3dnowext
%def_enable sse
%def_enable sse2
%def_enable ssse3
%def_disable altivec
%endif
%def_enable fastmemcpy
%def_disable debug
%def_disable profile
%def_enable sighandler
%def_disable gdb
%def_enable dynamic_plugins

%define termcaplib tinfo

# Other parameters
%def_enable nls
%def_with htmldocs
%def_with tools
%define default_vo %{subst_o xv}%{subst_o sdl}%{subst_o gl2}%{subst_o gl}%{subst_o x11}%{subst_o_pre x vidix}%{subst_o mga}%{subst_o dfbmga}%{subst_o tdfxfb}%{subst_o 3dfx}%{subst_o s3fb}%{subst_o_pre c vidix}%{subst_o_post fbdev 2}%{subst_o vesa}%{subst_o caca}%{subst_o aa}null
%define default_ao %{subst_o alsa}%{subst_o oss}%{subst_o openal}%{subst_o sdl}%{subst_o pulse}%{subst_o nas}null

# ARM
#%%def_disable armv5te
#%%def_disable armv6
#%%def_disable armv6t2
#%%def_disable armvfp
#%%def_disable iwmmxt
#%%def_disable neon

#---------------------- END OF PARAMETERS ---------------------------------------

%{?_disable_mencoder:%set_disable lame}

%if_disabled tv
%set_disable v4l1
%set_disable v4l2
%set_disable pvr
%endif

%if_disabled network
%set_disable live
%set_disable ftp
%endif

%{?_enable_shared_ffmpeg:%set_disable zr}

%if_enabled nls
%define awk gawk
%set_enable iconv
%{!?charset:%define charset UTF-8}
#%%undefine language
#%%define language en
%else
%define awk awk
%endif

%{?_disable_ffmpeg:%set_disable shared_ffmpeg}
%{?_disable_iconv:%set_disable freetype}
%{?_disable_freetype:%set_disable fontconfig}

%ifnarch %ix86 x86_64
%set_disable yasm
%set_disable vidix
%set_disable cpu_detection
%endif

%{?_enable_tremor:%set_disable tremor_low}

%ifnarch %ix86
%set_disable win32
%endif

%ifnarch ppc
%set_disable altivec
%endif

%define win32_libdir %_libdir/w32codec
%define xanim_libdir %_libdir/xanim
%define real_libdir %_libdir/real

%{?_disable_win32:%set_disable qtx}

%if_disabled x11
%set_disable xv
%set_disable xvmc
%set_disable xinerama
%set_disable xf86keysym
%set_disable vm
%set_disable vdpau
%set_disable vaapi
%set_disable xrender
%set_disable dga1
%set_disable dga2
%endif

%if_disabled mplayer
%set_without tools
%set_disable gui
%endif


Name: %lname
Version: 1.1.1
Release: alt16
%ifdef svnrev
%define pkgver svn-r%svnrev
%else
%define pkgver %version%prerel
%endif
Summary: Media player
Summary(uk_UA.CP1251): 
Summary(ru_RU.CP1251): 
License: GPLv2+
Group: Video
URL: http://www.mplayerhq.hu
Packager: Afanasov Dmitry <ender@altlinux.org>
%if %name != %Name
Provides: %Name = %version-%release
Obsoletes: %Name
%endif
%if_enabled freetype
%{?_disable_fontconfig:Requires: fonts-type1-urw}
Conflicts: %Name-fonts < 1.0-alt28
Conflicts: %name-i18n < 1.0-35.22229.1
Obsoletes: %Name-fonts
%else
Requires: %name-fonts
%endif
Source0: %Name-%pkgver.tar
# register console mplayer as mime handler
Source2: %lname.desktop
Source4: standard-1.9.tar
Source5: %lname.conf.in
Patch0: %name-%version-%release.patch
Patch1: %name-%version-nls.patch
Patch2: %name-%version-vaapi.patch

%if_enabled gui
Provides: %name-gui = %version-%release
Obsoletes: %name-gui
Provides: %gname = %version-%release
Obsoletes: %Name-skin-default
%if %name != %Name
Provides: %Name-gui = %version-%release
Obsoletes: %Name-gui
%endif
%endif

BuildRequires: %awk libncurses-devel libslang-devel zlib-devel
BuildRequires: cpp >= 3.3 gcc >= 3.3 gcc-c++ >= 3.3
%{?svnrev:%{?_with_htmldocs:BuildRequires: docbook-style-xsl xsltproc sgml-common docbook-dtds}}

%{?_enable_mencoder:%{?_enable_lame:BuildRequires: liblame-devel}}
%{?_enable_termcap:BuildRequires: libtinfo-devel}
%{?_enable_smb:BuildRequires: libsmbclient-devel >= 3.0.3}
%{?_enable_live:BuildRequires: liblive555-devel >= 0.0.0-alt0.2006.03.03}
%{?_enable_bluray:BuildRequires: libbluray-devel}
%{?_enable_dvdnav:BuildRequires: libdvdnav-devel >= 0.1.10-alt4}
%{?_enable_dvdread:BuildRequires: libdvdread-devel}
%{?_enable_cdparanoia:BuildRequires: libcdparanoia-devel}
%{?_enable_vstream:BuildRequires: libvstream-client-devel}
%{?_enable_sctp:BuildRequires: libsctp-devel}
%if_enabled mplayer
%{?_enable_lirc:BuildRequires: liblirc-devel}
%{?_enable_lircc:BuildRequires: lirccd-devel}
%{?_enable_freetype:BuildRequires: libfreetype-devel >= 2.0.9}
%{?_enable_fontconfig:BuildRequires: fontconfig-devel}
%{?_enable_fribidi:BuildRequires: libfribidi-devel}
%{?_enable_enca:BuildRequires: libenca-devel}
%endif

%{?_enable_vdpau:BuildRequires: libvdpau-devel}
%{?_enable_vaapi:BuildRequires: pkgconfig(libva) pkgconfig(libva-glx) %{?_enable_xrender:libXrender-devel}}
%{?_enable_gif:BuildRequires: libungif-devel}
%{?_enable_mng:BuildRequires: libmng-devel}
%{?_enable_png:BuildRequires: libpng-devel}
%{?_enable_jpeg:BuildRequires: libjpeg-devel}
%{?_enable_openjpeg:BuildRequires: libopenjpeg-devel}
%{?_enable_libcdio:BuildRequires: libcdio-devel libcdio-paranoia-devel}
%{?_enable_libgtop:BuildRequires: pkgkonfig(libgtop-2.0)}
%{?_enable_lzo:BuildRequires: liblzo2-devel}
%{?_enable_xvid:BuildRequires: libxvid-devel}
%{?_enable_x264:BuildRequires: libx264-devel}
%{?_enable_shared_ffmpeg:BuildRequires: libffmpeg-devel >= 1:0.5-alt1}
%{?_enable_tremor:BuildRequires: libtremor-devel}
%{?_enable_vorbis:BuildRequires: libvorbis-devel}
%{?_enable_speex:BuildRequires: libspeex-devel >= 1.1}
%{?_enable_theora:BuildRequires: libtheora-devel}
%{?_enable_faad:BuildRequires: libfaad-devel}
%{?_enable_faac:BuildRequires: libfaac-devel}
%{?_enable_ladspa:BuildRequires: ladspa_sdk}
%{?_enable_bs2b:BuildRequires: libbs2b-devel}
%{?_enable_libdv:BuildRequires: libdv-devel}
%{?_enable_crystalhd:BuildRequires: libcrystalhd-devel}
%{?_enable_mad:BuildRequires: libmad-devel}
%{?_enable_xmms:BuildRequires: libxmms-devel}
%{?_enable_liba52:BuildRequires: liba52-devel}
%{?_enable_libmpeg2:BuildRequires: libmpeg2-devel}
%{?_enable_musepack:BuildRequires: libmpcdec-devel >= 1.2.1}
%{?_enable_nut:BuildRequires: libnut-devel >= 0.0-alt0.272}
%{?_enable_amrnb:BuildRequires: libopencore-amrnb-devel}
%{?_enable_amrwb:BuildRequires: libopencore-amrwb-devel}
%{?_enable_dirac:BuildRequires: libdirac-devel >= 0.10}
%{?_enable_dca:BuildRequires: libdca-devel}
%{?_enable_libgsm:BuildRequires: libgsm-devel}
%{?_enable_libvpx_lavc:BuildRequires: libvpx-devel}
%{?_enable_librtmp:BuildRequires: librtmp-devel}
%{?_enable_nemesi:BuildRequires: libnemesi-devel}
%{?_enable_mpg123:BuildRequires: libmpg123-devel}
%{?_enable_ass:BuildRequires: libass-devel}

%{?_enable_xvmc:BuildRequires: libXvMC-devel}
%if_enabled mplayer
%{?_enable_xss:BuildRequires: libXScrnSaver-devel}
%{?_enable_xshape:BuildRequires: libXext-devel}
%{?_enable_gl:BuildRequires: libGL-devel}
%{?_enable_vesa:BuildRequires: libvbe-devel}
%{?_enable_svga:BuildRequires: svgalib-devel}
%{?_enable_sdl:BuildRequires: libSDL-devel >= 1.1.7 libSDL_mixer-devel}
%{?_enable_aa:BuildRequires: aalib-devel libgpm-devel libslang-devel libX11-devel}
%{?_enable_caca:BuildRequires: libcaca-devel libslang-devel libX11-devel}
%{?_enable_ggi:BuildRequires: libggi-devel}
%{?_enable_dxr3:BuildRequires: libdxr3-devel}
%{?_enable_xv:BuildRequires: libXv-devel}
%{?_enable_vm:BuildRequires: libXxf86vm-devel}
%{?_enable_xinerama:BuildRequires: libXinerama-devel}
%{?_enable_x11:BuildRequires: libXt-devel xorg-xextproto-devel}
%{?_enable_dga1:BuildRequires: libXxf86dga-devel}
%{?_enable_dga2:BuildRequires: libXxf86dga-devel}
%{?_enable_directfb:BuildRequires: libdirectfb-devel}
%{?_enable_pnm:BuildRequires: libnetpbm-devel}

%{?_enable_alsa:BuildRequires: libalsa-devel}
%{?_enable_arts:BuildRequires: libarts-devel}
%{?_enable_esd:BuildRequires: esound-devel}
%{?_enable_pulse:BuildRequires: libpulseaudio-devel >= 0.9}
%{?_enable_jack:BuildRequires: jackit-devel}
%{?_enable_openal:BuildRequires: libopenal-devel}
%{?_enable_nas:BuildRequires: libaudio-devel}

%{?_enable_gui:BuildRequires: ImageMagick-tools desktop-file-utils gtk+%{?_disable_gtk1:2}-devel}
%endif

%{?_enable_nls:BuildRequires: gettext-tools}

%{?_with_tools:BuildRequires: perl-libwww perl-Math-BigInt libSDL_image-devel normalize termutils vcdimager}

%{?_enable_yasm:BuildRequires: yasm}

%description
%Name is a movie and animation player that supports a wide range of file
formats, including AVI, MPEG, and Quicktime. It has many MMX/SSE/3DNow! etc.
optimized native audio and video codecs, but allows using XAnim's and
RealPlayer's binary codec plugins, and Win32 codec DLLs. It has basic VCD/DVD
playback functionality, including DVD subtitles, but supports many text-based
subtitle formats too.
For video and audio output, nearly every existing interface is supported
including some low-level card-specific drivers (for Matrox, Nvidia, 3Dfx and
Radeon, Mach64, Permedia3), hardware AC3 decoding and few hardware MPEG decoding
boards such as DVB and DXR3/Hollywood+.
It also supports video grabbing from V4L devices.

%description -l ru_RU.CP1251
%Name -  ,     
,    AVI, MPEG  Quicktime.     - 
,   MMX, SSE, 3DNow! ...  , 
   : XAnim, RealPlayer  Win32. 
    VCD/DVD,   DVD,  
    .
        
 .     
 : Matrox, Nvidia, 3Dfx, Radeon, Mach64, Permedia3, 
 AC3,    ,   MPEG, 
 DVB  DXR3/Hollywood+.
 , %Name      V4L.


%if_enabled mencoder
%package -n mencoder
Group: Video
Summary: Movie encoder for Unix.
Summary(ru_RU.CP1251):    Unix.
Provides: MEncoder = %version-%release
Conflicts: %Name < 1.0-alt28

%description -n mencoder
MEncoder a movie encoder for Unix and is a part of the %name package.
%endif


%if_with tools
%package tools
Group: Video
Summary: %Name/MEncoder tools
%if_enabled mencoder
Provides: mencoder-tools = %version-%release
Requires: mencoder
%endif
Requires: %name


%description tools
Nice scripts and code that makes using %Name and MEncoder easier, for example
scripts for DVD track encoding in three pass mode or creating SVCDs from a movie.
%endif


%if_with htmldocs
%package docs
Group: Documentation
Summary: %Name all docs
BuildArch: noarch
Requires: %name-doc-tech
Requires: %name-doc-en
Requires: %name-doc-world
Requires: %name-doc-ru
%if %name != %Name
Provides: %Name-docs
Obsoletes: %Name-docs
%endif

%description docs
%Name all docs.


%package doc-tech
Group: Documentation
Summary: %Name Tech docs
BuildArch: noarch

%description doc-tech
%Name Tech docs.


%package doc-en
Group: Documentation
Summary: %Name English docs
BuildArch: noarch
Obsoletes: %Name-doc
Provides: %Name-doc
%if %name != %Name
Provides: %Name-doc-en = %version-%release
Obsoletes: %Name-doc-en
%endif

%description doc-en
%Name English docs.


%package doc-world
Group: Documentation
Summary: %Name docs
BuildArch: noarch
Conflicts: %name-doc-cs %name-doc-de %name-doc-es %name-doc-fr
Conflicts: %name-doc-hu %name-doc-it %name-doc-pl %name-doc-zh_CN

%description doc-world
%Name docs (exept English and Russian.


%package doc-ru
Group: Documentation
Summary: %Name Russian docs
BuildArch: noarch
%if %name != %Name
Provides: %Name-doc-ru = %version-%release
Obsoletes: %Name-doc-ru
%endif

%description doc-ru
%Name Russian docs.
%endif


%package i18n
Group: Video
Summary: Languages support for %Name
BuildArch: noarch
%{?_enable_mencoder:Provides: mencoder-i18n = %version-%release}
Requires: %name-i18n-world = %version-%release
Requires: %name-i18n-ru = %version-%release
%{?_enable_nls:Requires: %name-i18n-uk = %version-%release}

%description i18n
Languages support for %Name.


%package i18n-world
Group: Video
Summary: Languages support for %Name
BuildArch: noarch
Conflicts: %name-i18n < 1.0-35.22229.1
%{?_enable_mencoder:Provides: mencoder-i18n-world = %version-%release}

%description i18n-world
Languages support for %Name (except ru%{?_enable_nls: and uk}).


%package i18n-ru
Group: Video
Summary: Russian language support for %Name
BuildArch: noarch
Conflicts: %name-i18n < 1.0-35.22229.1
%{?_enable_mencoder:Provides: mencoder-i18n-ru = %version-%release}

%description i18n-ru
Russian language support for %Name.


%if_enabled nls
%package i18n-uk
Group: Video
Summary: Ukrainian language support for %Name
BuildArch: noarch
Conflicts: %name-i18n < 1.0-35.22229.1
%{?_enable_mencoder:Provides: mencoder-i18n-uk = %version-%release}

%description i18n-uk
Ukrainian language support for %Name.
%endif


%prep
%setup -q -n %Name-%pkgver
%patch0 -p1
%patch1 -p1
%patch2 -p1

%{?svnrev:subst 's/UNKNOWN/%svnrev/' version.sh}

subst 's|\\/\\/|//|g' help/help_mp-zh_??.h
sed -i '/\(VP8E_UPD_ENTROPY\|VP8E_UPD_REFERENCE\|VP8E_USE_REFERENCE\)/d' ffmpeg/libavcodec/libvpxenc.c
ls DOCS/man/*/%lname.1 | grep -v '^DOCS/man/en/' | xargs sed -i '1i.\\" -*- mode: troff; coding: utf-8 -*-'
echo "NotShowIn=KDE;" >> etc/%lname.desktop

%build
%define _optlevel 3
%add_optflags -Wno-switch-enum -Wno-switch
%ifarch armh
%add_optflags -Wa,-mimplicit-it=thumb
%endif
export CFLAGS="%optflags"
./configure \
	--target=%_target \
	--prefix=%_prefix \
	--bindir=%_bindir \
	--mandir=%_mandir \
	--libdir=%_libdir \
	--datadir=%_datadir/%name \
	--confdir=%_sysconfdir/%name \
	--extra-cflags="%optflags %{?_enable_smb:$(pkg-config --cflags smbclient)}" \
	%{subst_enable mplayer} \
	--extra-libs-mplayer="-lvorbisenc" \
	%{subst_enable mencoder} \
	--extra-libs-mencoder="-lvorbisenc" \
	%{subst_enable xss} \
	%{subst_enable_to lame mp3lame} \
	%{subst_enable_to lame mp3lame-lavc} \
	%{subst_enable gui} \
	%{subst_enable gtk1} \
	%{subst_enable termcap} \
	%{subst_enable termios} \
	%{subst_enable nls} \
	%{subst_enable iconv} \
	%{subst_enable shm} \
	%{subst_enable langinfo} \
	%{subst_enable lirc} \
	%{subst_enable lircc} \
	%{subst_enable joystick} \
	%{subst_enable_to apple_ir apple-ir} \
	%{subst_enable xf86keysym} \
	%{subst_enable tv} \
	%{subst_enable_to tv_v4l1 tv-v4l1} \
	%{subst_enable_to tv_v4l2 tv-v4l2} \
	%{subst_enable radio} \
	%{subst_enable_to radio_v4l1 radio-v4l} \
	%{subst_enable_to radio_v4l2 radio-v4l2} \
	%{subst_enable_to radio_capture radio-capture} \
	%{subst_enable pvr} \
	%{subst_enable rtc} \
	%{subst_enable_to network networking} \
	%{subst_enable winsock2}_h \
	%{subst_enable smb} \
	%{subst_enable live} \
	%{subst_enable dvdnav} \
	%{subst_enable dvdread} \
	%{subst_enable vdpau} \
	%{subst_enable vaapi} \
	%{subst_enable xrender} \
	%{subst_enable_to dvdread_int dvdread-internal} \
	%{subst_enable cdparanoia} \
	%{subst_enable_to bitmap_font bitmap-font} \
	%{subst_enable freetype} \
	%{subst_enable fontconfig} \
	%{subst_enable unrarexec} \
	%{subst_enable_to osdmenu menu} \
	%{subst_enable sortsub} \
	%{subst_enable fribidi} \
	%{subst_enable enca} \
	%{subst_enable inet6} \
	%{subst_enable ftp} \
	%{subst_enable vstream} \
	%{subst_enable pthreads} \
	%{subst_enable ass} \
	%{subst_enable_to ass_int ass-internal} \
	%{subst_enable rpath} \
	%{subst_enable bluray} \
	%{subst_enable cddb} \
	%{subst_enable librtmp} \
	%{subst_enable nemesi} \
	%{subst_enable mng} \
	%{subst_enable gif} \
	%{subst_enable png} \
	%{subst_enable jpeg} \
	%{subst_enable_to openjpeg libopenjpeg} \
	%{subst_enable libcdio} \
	%{subst_enable_to lzo liblzo} \
	%{subst_enable_to win32 win32dll} \
	%{?_enable_win32:--codecsdir=%win32_libdir} \
	%{subst_enable qtx} \
	%{subst_enable xanim} \
	%{subst_enable real} \
	%{subst_enable xvid} \
	%{subst_enable_to xvid_lavc xvid-lavc} \
	%{subst_enable x264} \
	%{subst_enable_to x264_lavc x264-lavc} \
%if_enabled ffmpeg
%if_enabled shared_ffmpeg
	--disable-ffmpeg_a \
	--enable-ffmpeg_so \
%else
	--disable-ffmpeg_so \
	--enable-ffmpeg_a \
%endif
%else
	--disable-ffmpeg_a \
	--disable-ffmpeg_so \
%endif
	%{subst_enable postproc} \
	%{subst_enable_to vf_lavfi vf-lavfi} \
	%{subst_enable libavcodec_mpegaudio_hp} \
	%{subst_enable_to tremor_internal tremor-internal} \
	%{subst_enable_to tremor_low tremor-low} \
	%{subst_enable tremor} \
	%{subst_enable_to vorbis libvorbis} \
	%{subst_enable speex} \
	%{subst_enable theora} \
	%{subst_enable faad} \
	%{subst_enable faac} \
	%{subst_enable_to faac_lavc faac-lavc} \
	%{subst_enable ladspa} \
	%{subst_enable_to bs2b libbs2b} \
	%{subst_enable_to dca libdca} \
	%{subst_enable libdv} \
	%{subst_enable crystalhd} \
	%{subst_enable mad} \
	%{subst_enable toolame} \
	%{subst_enable twolame} \
	%{subst_enable xmms} \
	%{subst_enable mp3lib} \
	%{subst_enable liba52} \
	%{subst_enable libmpeg2} \
	%{subst_enable_to libmpeg2_int libmpeg2-internal} \
	%{subst_enable_to dirac libdirac-lavc} \
	%{subst_enable musepack} \
	%{subst_enable_to nut libnut} \
	%{subst_enable_to libschroedinger_lavc libschroedinger-lavc} \
	%{subst_enable_to libdvdcss_internal libdvdcss-internal} \
	%{subst_enable libgsm} \
	%{subst_enable_to amrnb libopencore_amrnb} \
	%{subst_enable_to amrwb libopencore_amrwb} \
	%{subst_enable_to libvpx_lavc libvpx-lavc} \
	%{subst_enable vidix} \
	%{subst_enable gl} \
	%{subst_enable dga1} \
	%{subst_enable dga2} \
	%{subst_enable vesa} \
	%{subst_enable svga} \
	%{subst_enable sdl} \
	%{subst_enable aa} \
	%{subst_enable caca} \
	%{subst_enable ggi} \
	%{subst_enable ggiwmh} \
	%{subst_enable directx} \
	%{subst_enable dxr2} \
	%{subst_enable dxr3} \
	%{subst_enable ivtv} \
	%{subst_enable dvb} \
	%{subst_enable mga} \
	%{subst_enable xmga} \
	%{subst_enable xv} \
	%{subst_enable xvmc} \
	%{?_enable_xvmc:%{?xvmclib:--with-xvmclib=%xvmclib}} \
	%{subst_enable vm} \
	%{subst_enable xinerama} \
	%{subst_enable x11} \
	%{subst_enable xshape} \
	%{subst_enable fbdev} \
	%{subst_enable mlib} \
	%{subst_enable 3dfx} \
	%{subst_enable tdfxfb} \
	%{subst_enable s3fb} \
	%{subst_enable directfb} \
	%{subst_enable zr} \
	%{subst_enable bl} \
	%{subst_enable tdfxvid} \
	%{subst_enable tga} \
	%{subst_enable pnm} \
	%{subst_enable md5sum} \
	%{subst_enable matrixview} \
	%{subst_enable mpg123} \
	%{subst_enable yuv4mpeg} \
	%{subst_enable xvr100} \
	%{subst_enable alsa} \
	%{subst_enable_to oss ossaudio} \
	%{subst_enable arts} \
	%{subst_enable esd} \
	%{subst_enable pulse} \
	%{subst_enable jack} \
	%{subst_enable openal} \
	%{subst_enable nas} \
	%{subst_enable sgiaudio} \
	%{subst_enable sunaudio} \
	%{subst_enable_to waveout win32waveout} \
	%{subst_enable select} \
	%{subst_enable dart} \
	%{subst_enable kai} \
	%{subst_enable kva} \
	%{subst_enable select} \
	%{subst_enable_to cpu_detection runtime-cpudetection} \
	--cc=%__cc \
	%{?asm:--as=%asm} \
	--charset=%{?charset:%charset}%{!?charset:UTF-8} \
	--language=%{?language:"%language"}%{!?language:all} \
	%{subst_enable mmx} \
	%{subst_enable mmxext} \
	%{subst_enable 3dnow} \
	%{subst_enable 3dnowext} \
	%{subst_enable sse} \
	%{subst_enable sse2} \
	%{subst_enable ssse3} \
	%{subst_enable altivec} \
	%{subst_enable fastmemcpy} \
	%{subst_enable profile} \
	%{subst_enable sighandler} \
	%{subst_enable_to gdb crash-debug} \
	%{subst_enable_to dynamic_plugins dynamic-plugins} \
%if_enabled debug
	--enable-debug=3
%else
	--disable-debug
%endif

%make_build

%{?_enable_nls:%make_build -C po}

# make conf file
sed	-e 's/^@VO@/vo = %default_vo/' \
	-e 's/^@AO@/ao = %default_ao/' \
	-e 's|@CONF_FILE@|%_sysconfdir/%name/%lname.conf|g' \
	-e 's|@SKINS_DIR@|%_datadir/%name/skins|g' \
	%SOURCE5 > etc/%lname.conf
echo "fontconfig = %{?_enable_fontconfig:yes}%{?_disable_fontconfig:no}" >> etc/%lname.conf

%{?_with_tools:%make_build tools}

# build HTML documentation from XML files
%{?_with_htmldocs:%{?svnrev:%make_build -C DOCS/xml html-chunked}}

%if_enabled gui
for s in 128 96 72 64 48 36 32 24 22 16; do
	S=${s}x$s
	[ -e etc/%{lname}$S.png ] || convert -resize $S etc/%{lname}{256x256,$S}.png
done
%endif

gzip -9c Changelog > Changelog.gz


%install
%makeinstall_std

%if_enabled mplayer
install -d -m 0755 %buildroot%_docdir/%name-%version
install -p -m 0644 README AUTHORS Changelog.* %buildroot%_docdir/%name-%version/
install -p -m 0644 etc/{codecs,input,%lname}.conf %buildroot%_sysconfdir/%name/
%if_enabled gui
install -d -m 0755 %buildroot%_datadir/%name/skins
tar -C %buildroot%_datadir/%name/skins -xf %SOURCE4
ln -s standard %buildroot%_datadir/%name/skins/default
install -d -m 0755 %buildroot%_datadir/%name/skins/0
convert -size 8x1 xc:black -define png:format=png24 %buildroot%_datadir/%name/skins/0/0.png
cat >> %buildroot%_datadir/%name/skins/0/skin <<__EOF__
section = movieplayer
  window = main
    decoration = disable
    base = 0, 0, 0
  end
  window = video
    base = 0, -1, -1, 640, 480
    background = 0, 0, 0
  end
end
__EOF__
%endif
%{?_enable_freetype:%{?_disable_fontconfig:ln -s ../fonts/type1/urw/n019003l.pfb %buildroot%_datadir/%name/subfont.ttf}}
%{?_enable_osdmenu:install -p -m 0644 etc/menu.conf %buildroot%_sysconfdir/%name/}
%{?_enable_dvb:install -p -m 0644 etc/dvb-menu.conf %buildroot%_sysconfdir/%name/}

%if_with tools
install -p -m 0755 TOOLS/{alaw-gen,asfinfo,avi-fix,avisubdump,dump_mp4,movinfo,netstream,subrip,vivodump} %buildroot/%_bindir/
for f in vobshift; do
	install -p -m 0755 TOOLS/$f.py %buildroot/%_bindir/$f
done
for f in calcbpp countquant plotpsnr subedit wma2ogg %{?_enable_mencoder:dvd2divxscript}; do
	install -p -m 0755 TOOLS/$f.pl %buildroot/%_bindir/$f
done
%ifarch %ix86
install -p -m 0755 TOOLS/w32codec_dl.pl %buildroot/%_bindir/w32codec_dl
%endif
for f in aconvert divx2svcd mencvcd midentify mpconsole mplmult psnr-video subsearch %{?_enable_mencoder:qepdvcd}; do
	install -p -m 0755 TOOLS/$f.sh %buildroot/%_bindir/$f
done
install -pD -m 0644 {TOOLS,%buildroot%_docdir/%name-tools-%version}/README
%endif
%endif

# docs
for l in $(ls DOCS/man | grep -v '^en$'); do
%if_enabled mplayer
	install -pD -m 0644 DOCS/man/$l/%lname.1 %buildroot%_mandir/$l/man1/%lname.1
	%{?_enable_mencoder:ln -sf %lname.1 %buildroot%_mandir/$l/man1/mencoder.1}
%else
	%{?_enable_mencoder:install -pD -m 0644 DOCS/man/$l/mencoder.1 %buildroot%_mandir/$l/man1/mencoder.1}
%endif
done
rm -f %buildroot%_man1dir/mencoder.1
%{?_enable_mencoder:install -p -m 0644 DOCS/man/en/%lname.1 %buildroot%_man1dir/mencoder.1}
%if_with htmldocs
for l in cs de en es fr hu it pl ru zh_CN; do
	install -d %buildroot%_docdir/%name-%version/$l
	install -p -m 0644 DOCS/HTML/$l/{*.html,*.css} %buildroot%_docdir/%name-%version/$l/
done
%endif
install -d %buildroot%_docdir/%name-%version/tech/realcodecs
install -p -m 0644 DOCS/tech/{MAINTAINERS,TODO,*.txt,mpsub.sub,playtree,wishlist} %buildroot%_docdir/%name-%version/tech/
install -p -m 0644 DOCS/tech/realcodecs/{TODO,*.txt} %buildroot%_docdir/%name-%version/tech/realcodecs/
%find_lang --with-man %lname %lname-man

%if_enabled nls
for l in po/*.gmo; do
	install -pD -m 0644 $l %buildroot%_datadir/locale/$(basename $l .gmo)/LC_MESSAGES/%name.mo
done
%find_lang %lname
%endif

%if_enabled gui
for s in 256 128 96 72 64 48 36 32 24 22 16; do
	S=${s}x$s
	install -pD -m 0644 {etc/%lname$S,%buildroot%_iconsdir/hicolor/$S/apps/%lname}.png
done
install -pD -m 0644 {etc/%lname,%buildroot%_desktopdir/%gname}.desktop
%endif

%{?_enable_mplayer:install -pD -m 0644 %SOURCE2 %buildroot/%_desktopdir/%lname.desktop}

%{?_enable_mplayer:%{?_enable_vidix:%add_verify_elf_skiplist %_libdir/%lname/vidix/*}}


%if_enabled mplayer
%files
%doc %dir %_docdir/%name-%version
%doc %_docdir/%name-%version/README
%doc %_docdir/%name-%version/AUTHORS
%_bindir/%lname
%_man1dir/%lname.*
%dir %_sysconfdir/%name
%config %_sysconfdir/%name/codecs.conf
%config(noreplace) %verify(not size mtime md5) %_sysconfdir/%name/%lname.conf
%config(noreplace) %verify(not size mtime md5) %_sysconfdir/%name/input.conf
%{?_enable_osdmenu:%config(noreplace) %verify(not size mtime md5) %_sysconfdir/%name/menu.conf}
%{?_enable_dvb:%config(noreplace) %verify(not size mtime md5) %_sysconfdir/%name/dvb-menu.conf}
%dir %_datadir/%name
%_desktopdir/%lname.desktop
%if_disabled fontconfig
%if_enabled freetype
%config(missingok,noreplace) %verify(not link size mtime md5) %_datadir/%name/subfont.ttf
%else
%_datadir/%name/font
%endif
%endif
%if_enabled gui
%_bindir/%gname
%_desktopdir/%gname.desktop
#%%_datadir/pixmaps/*
%_iconsdir/hicolor/*/apps/*
%_datadir/%name/skins
%endif


%if_enabled mencoder
%files -n mencoder
%_bindir/mencoder
%_man1dir/mencoder.*
%if_disabled mplayer
%doc README AUTHORS Changelog.*
%dir %_sysconfdir/%name
%config %_sysconfdir/%name/codecs.conf
%endif
%endif


%if_with tools
%files tools
%_docdir/%name-tools-%version
%_bindir/*
%{?_enable_mplayer:%exclude %_bindir/%lname}
%{?_enable_mencoder:%exclude %_bindir/mencoder}
%{?_enable_gui:%exclude %_bindir/%gname}
%endif


%files docs


%files doc-world
%dir %_docdir/%name-%version
%lang(cs) %_docdir/%name-%version/cs
%lang(de) %_docdir/%name-%version/de
%lang(es) %_docdir/%name-%version/es
%lang(fr) %_docdir/%name-%version/fr
%lang(hu) %_docdir/%name-%version/hu
%lang(it) %_docdir/%name-%version/it
%lang(pl) %_docdir/%name-%version/pl
%lang(zh_CN) %_docdir/%name-%version/zh_CN


%files doc-tech
%dir %_docdir/%name-%version
%_docdir/%name-%version/tech
%_docdir/%name-%version/Changelog.*


%files doc-en
%dir %_docdir/%name-%version
%_docdir/%name-%version/en


%files doc-ru
%dir %_docdir/%name-%version
%_docdir/%name-%version/ru
%endif


%files i18n


%files i18n-ru
%_mandir/ru
%{?_enable_nls:%_datadir/locale/ru/LC_MESSAGES/*}


%if_enabled nls
%files i18n-uk
%_datadir/locale/uk/LC_MESSAGES/*
%endif


%files i18n-world
%lang(cs) %_mandir/cs
%lang(de) %_mandir/de
%lang(es) %_mandir/es
%lang(fr) %_mandir/fr
%lang(hu) %_mandir/hu
%lang(it) %_mandir/it
%lang(pl) %_mandir/pl
%lang(zh_CN) %_mandir/zh_CN
%if_enabled nls
%lang(bg) %_datadir/locale/bg/LC_MESSAGES/*
%lang(cs) %_datadir/locale/cs/LC_MESSAGES/*
%lang(de) %_datadir/locale/de/LC_MESSAGES/*
%lang(dk) %_datadir/locale/dk/LC_MESSAGES/*
%lang(el) %_datadir/locale/el/LC_MESSAGES/*
%lang(es) %_datadir/locale/es/LC_MESSAGES/*
%lang(fr) %_datadir/locale/fr/LC_MESSAGES/*
%lang(hu) %_datadir/locale/hu/LC_MESSAGES/*
%lang(it) %_datadir/locale/it/LC_MESSAGES/*
%lang(ja) %_datadir/locale/ja/LC_MESSAGES/*
%lang(ko) %_datadir/locale/ko/LC_MESSAGES/*
%lang(mk) %_datadir/locale/mk/LC_MESSAGES/*
%lang(nb) %_datadir/locale/nb/LC_MESSAGES/*
%lang(nl) %_datadir/locale/nl/LC_MESSAGES/*
%lang(pl) %_datadir/locale/pl/LC_MESSAGES/*
%lang(pt) %_datadir/locale/pt_BR/LC_MESSAGES/*
%lang(ro) %_datadir/locale/ro/LC_MESSAGES/*
%lang(sk) %_datadir/locale/sk/LC_MESSAGES/*
%lang(sv) %_datadir/locale/sv/LC_MESSAGES/*
%lang(tr) %_datadir/locale/tr/LC_MESSAGES/*
%lang(zh_CN) %_datadir/locale/zh_CN/LC_MESSAGES/*
%lang(zh_TW) %_datadir/locale/zh_TW/LC_MESSAGES/*
%endif


%changelog
