%def_enable gtk_doc

Name: muffin
Version: 3.4.1
Release: alt0.M80P.1

Summary: Window and compositing manager based on Clutter
License: GPLv2+
Group: Graphical desktop/GNOME

Url: https://github.com/linuxmint/muffin
# To generate tarball
# wget https://github.com/linuxmint/muffin/tarball/1.0.2 -O muffin-1.0.2.tar.gz
Source: %name-%version.tar

Requires: lib%name = %version-%release
Requires(post,preun): GConf
Requires: zenity

BuildPreReq: rpm-build-gir >= 0.7.1-alt6
BuildPreReq: libclutter-devel >= 1.7.5
BuildPreReq: libgtk+3-devel >= 3.3.3
BuildRequires: GConf libGConf-devel libcanberra-gtk3-devel libstartup-notification-devel
BuildRequires: libXrandr-devel libXcursor-devel libXcomposite-devel
BuildRequires: libXinerama-devel libXext-devel libSM-devel
BuildRequires: gtk-doc gnome-common intltool gnome-doc-utils
BuildRequires: zenity
BuildRequires: gobject-introspection-devel libclutter-gir-devel libgtk+3-gir-devel
BuildRequires: libcinnamon-desktop-devel libcinnamon-desktop-gir-devel
BuildRequires: libcogl-gir-devel

%description
Muffin is a window and compositing manager that displays and manages
your desktop via OpenGL. Muffin combines a sophisticated display engine
using the Clutter toolkit with solid window-management logic inherited
from the Metacity window manager.

While Muffin can be used stand-alone, it is primarily intended to be
used as the display core of a larger system such as Cinnamon.
For this reason, Muffin is very extensible via plugins, which
are used both to add fancy visual effects and to rework the window
management behaviors to meet the needs of the environment.
%package utils

Summary: Additional utilities for %name
Group: Development/GNOME and GTK+
Requires: %name = %version-%release

%description utils
Utilities for testing Metacity/Muffin themes.

%package -n lib%name
Summary: Shared libraries for %name
Group: System/Libraries
# manual dependencies
Requires: typelib(Gtk) = 3.0
# Note: typelib(Cogl) and typelib(Clutter) now are also provided by
# libmutter-gir package when we need libcogl-gir and libclutter-gir packages.
# So we can't rely on automatic requires here.
Requires: libcogl-gir libclutter-gir

%description -n lib%name
Shared libraries for Muffin and its plugins.

%package -n lib%name-devel
Summary: Development package for %name
Group: Development/C
Requires: lib%name = %version-%release
# manual dependencies
Requires: gir(Gtk) = 3.0
# Note: gir(Cogl) and gir(Clutter) now are also provided by
# libmutter-gir-devel package when we need libcogl-gir-devel and
# libclutter-gir-devel packages. So we can't rely on automatic requires here.
Requires: libcogl-gir-devel libclutter-gir-devel

%description -n lib%name-devel
Header files and libraries for developing Muffin plugins.

%package -n lib%name-devel-doc
Summary: Development doc package for %name
Group: Development/Documentation
BuildArch: noarch

%description -n lib%name-devel-doc
Development docs package for Muffin.

%package -n lib%name-gir
Summary: GObject introspection data for the Muffin library
Group: System/Libraries
Requires: lib%name = %version-%release

%description -n lib%name-gir
GObject introspection data for the Muffin library

%package -n lib%name-gir-devel
Summary: GObject introspection devel data for the Muffin library
Group: System/Libraries
Requires: lib%name-devel = %version-%release lib%name-gir = %version-%release

%description -n lib%name-gir-devel
GObject introspection devel data for the Muffin library

%set_typelibdir %_libdir/%name
%set_girdir %_libdir/%name

%prep
%setup -n %name-%version

%build
%autoreconf
%configure --disable-static \
	   --disable-schemas-compile \
	   %{?_enable_gtk_doc:--enable-gtk-doc}

%make_build

%install
%makeinstall_std

%find_lang %name

%files -f %name.lang
%_man1dir/muffin.1*
%_man1dir/muffin-message.1*
%_bindir/muffin
%_bindir/muffin-message
%_desktopdir/*.desktop
%_datadir/muffin
%_datadir/glib-2.0/schemas/org.cinnamon.muffin.gschema.xml
%doc README AUTHORS NEWS HACKING doc/theme-format.txt

%files utils
%_bindir/muffin-theme-viewer
%_bindir/muffin-window-demo
%_man1dir/muffin-theme-viewer.1*
%_man1dir/muffin-window-demo.1*

%files -n lib%name
%_libdir/lib*.so.*
%dir %_libdir/%name
%dir %_libdir/%name/plugins
%_libdir/%name/plugins/default.so

%files -n lib%name-devel
%_includedir/*
%_libdir/lib*.so
%_pkgconfigdir/*

%if_enabled gtk_doc
%files -n lib%name-devel-doc
%_datadir/gtk-doc/html/*
%endif

%files -n lib%name-gir
%_libdir/%name/*.typelib
# There is already registered upstream issue https://github.com/linuxmint/muffin/issues/199
# But untill it will be fixed by Cinnamon devs we handle it manually.
%filter_from_provides /typelib(Meta)/d


%files -n lib%name-gir-devel
%_libdir/%name/*.gir


%changelog
