Name: mupdf
Version: 1.8
Release: alt1
Summary: A lightweight PDF viewer and toolkit
Group: Office
License: GPLv3
Url: http://mupdf.com/
Source0: http://mupdf.com/download/%name-%version-source.tar.gz
Source1: %name.desktop
Source2: debian.tar
Patch0: %name-upstream.patch

# Automatically added by buildreq on Thu Aug 22 2013
# optimized out: libX11-devel pkg-config xorg-xextproto-devel xorg-xproto-devel
BuildRequires: libXext-devel libfreetype-devel libjbig2dec-devel libjpeg-devel libssl-devel zlib-devel

%description
MuPDF is a lightweight PDF viewer and toolkit written in portable C.
The renderer in MuPDF is tailored for high quality anti-aliased
graphics.  MuPDF renders text with metrics and spacing accurate to
within fractions of a pixel for the highest fidelity in reproducing
the look of a printed page on screen.
MuPDF has a small footprint.  A binary that includes the standard
Roman fonts is only one megabyte.  A build with full CJK support
(including an Asian font) is approximately five megabytes.
MuPDF has support for all non-interactive PDF 1.7 features, and the
toolkit provides a simple API for accessing the internal structures of
the PDF document.  Example code for navigating interactive links and
bookmarks, encrypting PDF files, extracting fonts, images, and
searchable text, and rendering pages to image files is provided.

%package devel
Summary: Development files for %name
Group: Development/C
Requires: %name = %version-%release
Provides: %name-static = %version-%release

%description devel
The mupdf-devel package contains header files for developing
applications that use mupdf and static libraries

%prep
%setup -n %name-%version-source -a2
#patch0 -p1

# TODO rebuild with new openjpeg
#BuildRequires: openjpeg-devel
rm -rf thirdparty/[^o]*
sed -i 's/-lopenjpeg //' debian/mupdf.pc

%build
%make_build

%install
# TODO deal with platform/debian/mupdf.install / iconsdirs
%makeinstall
install -D %SOURCE1 %buildroot%_desktopdir/%name.desktop
install -D -m644 debian/%name.xpm %buildroot/%_datadir/pixmaps/%name.xpm
sed 's/@VERSION@/%version/g' < debian/mupdf.pc > mupdf.pc
install -D mupdf.pc %buildroot%_pkgconfigdir/mupdf.pc

%files
%doc %_defaultdocdir/%name
%_bindir/*
%_desktopdir/mupdf.desktop
%_mandir/man1/*
%_datadir/pixmaps/mupdf.xpm

%files devel
%_pkgconfigdir/*
%_includedir/%name
%_libdir/lib*.a

%changelog
