# since 3.21.90 (libmutter-clutter-1.0.so private library)
%set_verify_elf_method unresolved=relaxed

%def_disable snapshot

%define ver_major 3.24
%define xdg_name org.gnome.mutter
%define _libexecdir %_prefix/libexec
%def_enable privatelib
%define api_ver 0

Name: mutter
Version: %ver_major.4
Release: alt0.M80P.1
Epoch: 1

Summary: Clutter based compositing GTK3 Window Manager
Group: Graphical desktop/GNOME
License: GPLv2+
Url: http://ftp.gnome.org/pub/gnome/sources/%name

%if_disabled snapshot
Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version.tar.xz
%else
Source: %name-%version.tar
%endif

%set_typelibdir %_libdir/%name
%set_girdir %_libdir/%name

# since 3.22 mutter forks Cogl and Clutter libraries into own private libraries
#%%filter_from_provides /[typelib\|gir]([Cally\|Clutter\|Cogl].*/d
#%%filter_from_requires /[typelib\|gir]([Cally\|Clutter\|Cogl].*/d

#https://lists.altlinux.org/pipermail/sisyphus-incominger/2016-October/444041.html

Requires: lib%name = %EVR
Requires: zenity

%define gtk_ver 3.20.0
%define gi_ver 0.9.5
%define glib_ver 2.26
%define pango_ver 1.2.0
%define cairo_ver 1.10.0
%define Xi_ver 1.6.0
%define wayland_ver 1.7.0
%define wayland_protocols_ver 1.7
%define upower_ver 0.99.0
%define libinput_ver 0.99.0
%define gsds_ver 3.21.4

BuildPreReq: rpm-build-gnome gnome-common
BuildRequires: gobject-introspection-devel >= %gi_ver
BuildRequires: libgtk+3-devel >= %gtk_ver
BuildRequires: libgio-devel >= %glib_ver
BuildRequires: libpango-devel >= %pango_ver
BuildRequires: libcairo-devel >= %cairo_ver
BuildRequires: gsettings-desktop-schemas-devel >= %gsds_ver
BuildRequires: libXcomposite-devel libXfixes-devel libXrender-devel
BuildRequires: libXdamage-devel libXtst-devel libXi-devel >= %Xi_ver
BuildRequires: libXcursor-devel libX11-devel libXinerama-devel libXext-devel libXrandr-devel libSM-devel libICE-devel
BuildRequires: libxcb-devel
BuildRequires: libwayland-server-devel >= %wayland_ver wayland-protocols >= %wayland_protocols_ver
BuildRequires: libgdk-pixbuf-devel libgbm-devel
BuildRequires: libstartup-notification-devel zenity libcanberra-gtk3-devel
BuildRequires: libclutter-gir-devel libpango-gir-devel libgtk+3-gir-devel gsettings-desktop-schemas-gir-devel
BuildRequires: libgnome-desktop3-devel libupower-devel >= %upower_ver
BuildRequires: libxkbcommon-x11-devel libinput-devel >= %libinput_ver libxkbfile-devel xkeyboard-config-devel
BuildRequires: libwacom-devel
# for mutter native backend
BuildRequires: libdrm-devel libsystemd-devel libgudev-devel

%description
mutter is a minimal X window manager aimed at nontechnical users and is
designed  to  integrate well with the GNOME desktop.  mutter lacks some
features that may be expected by traditional UNIX  or  other  technical
users;  these users may want to investigate other available window man-
agers for use with GNOME or standalone.

%package -n lib%name
Summary: Shared library for Mutter
Group: System/Libraries

%description -n lib%name
This package contains shared library needed to run Mutter.

%package -n lib%name-devel
Summary: Development files for lib%name
Group: Development/C
Requires: lib%name = %EVR

%description -n lib%name-devel
This package contains headers and development libraries for lib%name

%package -n lib%name-gir
Summary: GObject introspection data for the Mutter library
Group: System/Libraries
Requires: lib%name = %EVR

%description -n lib%name-gir
GObject introspection data for the Mutter library

%package -n lib%name-gir-devel
Summary: GObject introspection devel data for the Mutter library
Group: System/Libraries
Requires: lib%name-devel = %EVR lib%name-gir = %EVR

%description -n lib%name-gir-devel
GObject introspection devel data for the Mutter library.

%package gnome
Summary: GNOME-specific parts of Mutter
Group: Graphical desktop/GNOME
BuildArch: noarch
Provides: gnome-wm
Requires: %name = %EVR

%description gnome
This package contains everything necessary to use Mutter in GNOME desktop
environment.

%prep
%setup
[ ! -d m4 ] && mkdir m4

%build
export ac_cv_path_CVT=%_bindir/cvt
%autoreconf
DATADIRNAME=share %configure \
	--enable-introspection \
	--disable-static \
	--disable-schemas-compile \
	--enable-compile-warnings=maximum
%make_build

%install
%makeinstall_std

%find_lang --with-gnome %name creating-%name-themes

%files -f %name.lang
%_bindir/*
%_libexecdir/%name-restart-helper
%dir %_libdir/%name
%_libdir/%name/lib%name-clutter-%api_ver.so
%_libdir/%name/lib%name-cogl-pango-%api_ver.so
%_libdir/%name/lib%name-cogl-path-%api_ver.so
%_libdir/%name/lib%name-cogl-%api_ver.so
%exclude %_libdir/%name/*.la
%dir %_libdir/%name/plugins
%_libdir/%name/plugins/*.so
%_desktopdir/%name.desktop
%_man1dir/*
%doc NEWS
#%doc README AUTHORS

%if_enabled privatelib
%files -n lib%name
%_libdir/*.so.*

%files -n lib%name-devel
#%doc doc/*.txt HACKING
%_includedir/%name/
%_libdir/*.so
%_pkgconfigdir/*.pc
%endif

%files -n lib%name-gir
%_libdir/%name/*.typelib

%files -n lib%name-gir-devel
%_libdir/%name/*.gir

%files gnome
%_datadir/glib-2.0/schemas/%xdg_name.gschema.xml
%_datadir/glib-2.0/schemas/%xdg_name.wayland.gschema.xml
%_datadir/GConf/gsettings/%name-schemas.convert
%_datadir/gnome-control-center/keybindings/*.xml

%changelog
