Name: mypaint
Version: 1.2.0
Release: alt2

Summary: A simple paint program
Group: Graphics
License: GPLv2+
Url: http://mypaint.org/

# VCS: https://github.com/mypaint/mypaint
Source: https://github.com/%name/%name/releases/download/v%version/%name-%version.tar.xz
Patch: mypaint-1.2.0-up-glib_2.48.patch

Requires: %name-data = %version-%release
Requires: python-module-pygobject3-pygtkcompat

%add_python_compile_include %_datadir/%name %_datadir/lib%name

BuildRequires: gcc-c++ libgomp-devel scons swig libgtk+3-devel
BuildRequires: libXi-devel python-devel libnumpy-devel
BuildRequires: libpng-devel libjson-devel python-modules-json liblcms2-devel
BuildRequires: gobject-introspection-devel python-module-pygobject3-devel

%description
MyPaint is a simple drawing and painting program that works well with
Wacom-style graphics tablets. Its main features are a highly configurable
brush engine, speed, and a fullscreen mode which allows artists to fully
immerse themselves in their work.

%package data
Summary: A simple paint program
Group: Graphics
BuildArch: noarch

%description data
Mypaint is a fast and easy/simple painter program. It comes with a large
brush collection including charcoal and ink to emulate real media, but the
highly configurable brush engine allows you to experiment with your own
brushes and with not-quite-natural painting.

This package contains the data files needed for the program.

%package -n lib%name-devel-static
Summary: Static mypaint brush library
Group: Development/C

%description -n lib%name-devel-static
Mypaint is a fast and easy/simple painter program. It comes with a large
brush collection including charcoal and ink to emulate real media, but the
highly configurable brush engine allows you to experiment with your own
brushes and with not-quite-natural painting.

This package provides files needed for development applications statically linked
with mypaint brush library.

%add_python_lib_path %_datadir/%name

%prep
%setup
%patch -p1
# fix libdir
subst 's|lib\/mypaint|%_lib\/mypaint|' SConstruct SConscript mypaint.py
subst "s|prefix, 'lib'|prefix, '%_lib'|" mypaint.py
subst 's|prefix\/lib|prefix\/%_lib|' brushlib/SConscript
# fix pkgconfig-file by preventing substitution
subst 's|@LIBDIR@|%_libdir|' brushlib/pkgconfig.pc.in

%build
scons

%install
scons prefix=%buildroot%_prefix install
%find_lang --output=%name.lang %name lib%name

%files -f %name.lang
%_bindir/*
%_libdir/%name/

%files data
%_datadir/%name/
%_datadir/lib%name/
%_datadir/thumbnailers/%name-ora.thumbnailer
%_desktopdir/%name.desktop
%_iconsdir/hicolor/*/*/*
%_datadir/appdata/mypaint.appdata.xml
%doc README.md README_LINUX.md Changelog.md

%if 0
%files -n lib%name-devel-static
%_libdir/lib%name.a
%_includedir/lib%name/
%_pkgconfigdir/lib%name.pc
%endif

%changelog
