Name: mysql-utilities
Version: 1.6.1
Release: alt1

Summary: MySQL Utilities

License: GPLv2
Group: Databases
Url: https://launchpad.net/mysql-utilities

Packager: Vitaly Lipatov <lav@altlinux.ru>

# Upstream has a mirror redirector for downloads, so the URL is hard to
# represent statically.  You can get the tarball by following a link from
# http://dev.mysql.com/downloads/utilities/
# Source-url: https://launchpad.net/ubuntu/+archive/primary/+files/mysql-utilities_%version.orig.tar.gz
Source: %name-%version.tar

BuildArch: noarch

BuildRequires: python-devel

BuildRequires: python-module-mysql >= 2.0.3

Requires: python-module-mysql >= 2.0.3

# Is it correct method to disable python modules providing?
AutoProv: nopython

%description
A package of utilities that are used for maintenance and administration
of MySQL servers. These utilities encapsulate a set of primitive commands,
and bundles them so they can be used to perform macro operations with a
single command.

Documentation:
http://dev.mysql.com/doc/workbench/en/mysql-utilities.html

%prep
%setup

%build
%python_build

%install
install --directory %buildroot%_man1dir

%python_install --skip-profile

: Man pages
%__python setup.py install_man --root %buildroot

# Archive with doctrine files does not seem like something it should be
# part of RPM; it might un-packed into a separate package if necessary
rm -f %buildroot%_sysconfdir/mysql/mysql-fabric-doctrine-1.4.0.zip
# from python-module-mysql
rm -rf %buildroot%python_sitelibdir/mysql/connector/

%files
%doc CHANGES.txt LICENSE.txt README.txt
%_bindir/mysqlauditadmin
%_bindir/mysqlauditgrep
%_bindir/mysqldbcompare
%_bindir/mysqldbcopy
%_bindir/mysqldbexport
%_bindir/mysqldbimport
%_bindir/mysqldiff
%_bindir/mysqldiskusage
%_bindir/mysqlfailover
%_bindir/mysqlfrm
%_bindir/mysqlindexcheck
%_bindir/mysqlmetagrep
%_bindir/mysqlprocgrep
%_bindir/mysqlreplicate
%_bindir/mysqlrpladmin
%_bindir/mysqlrplcheck
%_bindir/mysqlrplshow
%_bindir/mysqlserverclone
%_bindir/mysqlserverinfo
%_bindir/mysqluc
%_bindir/mysqluserclone
%python_sitelibdir/mysql/utilities
%python_sitelibdir/mysql_utilities*
%_man1dir/mysql*
# empty file already provided by mysql-connector-python
%exclude %python_sitelibdir/mysql/__init*

# mysql fabric files
%dir %_sysconfdir/mysql/
%config(noreplace) %_sysconfdir/mysql/fabric.cfg
%_bindir/mysqlfabric
%_bindir/mysqlrplms
%_bindir/mysqlrplsync
%_bindir/mysqlbinlogmove
%_bindir/mysqlbinlogpurge
%_bindir/mysqlbinlogrotate
%_bindir/mysqlgrants
%_bindir/mysqlslavetrx
%python_sitelibdir/mysql/fabric

%changelog
