Name: mysql-workbench-community
Version: 6.3.4
Release: alt2
Packager: Evgeny Sinelnikov <sin@altlinux.ru>

Summary: A MySQL visual database modeling tool

License: %gpllgpl2only
Group: Development/Databases
Url: http://wb.mysql.com
Source0: %name-%version.tar.gz

Patch1: mysql-workbench-mariadb-build.patch
Patch2: mysql-workbench-mariadb-check.patch
Patch3: mysql-workbench-6.3.4-c++11.patch

Provides: mysql-workbench-oss = %version-%release
Obsoletes: mysql-workbench-oss < %version-%release
Provides: mysql-workbench-gpl = %version-%release
Obsoletes: mysql-workbench-gpl < %version-%release

Provides: mysql-administrator = %version-%release
Obsoletes: mysql-administrator < %version-%release

Provides: mysql-query-browser = %version-%release
Obsoletes: mysql-query-browser < %version-%release

# "_mforms" and "grt" are accessable from "MySQL Workbench GRT Shell" only.
%add_python_req_skip _mforms grt mforms

# internal Workbench's libraries
%add_python_req_skip wb workbench cairo_utils wb_common

# shell_snippets.py is not pure Python
%add_findreq_skiplist */mysql-workbench/shell_snippets.py

# templates only
%add_findreq_skiplist */mysql-workbench/script_templates/*

%add_findreq_skiplist */mysql-workbench/libraries/grt_python_debugger.py

Requires: python-module-paramiko python-module-pexpect
Requires: mysql-client gnome-keyring
Requires: %name-data = %version

BuildRequires(pre): rpm-build-licenses

# Automatically added by buildreq on Sun Mar 20 2011
# and edited manualy
# - removed mysql-workbench-gpl
# - boost-devel-headers changed to boost-devel
BuildRequires: boost-devel gcc-c++ libglade-devel libgnome-devel libgtkmm2-devel liblua5-devel libmysqlclient-devel libpcre-devel libsqlite3-devel libuuid-devel libxml2-devel libzip-devel python-devel

BuildRequires: boost-signals-devel

BuildRequires: libGL-devel
BuildRequires: libctemplate-devel
BuildRequires: libiodbc-devel

# 6.3.4
BuildRequires: rpm-macros-cmake cmake
BuildRequires: mysql-connector-c++-devel libXdmcp-devel libXdamage-devel libXxf86vm-devel
BuildRequires: swig libgdal-devel libpcrecpp-devel libpixman-devel libexpat-devel libvsqlite++-devel
BuildRequires: libgnome-keyring-devel libharfbuzz-devel libxshmfence-devel tinyxml-devel

%description
MySQL Workbench is modeling tool that allows you to design
and generate MySQL databases graphically.

%package data
Summary: Architecture independent files for %name
License: %gpllgpl2only
Group: Development/Databases
BuildArch: noarch
Conflicts: %name < %version
Conflicts: mysql-workbench-gpl-data

%description data
Architecture independent files for %name

%prep

%setup -q

%patch1 -p1
%patch2 -p1
%patch3 -p1

sed -i "s|pcre.h|pcre/pcre.h|" library/base/util_functions.cpp

%set_verify_elf_method unresolved=relaxed

%build
%add_optflags -std=c++11
%cmake
cd BUILD
%make_build VERBOSE=1

%install
pushd %_builddir/%name-%version/BUILD
make install DESTDIR=%buildroot
popd

mkdir -p %buildroot%_niconsdir
cp %_builddir/%name-%version/images/icons/MySQLWorkbench-32.png %buildroot%_niconsdir/mysql-workbench.png

mkdir -p %buildroot%_iconsdir/hicolor/32x32/mimetypes
cp %_builddir/%name-%version/images/icons/MySQLPlugin-32.png %buildroot%_iconsdir/hicolor/32x32/mimetypes/application-vnd.mysql-workbench-plugin.png
cp %_builddir/%name-%version/images/icons/MySQLWorkbenchDocIcon32x32.png %buildroot%_iconsdir/hicolor/32x32/mimetypes/application-vnd.mysql-workbench-model.png

%files
%exclude %_libdir/mysql-workbench/modules/*.py?

%exclude %_datadir/applications/*.desktop
%exclude %_datadir/mysql-workbench/*

%doc COPYING COPYING.LGPL README AUTHORS
%exclude %_datadir/doc/mysql-workbench/COPYING
%exclude %_datadir/doc/mysql-workbench/README

%_bindir/mysql-workbench
%_bindir/mysql-workbench-bin
%_bindir/wbcopytables
%_bindir/wbcopytables-bin
%dir %_libdir/mysql-workbench
%_libdir/mysql-workbench/*

%files data
%_datadir/applications/*.desktop
%dir %_datadir/mysql-workbench
%_datadir/mysql-workbench/*
%_miconsdir/*
%_niconsdir/*
%_liconsdir/*
%_iconsdir/hicolor/128x128/apps/*
%_iconsdir/hicolor/16x16/mimetypes/*
%_iconsdir/hicolor/32x32/mimetypes/*
%_iconsdir/hicolor/48x48/mimetypes/*
%_iconsdir/hicolor/128x128/mimetypes/*
%_xdgmimedir/packages/*.xml
%_xdgdatadir/mime-info/*.mime

%changelog
