Name: nano
Version: 2.2.4
Release: alt1.qa1.2

Summary: Pico editor clone with enhancements
License: %gpl3plus/%fdl v1.2+
Group: Editors
Url: http://www.nano-editor.org/
Packager: Artem Zolochevskiy <azol@altlinux.ru>

Source0: %url/dist/v2.2/%name-%version.tar.gz
Source1: %name.desktop

# Gets from Debian package:
# debian.org/debian/pool/main/n/nano/nano_1.9.99pre2-1.diff.gz
# and converted from xpm to png
Source2: %name-16x16.png
Source3: %name-32x32.png
Source4: %name-48x48.png

Source5: nanorc

# You can find this sources here:
# http://gentoo-wiki.com/TIP_Nano_Context_Highlighting
Source6: xorg.nanorc

# Config highlighting from https://bbs.archlinux.org/viewtopic.php?id=133595
Source7: conf.nanorc

BuildRequires(pre): rpm-build-licenses
BuildRequires: desktop-file-utils

# Automatically added by buildreq on Thu Dec 31 2009
BuildRequires: groff-extra groff-ps libncursesw-devel
# explicitly added texinfo for info files
BuildRequires: texinfo

%description
GNU nano is a small and friendly text editor.  It aims to emulate the
Pico text editor while also offering a few enhancements.

%prep
%setup

%build
%configure
%make_build

%install
%makeinstall_std

# install .desktop file
desktop-file-install --dir %buildroot%_desktopdir %SOURCE1

# install icons
install -pD -m 644 %SOURCE2 %buildroot%_miconsdir/%name.png
install -pD -m 644 %SOURCE3 %buildroot%_niconsdir/%name.png
install -pD -m 644 %SOURCE4 %buildroot%_liconsdir/%name.png

# install config file
install -pD -m 644 %SOURCE5 %buildroot%_sysconfdir/nanorc

# additional files for syntax highlighting
install -pD -m 644 %SOURCE6 %buildroot%_datadir/%name/xorg.nanorc

install -pD -m 644 %SOURCE7 %buildroot%_datadir/%name/conf.nanorc

# find *.mo files and mans for nano
%find_lang --with-man %name

# find mans for nanorc only
%find_lang --without-mo --append --with-man nanorc --output %name.lang

%files -f %name.lang
%doc ABOUT-NLS AUTHORS BUGS NEWS README README.SVN THANKS TODO UPGRADE
%doc doc/faq.html doc/nanorc.sample
%_bindir/%name
%_bindir/r%name
%_datadir/%name/
%_infodir/%name.info.*
%_desktopdir/%name.desktop
%_miconsdir/%name.png
%_niconsdir/%name.png
%_liconsdir/%name.png
%config(noreplace) %_sysconfdir/nanorc

%changelog
