%def_disable snapshot
%define _libexecdir %_prefix/libexec
%define ver_major 3.24
%define api_ver 3.0
%define xdg_name org.gnome.Nautilus

%def_enable exempi
%def_disable packagekit
%def_enable tracker
%def_enable introspection
%def_enable selinux

Name: nautilus
Version: %ver_major.2.1
Release: alt0.M80P.1

Summary: Nautilus is a network user environment
License: GPLv2+
Group: Graphical desktop/GNOME
Url: https://wiki.gnome.org/Apps/Nautilus

%if_disabled snapshot
Source: %gnome_ftp/%name/%ver_major/%name-%version.tar.xz
%else
Source: %name-%version.tar
%endif

%define pkgconfig_ver 0.8
%define icon_theme_ver 2.10.0
%define desktop_file_utils_ver 0.8

# From configure.ac
%define glib_ver 2.49.1
%define desktop_ver 3.3.3
%define pango_ver 1.28.3
%define gtk_ver 3.22.0
%define libxml2_ver 2.4.7
%define exif_ver 0.5.12
%define exempi_ver 2.1.0
%define gir_ver 0.10.2
%define notify_ver 0.7.0
%define tracker_ver 0.18
%define autoar_ver 0.1

Requires(post): libcap-utils
Requires: lib%name = %version-%release
Requires: gnome-icon-theme >= %icon_theme_ver
Requires: shared-mime-info
Requires: common-licenses
Requires: gvfs >= 1.26.1.1

BuildRequires: autoconf-archive pkgconfig >= %pkgconfig_ver
BuildRequires: desktop-file-utils >= %desktop_file_utils_ver
BuildRequires: rpm-build-gnome rpm-build-licenses
# for %%check
BuildRequires: xvfb-run dbus-tools-gui /proc

# From configure.ac
BuildRequires: glib2-devel >= %glib_ver
BuildRequires: libgio-devel >= %glib_ver
BuildRequires: libgnome-desktop3-devel >= %desktop_ver
BuildRequires: libpango-devel >= %pango_ver
BuildRequires: libgtk+3-devel >= %gtk_ver
BuildRequires: gsettings-desktop-schemas-devel
BuildRequires: libgail3-devel
BuildRequires: libxml2-devel >= %libxml2_ver
BuildRequires: intltool >= 0.40.1
BuildRequires: libexif-devel >= %exif_ver
BuildRequires: libnotify-devel >= %notify_ver
BuildRequires: libgnome-autoar-devel >= %autoar_ver
BuildRequires: libX11-devel xorg-xproto-devel
BuildRequires: docbook-utils gtk-doc
%{?_enable_exempi:BuildRequires: libexempi-devel >= %exempi_ver}
%{?_enable_tracker:BuildRequires: tracker-devel >= %tracker_ver}
%{?_enable_introspection:BuildRequires: gobject-introspection-devel >= %gir_ver libgtk+3-gir-devel}
%{?_enable_selinux:BuildRequires: libselinux-devel}

%description
Nautilus integrates access to files, applications, media, Internet-based
resources and the Web.  Nautilus delivers a dynamic and rich user
experience.  Nautilus is an free software project developed under the
GNU General Public License and is a core component of the GNOME desktop
project.

%package -n lib%name
Summary: Shared libraries needed to run Nautilus
Group: System/Libraries

%description -n lib%name
This package contains shared libraries needed to run Nautilus and its
components.

%package -n lib%name-devel
Summary: Libraries and include files for developing Nautilus components
Group: Development/GNOME and GTK+
Requires: lib%name = %version-%release

%description -n lib%name-devel
This package provides the necessary development libraries and include
files to allow you to develop Nautilus components.

%package -n lib%name-devel-doc
Summary: Development documentation for %name
Group: Development/Documentation
Conflicts: lib%name-devel < %version-%release
BuildArch: noarch

%description -n lib%name-devel-doc
This package contains development documentation for the %name.

%package -n lib%name-gir
Summary: GObject introspection data for the nautilus-extension library
Group: System/Libraries
Requires: lib%name = %version-%release

%description -n lib%name-gir
GObject introspection data for the nautilus-extension library

%package -n lib%name-gir-devel
Summary: GObject introspection devel data for the nautilus-extension library
Group: System/Libraries
BuildArch: noarch
Requires: lib%name-gir = %version-%release

%description -n lib%name-gir-devel
GObject introspection devel data for the nautilus-extension library


%define _bonobo_servers_dir %_libdir/bonobo/servers
%define _gtk_docdir %_datadir/gtk-doc/html

%prep
%setup
rm -f data/*.desktop

%build
%autoreconf
%configure \
    --disable-update-mimedb \
    --disable-schemas-compile \
    --enable-gtk-doc \
    %{subst_enable tracker} \
    %{subst_enable packagekit}

%make_build

%install
%makeinstall_std
mkdir -p %buildroot%_libdir/%name-%api_ver/components
bzip2 -9fk NEWS

# The license
ln -sf %_licensedir/LGPL-2 COPYING

%find_lang %name

%post
# for mount secure NFS shares
setcap 'cap_net_bind_service=+ep' %_bindir/%name 2>/dev/null ||:

%files -f %name.lang
%_bindir/*
%dir %_libdir/%name
#%_libdir/%name/libgd.so
%dir %_libdir/%name-%api_ver
%dir %_libdir/%name-%api_ver/components
%_desktopdir/*.desktop
%_sysconfdir/xdg/autostart/nautilus-autostart.desktop
%_datadir/dbus-1/services/%xdg_name.service
%_datadir/dbus-1/services/org.freedesktop.FileManager1.service
%_datadir/gnome-shell/search-providers/nautilus-search-provider.ini
%_iconsdir/hicolor/*x*/apps/%xdg_name.png
%_iconsdir/hicolor/symbolic/apps/%xdg_name-symbolic.svg
%config %_datadir/glib-2.0/schemas/org.gnome.nautilus.gschema.xml
%_datadir/appdata/%xdg_name.appdata.xml
# docs
%doc --no-dereference COPYING
%doc AUTHORS MAINTAINERS NEWS.bz2 README THANKS
%_man1dir/*

#%exclude %_libdir/%name/libgd.la

%files -n lib%name
%_libdir/libnautilus-extension.so.*
%dir %_libdir/%name/extensions-%api_ver
%_libdir/%name/extensions-%api_ver/libnautilus-sendto.so
%exclude %_libdir/%name/extensions-3.0/libnautilus-sendto.la

%files -n lib%name-devel
%_includedir/*
%_libdir/*.so
%_pkgconfigdir/*

%files -n lib%name-devel-doc
%_gtk_docdir/*
%doc docs/*.{txt,pdf,sxw,html} README.commits

%if_enabled introspection
%files -n lib%name-gir
%_typelibdir/*

%files -n lib%name-gir-devel
%_girdir/*
%endif


%changelog
