Name: ncurses
Version: 5.9
Release: alt8

%define rootdatadir /lib

Summary: A CRT screen handling and optimization package
License: MIT
Group: System/Base
Url: http://invisible-island.net/%name/%name.html

# ftp://invisible-island.net/%name/%name-%version.tar.gz
Source: %name-%version.tgz

Source100: %name-alt-terms.tar
Source101: %name-baseterms
Source102: %name-resetall.sh

Patch: ncurses-alt.patch

Obsoletes: ncurses3
Requires: termutils-devel = %version-%release

# Automatically added by buildreq on Thu Nov 12 2009
BuildRequires: libgpm-devel libncurses-devel gcc-c++

#build parameters
%def_with utf8
%def_with shared
%def_with normal
%def_without debug
%def_without profile
%def_with cxx
%def_with gpm
%def_without ada
%def_without libtool

%package -n terminfo
Summary: Descriptions of common terminal types
Group: System/Base
Conflicts: %name < %version-%release
Conflicts: screen < 3.9.11-alt1
BuildArch: noarch

%package -n terminfo-extra
Summary: Additional terminal type definitions
Group: System/Base
BuildArch: noarch
Provides: %name-extraterms = %version
Obsoletes: %name-extraterms
PreReq: terminfo = %version-%release

%package -n libtinfo
Summary: A low-level terminfo shared library
Group: System/Libraries
PreReq: terminfo = %version-%release

%package -n libtinfo-devel
Summary: A low-level terminfo development library
Group: Development/C
Conflicts: libtermcap-devel < 0:2.0.8-ipl24mdk
# due to incorrect terminfo handling in old libgpm.
Conflicts: libgpm < 1.20.1-alt3.1
Requires: libtinfo = %version-%release

%package -n libtinfo-devel-static
Summary: A low-level terminfo static library
Group: Development/C
Requires: libtinfo-devel = %version-%release

%package -n termutils
Summary: Basic terminal utilities
Group: System/Base
Requires: terminfo = %version-%release
Requires: libtinfo = %version-%release
Requires: libtic = %version-%release
Provides: /bin/tput

%package -n termutils-devel
Summary: Additional terminal utilities
Group: Development/Other
Requires: termutils = %version-%release

%package -n libtic
Summary: A low-level terminfo manipulation shared library
Group: System/Libraries
Requires: libtinfo = %version-%release

%package -n libtic-devel
Summary: A low-level terminfo manipulation development library
Group: Development/C
Requires: libtic = %version-%release
Requires: libtinfo-devel = %version-%release

%package -n lib%name
Summary: A CRT screen handling and optimization libraries
Group: System/Libraries
Provides: libncurses.so.4 libncurses.so.3
PreReq: libtinfo = %version-%release
Conflicts: %name < %version-%release

%package -n lib%name-devel
Summary: Development files for applications which use %name
Group: Development/C
Requires: lib%name = %version-%release
Requires: libtinfo-devel = %version-%release
Provides: %name-devel = %version-%release
Obsoletes: %name-devel

%package -n lib%name-devel-static
Summary: Development static %name libraries
Group: Development/C
Requires: lib%name-devel = %version-%release
Requires: libtic-devel = %version-%release
Requires: libtinfo-devel-static = %version-%release
%if_with utf8
Requires: lib%{name}w-devel = %version-%release
%endif

%package -n lib%name++
Summary: C++ interface to lib%name
Group: System/Libraries
Requires: lib%name = %version-%release

%package -n lib%name++-devel
Summary: Development files for applications which use lib%name++
Group: Development/C++
Requires: lib%name++ = %version-%release
Requires: lib%name-devel = %version-%release

%package -n lib%name++-devel-static
Summary: Development static lib%name++ library
Group: Development/C++
Requires: lib%name++-devel = %version-%release
Requires: lib%name-devel-static = %version-%release

# UTF-8 extentions
%if_with utf8
%package -n lib%{name}w
Summary: A CRT screen handling and optimization libraries with wide character support
Group: System/Libraries
PreReq: libtinfo = %version-%release

%package -n lib%{name}w-devel
Summary: Development files for applications which use %name (widechar version)
Group: Development/C
Requires: lib%{name}w = %version-%release
Requires: lib%name-devel = %version-%release
%endif

%description
The curses library routines are a terminal-independent method of updating
character screens with reasonable optimization.  The %name (new curses)
library is a freely distributable replacement for the discontinued 4.4BSD
classic curses library.

%description -n terminfo
Terminfo is a data base describing terminals, used by screen-oriented
programs and libraries such as curses(3X).  Terminfo describes terminals
by giving a set of capabilities which they have, by specifying how to
perform screen operations, and by specifying padding requirements and
initialization sequences.

This package contains what should be a reasonable subset of terminal
definitions, including: ansi, dumb, linux, rxvt, screen, sun, vt100,
vt102, vt220, vt52, and xterm.

%description -n terminfo-extra
Terminfo is a data base describing terminals, used by screen-oriented
programs and libraries such as curses(3X).  Terminfo describes terminals
by giving a set of capabilities which they have, by specifying how to
perform screen operations, and by specifying padding requirements and
initialization sequences.

This package contains all of the terminal definitions not found in
the terminfo package.  There are far too many to list here.

%description -n libtinfo
The curses library routines are a terminal-independent method of updating
character screens with reasonable optimization.  The %name (new curses)
library is a freely distributable replacement for the discontinued 4.4BSD
classic curses library.

This package contains a low-level terminfo shared library.

%description -n libtinfo-devel
The curses library routines are a terminal-independent method of updating
character screens with reasonable optimization.  The %name (new curses)
library is a freely distributable replacement for the discontinued 4.4BSD
classic curses library.

This package contains a low-level terminfo development library and include
files.

%description -n libtinfo-devel-static
The curses library routines are a terminal-independent method of updating
character screens with reasonable optimization.  The %name (new curses)
library is a freely distributable replacement for the discontinued 4.4BSD
classic curses library.

This package contains a low-level terminfo static library.

%description -n libtic
lowlevel terminfo manipulation shared library

%description -n libtic-devel
lowlevel terminfo manipulation development library

%description -n termutils
The curses library routines are a terminal-independent method of updating
character screens with reasonable optimization.  The %name (new curses)
library is a freely distributable replacement for the discontinued 4.4BSD
classic curses library.

This package contains basic terminal manipulation utilities.

%description -n termutils-devel
The curses library routines are a terminal-independent method of updating
character screens with reasonable optimization.  The %name (new curses)
library is a freely distributable replacement for the discontinued 4.4BSD
classic curses library.

This package contains additional terminal manipulation utilities.

%description -n lib%name
The curses library routines are a terminal-independent method of updating
character screens with reasonable optimization.  The %name (new curses)
library is a freely distributable replacement for the discontinued 4.4BSD
classic curses library.

%description -n lib%name-devel
The curses library routines are a terminal-independent method of updating
character screens with reasonable optimization.  The %name (new curses)
library is a freely distributable replacement for the discontinued 4.4BSD
classic curses library.

This package contains include files for developing applications that use
the %name CRT screen handling and optimization package.

%description -n lib%name-devel-static
The curses library routines are a terminal-independent method of updating
character screens with reasonable optimization.  The %name (new curses)
library is a freely distributable replacement for the discontinued 4.4BSD
classic curses library.

This package contains staic libraries for developing statically linked
applications that use the %name CRT screen handling and optimization package.

%description -n lib%name++
The curses library routines are a terminal-independent method of updating
character screens with reasonable optimization.  The %name (new curses)
library is a freely distributable replacement for the discontinued 4.4BSD
classic curses library.

This package contains a c++ interface shared library.

%description -n lib%name++-devel
The curses library routines are a terminal-independent method of updating
character screens with reasonable optimization.  The %name (new curses)
library is a freely distributable replacement for the discontinued 4.4BSD
classic curses library.

This package contains include files for developing applications that use
c++ interface to ncurses routines.

%description -n lib%name++-devel-static
The curses library routines are a terminal-independent method of updating
character screens with reasonable optimization.  The %name (new curses)
library is a freely distributable replacement for the discontinued 4.4BSD
classic curses library.

This package contains staic library for developing statically linked
applications that use c++ interface to ncurses routines.

#UTF8 extentions
%if_with utf8
%description -n lib%{name}w
The curses library routines are a terminal-independent method of updating
character screens with reasonable optimization.  The %name (new curses)
library is a freely distributable replacement for the discontinued 4.4BSD
classic curses library.
This package contains a %name library with wide character support.

%description -n lib%{name}w-devel
The curses library routines are a terminal-independent method of updating
character screens with reasonable optimization.  The %name (new curses)
library is a freely distributable replacement for the discontinued 4.4BSD
classic curses library.

This package contains include files for developing applications that use
the %name CRT screen handling and optimization package (widechar version).
%endif

%prep
%setup -a100

%patch -p1

sed -i 's/EXTRA_LIBS="-ldl -lncurses $EXTRA_LIBS"/EXTRA_LIBS="$EXTRA_LIBS"/
s/SHLIB_LIST="-ldl $SHLIB_LIST"/SHLIB_LIST="-lgpm $SHLIB_LIST"/
s/TINFO_LIST="$SHLIB_LIST"/TINFO_LIST=/' ./configure


%build
%remove_optflags %optflags_notraceback %optflags_nocpp
%ifarch %ix86
%add_optflags -momit-leaf-frame-pointer
%endif


# Predefine these for configure:
export \
	ac_cv_func_mkstemp=yes \
	ac_cv_prog_AWK=gawk \
	ac_cv_prog_MAKE_LOWER_TAGS=yes \
	ac_cv_prog_MAKE_UPPER_TAGS=yes \
	ac_cv_prog_MAN=man \
	#

%define _configure_script ../configure
rm -rf build-classic build-utf8
mkdir -p build-classic build-utf8

# configure classic version
pushd build-classic
%configure \
	--program-transform-name= \
	%{subst_with shared} \
	%{subst_with normal} \
	%{subst_with debug} \
	%{subst_with profile} \
	%{subst_with cxx} \
	%{subst_with ada} \
	%{subst_with libtool} \
	%{subst_with gpm} \
	--without-dlsym \
	--with-termlib \
	--with-ospeed="unsigned int" \
	--with-terminfo-dirs="%rootdatadir/terminfo:%_datadir/terminfo" \
	--disable-termcap \
	--enable-const \
	--enable-hard-tabs \
	--enable-no-padding \
	--enable-sigwinch \
	--enable-echo \
	--enable-warnings \
	--enable-pc-files \
	--with-pkg-config-libdir=%_pkgconfigdir \
	--disable-rpath \
	--disable-root-environ \
	--disable-home-terminfo \
	--with-chtype=long \
	#

popd # build-classic

# configure utf8 version
%if_with utf8
pushd build-utf8
%configure \
	--program-transform-name= \
	%{subst_with shared} \
	%{subst_with normal} \
	%{subst_with debug} \
	%{subst_with profile} \
	%{subst_with cxx} \
	%{subst_with ada} \
	%{subst_with libtool} \
	%{subst_with gpm} \
	--without-dlsym \
	--with-termlib=tinfo \
	--with-ticlib=tic \
	--with-ospeed="unsigned int" \
	--with-terminfo-dirs="%rootdatadir/terminfo:%_datadir/terminfo" \
	--disable-termcap \
	--enable-const \
	--enable-hard-tabs \
	--enable-no-padding \
	--enable-sigwinch \
	--enable-echo \
	--enable-warnings \
	--enable-pc-files \
	--with-pkg-config-libdir=%_pkgconfigdir \
	--disable-rpath \
	--disable-root-environ \
	--disable-home-terminfo \
	--with-chtype=long \
	--enable-widec \
	#
# Workaround for utf8, rename libtinfow to libtinfo, addon for ncurses-*-alt-utf8-fix.patch
# will be removed when Thomas finish termlib=name feature
    find -type f -name Makefile -print0 |
	xargs -r0 subst s,tinfow,tinfo,g

popd # build-utf8
%endif # with_utf8

# build classic version
pushd build-classic
#NO SMP
%make_build

%if_with cxx
# Build c++ shared library.
pushd lib
g++ -shared -Wl,-soname,libncurses++.so.5 -o libncurses++.so.%version \
	-Wl,-whole-archive libncurses++.a -Wl,-no-whole-archive \
	-L. -lform -lmenu -lpanel -lncurses -ltinfo
ln -s libncurses++.so.%version libncurses++.so.5
ln -s libncurses++.so.5 libncurses++.so
popd # lib
# Rebuild c++ demo.
rm -f c++/demo
make -C c++
%endif # with_cxx
popd # build-classic

# build utf8 version
%if_with utf8
pushd build-utf8
#NO SMP
%make_build

%if_with cxx
# Build c++ shared library.
pushd lib
g++ -shared -Wl,-soname,libncurses++w.so.5 -o libncurses++w.so.%version \
	-Wl,-whole-archive libncurses++w.a -Wl,-no-whole-archive \
	-L. -lform -lmenu -lpanel -lncurses -ltinfo
ln -s libncurses++w.so.%version libncurses++w.so.5
ln -s libncurses++w.so.5 libncurses++w.so
popd # lib
# Rebuild c++ demo.
rm -f c++/demo
make -C c++
%endif # with_cxx
popd # build-utf8
%endif # with_utf8

%install
#install classic ncurses library version
pushd build-classic
%makeinstall_std includedir=%_includedir/%name

%if_with cxx
# Install c++ shared library.
install -pm644 lib/libncurses++.so.%version %buildroot%_libdir/
ln -s libncurses++.so.%version %buildroot%_libdir/libncurses++.so.5
ln -s libncurses++.so.5 %buildroot%_libdir/libncurses++.so
%endif # with_cxx
popd # build-classic

#install utf8 ncurses library version
%if_with utf8
pushd build-utf8
%makeinstall_std includedir=%_includedir/%name

ln -s %name %buildroot%_includedir/%{name}w
%if_with cxx
# Install c++ shared library.
install -pm644 lib/libncurses++w.so.%version %buildroot%_libdir/
ln -s libncurses++w.so.%version %buildroot%_libdir/libncurses++w.so.5
ln -s libncurses++w.so.5 %buildroot%_libdir/libncurses++w.so
%endif # with_cxx
popd # build-utf8
%endif # with_utf8

# The resetall script.
install -pD -m755 %SOURCE102 %buildroot%_bindir/resetall

ln -snf %name/curses.h %buildroot%_includedir/%name.h
for n in curses eti form menu panel term termcap unctrl; do
	ln -snf "%name/$n.h" "%buildroot%_includedir/$n.h"
done

# Relocate libtinfo from %_libdir/ to /lib/.
for f in %buildroot%_libdir/libtinfo*.so; do
	t=$(readlink "$f")
	ln -snf ../../%_lib/"$t" "$f"
done
mkdir -p %buildroot/%_lib
mv %buildroot%_libdir/libtinfo*.so.* %buildroot/%_lib/

ln -snf lib%name.so %buildroot%_libdir/libcurses.so

# Library compatibility symlinks.
t=$(readlink "%buildroot%_libdir/lib%name.so")
for v in 4 3; do
	ln -s "$t" "%buildroot%_libdir/lib%name.so.$v"
done

# Relocate tput.
mkdir -p %buildroot/bin
mv %buildroot%_bindir/tput %buildroot/bin/
ln -s ../../bin/tput %buildroot%_bindir/

# Generate new terminfo entries (deb).
for n in rxvt rxvt-unicode screen; do
	LD_LIBRARY_PATH=%buildroot/%_lib:%buildroot%_libdir \
        TERMINFO=%buildroot%_datadir/terminfo \
		%buildroot%_bindir/tic -s %name-alt-terms/$n.ti
done

# Split terminfo entries into /lib/terminfo and %_datadir/terminfo.
ln -snf ../l/linux %buildroot%_datadir/terminfo/c/console

rm -f relocation_error
while read -r n; do
	f="${n:0:1}"
	mkdir -p "%buildroot/%rootdatadir/terminfo/$f"
	mv "%buildroot%_datadir/terminfo/$f/$n" "%buildroot/%rootdatadir/terminfo/$f/" ||
		{ touch relocation_error; exit 1; }
	ln -s `relative "%buildroot/%rootdatadir/terminfo/$f/$n" "%buildroot%_datadir/terminfo/$f/"` \
		"%buildroot%_datadir/terminfo/$f/" ||
		{ touch relocation_error; exit 1; }
	echo "%%dir %_datadir/terminfo/$f"
	echo "%_datadir/terminfo/$f/$n"
done < %SOURCE101 | sort -u > base.list
[ ! -f relocation_error ]

find %buildroot%_datadir/terminfo -type f -mindepth 2 |
	sed "s|%buildroot||g" > extra.list

# Prepare docs.
rm -rf %buildroot%_docdir/%name-%version
mkdir -p %buildroot%_docdir/%name-%version
install -pm644 ANNOUNCE NEWS README TO-DO \
	c++/demo.cc doc/*.doc doc/html/*.html \
	%buildroot%_docdir/%name-%version/
install -pm644 c++/README-first \
	%buildroot%_docdir/%name-%version/README.c++
#make clean -C test

# Replace libncurses.so/libncursesw.so symlinks with linker scripts.
for i in ncurses ncursesw; do
	rm -f %buildroot%_libdir/lib$i.so
	cat > %buildroot%_libdir/lib$i.so <<-EOF
	/* GNU ld script */
	GROUP(%_libdir/lib$i.so.5 -ltinfo)
	EOF
done

%files
# ncurses is a pure virtual package.

# TERMINFO
%files -n terminfo -f base.list
%rootdatadir/terminfo
%dir %_datadir/terminfo/
%_datadir/tabset
%_man5dir/*

%files -n terminfo-extra -f extra.list
%dir %_datadir/terminfo/
%dir %_datadir/terminfo/*
%_datadir/terminfo/c/console

# LIBTINFO
%files -n libtinfo
/%_lib/libtinfo.*

%files -n libtic
%_libdir/libtic.so.*

%files -n libtic-devel
%_libdir/libtic.so
%_pkgconfigdir/tic.pc
%_includedir/%name/term_entry.h
%_includedir/%name/nc_tparm.h

%files -n libtinfo-devel
%_libdir/libtinfo.so
%_includedir/termcap.h
%_includedir/term.h
%_pkgconfigdir/tinfo.pc
%dir %_includedir/%name/
%_includedir/%name/termcap.h
%_includedir/%name/term.h
%_includedir/%name/ncurses_dll.h

%files -n libtinfo-devel-static
%_libdir/libtinfo.a

# TERMUTILS
%files -n termutils
/bin/tput
%_bindir/clear
%_bindir/reset*
%_bindir/toe
%_bindir/tput
%_bindir/tset
%_bindir/tabs
%_man7dir/*
%_man1dir/clear.*
%_man1dir/reset.*
%_man1dir/toe.*
%_man1dir/tput.*
%_man1dir/tset.*
%_man1dir/tabs.*

%files -n termutils-devel
%_bindir/*info*
#_bindir/tack
%_bindir/tic
%_man1dir/*info*
#_man1dir/tack.*
%_man1dir/tic.*

# LIBNCURSES
%files -n lib%name
%_libdir/lib*[musl].so.*
%dir %_docdir/%name-%version/
%_docdir/%name-%version/[A-Z]*

%files -n lib%name-devel
%_bindir/%{name}5-config
%_libdir/lib*[musl].so
%_pkgconfigdir/*[musl].pc
%_includedir/*
%_man1dir/*-config*
%exclude %_includedir/term*.h
%exclude %_includedir/%name/term*.h
%exclude %_includedir/%name/ncurses_dll.h
%exclude %_includedir/%name/nc_tparm.h
%if_with cxx
%exclude %_includedir/%name/cursesapp.h
%exclude %_includedir/%name/curses?.h
%exclude %_includedir/%name/cursslk.h
%exclude %_includedir/%name/etip.h
%endif # with_cxx
%if_with utf8
%exclude %_includedir/%{name}w
%endif # with_utf8
%_man3dir/*
%dir %_docdir/%name-%version/
%_docdir/%name-%version/[a-z]*
#%doc test

%files -n lib%name-devel-static
%_libdir/lib*.a
%exclude %_libdir/libtinfo.a
%if_with cxx
%exclude %_libdir/libncurses++*.a
%endif # with_cxx

# LIBNCURSES++
%if_with cxx
%files -n lib%name++
%_libdir/libncurses++*.so.*

%files -n lib%name++-devel
%_libdir/libncurses++*.so
%dir %_includedir/%name/
%_includedir/%name/cursesapp.h
%_includedir/%name/curses?.h
%_includedir/%name/cursslk.h
%_includedir/%name/etip.h
%_pkgconfigdir/ncurses++*.pc

%files -n lib%name++-devel-static
%_libdir/libncurses++*.a
%endif # with_cxx

%if_with utf8
%files -n lib%{name}w
%_libdir/lib*[musl]w.so.*

%files -n lib%{name}w-devel
%_bindir/%{name}w5-config
%_libdir/lib*[musl]w.so
%_includedir/%{name}w
%_pkgconfigdir/*[musl]w.pc
%endif # with_utf8

%changelog
