%define ver_major 0.9

Name: nemiver
Version: %ver_major.6
Release: alt3

Summary: A GNOME C/C++ Debugger
Group: Development/Debuggers
License: GPLv2+
Url: https://wiki.gnome.org/Apps/Nemiver

#Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version.tar.xz
Source: %name-%version.tar

Requires: gdb

BuildRequires: mm-common gcc-c++ boost-devel libgtkmm3-devel libxml2-devel
BuildRequires: libgtksourceviewmm3-devel libgtop-devel libsqlite3-devel libvte3-devel
BuildRequires: libgdlmm3-devel gsettings-desktop-schemas-devel libgtkhex-devel dconf
BuildRequires: intltool yelp-tools itstool doxygen libappstream-glib-devel
# if autoreconf used
BuildRequires: libGConf-devel

%description
Nemiver is an ongoing effort to write a standalone graphical debugger that
integrates well in the GNOME desktop environment. It currently features a
backend which uses the well known GNU Debugger (gdb) to debug C/C++ programs.

The yelp package must be installed to make use of Nemiver's documentation.

%package devel
Summary: Header files for %name
Group: Development/C
BuildArch: noarch
Requires: %name = %version-%release

%description devel
The %name-devel package contains header files for developing new debugging
backends for Nemiver.

%prep
%setup

%build
%autoreconf
export ac_cv_path_GDB_PROG=%_bindir/gdb
%configure --disable-static \
	--disable-schemas-compile
%make_build

%install
%makeinstall_std
%find_lang --with-gnome %name

%files -f %name.lang
%_bindir/%name
%_libdir/%name/
%_datadir/glib-2.0/schemas/org.nemiver.gschema.xml
%_datadir/applications/%name.desktop
%_iconsdir/hicolor/*/apps/%{name}*
%_datadir/%name/
%_datadir/appdata/%name.appdata.xml
%_man1dir/*
%doc AUTHORS NEWS README TODO

%files devel
%_includedir/%name/

%changelog
