Name:		net-scripts
Version:	0.5.6
Release:	alt2.qa1
Summary:	The system network scripts
Summary(ru_RU.KOI8-R):     
License:	GPL
Group:		System/Base
Packager:	Denis Ovsienko <pilot@altlinux.ru>
Source:		%name-%version.tar
PreReq:		setup >= 0:2.1.9-ipl18mdk, service, startup >= 0:0.9.3-alt1, chkconfig, control
Requires:	iproute2
Conflicts:	initscripts < 1:5.49.1-alt1, ppp-common < 0:0.3
Conflicts:	ppp < 0:2.3.9, wvdial < 0:1.40
BuildRequires:	glib-devel libpopt-devel
Provides:	network-config-subsystem

%description
This package contains the basic system scripts that activate
and deactivate most network interfaces.

%description -l ru_RU.KOI8-R
     , 
     .

%prep
%setup -q

%build
make -C src

%install
rln()
{
	local target=$1 && shift
	local source=$1 && shift
	target=`relative "$target" "$source"`
	ln -snf "$target" "%buildroot$source"
}

%make_install install -C src DESTDIR=%buildroot

mkdir -p %buildroot%_sysconfdir
cp -a rc.d sysconfig %buildroot%_sysconfdir/
for n in ifup ifdown; do 
	mv %buildroot%_sysconfdir/sysconfig/network-scripts/$n \
		%buildroot/sbin/
	rln /sbin/$n %_sysconfdir/sysconfig/network-scripts/
done

touch %buildroot%_sysconfdir/sysconfig/network
chmod -R +x %buildroot{/sbin,%_sysconfdir/{rc.d,sysconfig/network-scripts}}
rln %_docdir/%name-%version/README \
	%_sysconfdir/sysconfig/network-scripts/

mkdir -p %buildroot/var/{log,run/netreport}

%pre
if [ $1 -ge 2 ]; then
	/usr/sbin/control-dump usernetctl
fi

%post
if [ $1 -ge 2 ]; then
	/usr/sbin/control-restore usernetctl
else
	/sbin/chkconfig --add network
fi

%preun
if [ $1 -eq 0 ]; then
	/sbin/chkconfig --del network
fi

%triggerpostun -- initscripts < 1:5.49.1-alt1
for f in %_sysconfdir/sysconfig/{network,vlan}; do
	if [ ! -f "$f" ]; then
	        if [ -f "$f".rpmsave ]; then
	                %__cp -pf "$f".rpmsave "$f"
	        elif [ -f "$f".rpmnew ]; then
	                %__cp -pf "$f".rpmnew "$f"
	        fi
	fi
done
/sbin/chkconfig --add network

%files
%config(noreplace) %verify(not md5 mtime size) %_sysconfdir/sysconfig/network
%config(noreplace) %verify(not md5 mtime size) %_sysconfdir/sysconfig/vlan
%config %_sysconfdir/rc.d/init.d/*
%config /etc/control.d/facilities/usernetctl
# TODO: those two can produce 2 dead links in sbin
%config /sbin/ifup
%config /sbin/ifdown
%dir %_sysconfdir/sysconfig/network-scripts
%config %_sysconfdir/sysconfig/network-scripts/ifcfg-*
%config %_sysconfdir/sysconfig/network-scripts/sysctl.conf
%_sysconfdir/sysconfig/network-scripts/ifdown*
%_sysconfdir/sysconfig/network-scripts/ifup*
%_sysconfdir/sysconfig/network-scripts/network-functions*
%doc %_sysconfdir/sysconfig/network-scripts/README

/bin/*
/sbin/ppp-watch
%attr(2711,root,netwatch) /sbin/netreport
%attr(700,root,root) %_sbindir/usernetctl
%dir %attr(730,root,netwatch) /var/run/netreport
%_mandir/man?/*

%doc README ifcfg-iptun0.example ifcfg-plip0.example ifcfg-ipsectun0.example
%doc ifcfg-pentanet0.example config-pentanet0.example

%changelog
