%define build_static 0

Name: netatalk
Version: 2.2.4
Release: alt1.qa1

Summary: AppleTalk networking programs
License: GPL, BSD
Group: Networking/Other

Url: http://netatalk.sourceforge.net
Source0: %name-%version.tar
Source1: atalk.init
Source2: netatalk.pamd

BuildRequires: libdb4-devel libpam-devel libwrap-devel zlib-devel
BuildRequires: libgcrypt-devel
BuildRequires: libssl-devel
BuildRequires: perl-bignum

%description
This package enables Linux to talk to Macintosh computers via the
AppleTalk networking protocol. It allows Linux to act as a file server
over AppleTalk or IP for Macs.

Netatalk is available under the GPL and BSD licenses.

%package devel
Summary: Headers and shared libraries for AppleTalk development
Group: Development/C
Requires: %name = %version-%release
Requires: libpam-devel libssl-devel libwrap-devel libacl-devel libattr-devel automake-common
BuildArch: noarch

%description devel
This package contains the header files and shared libraries for building
AppleTalk networking programs

%if %build_static
%package devel-static
Summary: Static libraries for AppleTalk development
Group: Development/C
Requires: %name-devel = %version-%release

%description devel-static
This package contains static libraries for building
AppleTalk networking programs
%endif

%prep
%setup -n %name-%version

# rename uniconv -> uniconv_netatalk
# to prevent filename conflict with uniconvertor
sed -i "s|uniconv|uniconv_netatalk|" man/man1/uniconv.1.tmpl

#remove lp2pap
#sed -i "s| lp2pap|#lp2pap|" contrib/shell_utils/Makefile.am

%build
%autoreconf
%configure \
	--with-pam=yes \
	--enable-ddp \
	--enable-redhat-sysv \
	--with-shadow \
	--enable-fhs \
	--with-cnid-cdb-backend \
	--with-cnid-dbd-backend \
	--with-cnid-last-backend \
	--enable-acl \
	--libexecdir=%_bindir \
%if %build_static
	--enable-static
%else
	--disable-static
%endif
%make_build

%install
mkdir -p %buildroot{%_sysconfdir/{netatalk,pam.d},%_initdir,%_libdir/netatalk}
mkdir -p %buildroot{%_man1dir,%_man3dir,%_man4dir,%_man8dir}
%make_install install DESTDIR=%buildroot
rm -f %buildroot%_bindir/acleandir.rc
rm -f %buildroot%_includedir/netatalk/at.h
# override RH-style initscript
install -pD -m755 %SOURCE1 %buildroot%_initdir/atalk
# ...and PAM configuration as well
install -pD -m644 %SOURCE2 %buildroot%_sysconfdir/pam.d/%name
# rename uniconv -> uniconv_netatalk
# to prevent filename conflict with uniconvertor
mv %buildroot%_bindir/uniconv %buildroot%_bindir/uniconv_netatalk
mv %buildroot%_man1dir/uniconv.1 %buildroot%_man1dir/uniconv_netatalk.1

%post
%post_service atalk

%preun
%preun_service atalk

%files
%dir %_sysconfdir/%name
%dir %_libdir/%name
%config(noreplace) %_sysconfdir/%name/*
%config %_initdir/atalk
%exclude %_initdir/netatalk
%config %_sysconfdir/pam.d/%name
%_bindir/*
%_sbindir/*
%_mandir/man?/*
%_libdir/%name/*.so
%_datadir/%name/
%doc CONTRIBUTORS COPYING COPYRIGHT NEWS
%doc doc/DEVELOPER doc/README.*
%exclude %_libdir/libatalk.a
%exclude %_libdir/%name/*.la

%files devel
%dir %_includedir/atalk
%dir %_includedir/netatalk
%_includedir/atalk/*
%_includedir/netatalk/*
%_datadir/aclocal/*

%if %build_static
%files devel-static
%_libdir/libatalk.a
%_libdir/%name/*.a
%endif


%changelog
