# NB: we track "superstable" upstream releases, see Url:

Name: netpbm
Version: 10.35.97
Release: alt1

Summary: Tools for manipulating graphics files in netpbm supported formats
License: BSD-like
Group: Graphics

Packager: Vladimir Lettiev <crux@altlinux.ru>

Url: http://netpbm.sourceforge.net

# https://netpbm.svn.sourceforge.net/svnroot/netpbm/stable
Source0: netpbm-%version.tar
# https://netpbm.svn.sourceforge.net/svnroot/netpbm/userguide
Source1: netpbm-userguide.tar

# fix various build and install issues
Patch0: netpbm-10.34-alt-libpm-tmp.patch
Patch1: netpbm-10.34-alt-no-nstring.patch
Patch2: netpbm-10.35-alt-cameratopam-memmem.patch
Patch3: netpbm-10.35-alt-fix-overflow-destination-buffer.patch
Patch4: netpbm-10.35-alt-fix-userguide-name.patch

# security patches
Patch5: netpbm-10.34-rh-security-overflows.patch
Patch6: netpbm-10.29-rh-CAN-2005-2471.patch

# libjbig >= 2.0
Patch10: netpbm-10.35-alt-libjbig2.patch

# use mktemp(1) in shell scripts
Patch20: netpbm-10.29-alt-anytopnm-tmp.patch
Patch21: netpbm-10.29-alt-ppmquantall-tmp.patch
Patch22: netpbm-10.29-alt-pnmmargin-tmp.patch
Patch23: netpbm-10.29-alt-pamstretchgen-tmp.patch
Patch24: netpbm-10.29-alt-pnmindex-tmp.patch

# use File::Temp in perl scripts
Patch30: netpbm-10.29-alt-pnmquant-tmp.patch
Patch31: netpbm-10.29-alt-ppmshadow-tmp.patch
Patch32: netpbm-10.33-alt-ppmrainbow-tmp.patch
Patch33: netpbm-10.27-alt-ppmfade-tmp.patch

# more RedHat patches
Patch50: netpbm-10.32-rh-giftopnm-verbose-message.patch
Patch51: netpbm-10.35-rh-alt-bmptopnm.patch
Patch52: netpbm-10.30-rh-gcc4.patch
Patch53: netpbm-10.35-rh-ppmtompeg.patch
Patch54: netpbm-10.35-rh-xwdtopnm-x86_64.patch
Patch55: netpbm-10.34-rh-pamscale.patch
Patch56: netpbm-10.35-rh-pnmtofiascoleaks.patch
Patch57: netpbm-10.35-rh-docfix.patch
Patch58: netpbm-10.35-rh-glibc.patch
Patch59: netpbm-10.17-rh-time.patch
Patch60: netpbm-10.35-rh-ximtoppmsegfault.patch
Patch61: netpbm-10.35-rh-rgbtxt.patch
Patch62: netpbm-10.35-rh-pnmmontagefix.patch
Patch63: netpbm-10.35-rh-64bitfix.patch
Patch64: netpbm-9.24-rh-strip.patch
Patch65: netpbm-10.35-rh-svgtopam.patch
Patch66: netpbm-10.33-rh-multilib.patch

Requires: lib%name = %version-%release

# for manual pages
BuildPreReq: %_bindir/html2pod

# Automatically added by buildreq on Sat Nov 10 2007
BuildRequires: flex libjasper-devel libjbig-devel >= 2.0 libjpeg-devel libpng12-devel libtiff-devel libxml2-devel perl-podlators

%package doc
Summary: Tools for manipulating graphics files in netpbm supported formats
Group: Documentation

%package -n lib%name
Summary: A library for handling different graphics file formats
Group: System/Libraries
Requires: xorg-x11-rgb

%package -n lib%name-devel
Summary: A library for handling different graphics file formats
Group: Development/C
Requires: lib%name = %version-%release

%package -n lib%name-devel-static
Summary: A library for handling different graphics file formats
Group: Development/C
Requires: lib%name-devel = %version-%release

%description
The netpbm package contains programs for handling various graphics file
formats, including .pbm (portable bitmaps), .pgm (portable graymaps),
.pnm (portable anymaps), .ppm (portable pixmaps) and others.

%description doc
The netpbm package contains programs for handling various graphics file
formats, including .pbm (portable bitmaps), .pgm (portable graymaps),
.pnm (portable anymaps), .ppm (portable pixmaps) and others.

%description -n lib%name
This package contains a library of functions which support programs for
handling various graphics file formats, including .pbm (portable bitmaps),
.pgm (portable graymaps), .pnm (portable anymaps), .ppm (portable pixmaps)
and others.

%description -n lib%name-devel
This package contains the header files and programmer's documentation
for developing programs which can handle the various graphics file
formats supported by the netpbm library.

%description -n lib%name-devel-static
This package contains the static library for developing statically linked
programs which can handle the various graphics file formats supported by
the netpbm library.

%prep
%setup -a1

# build
%patch0 -p1
%patch1 -p1
%patch2 -p1
%patch3 -p2
%patch4 -p1

# security
%patch5 -p1
%patch6 -p1

# libjbig >= 2.0
%patch10 -p2

# mktemp
%patch20 -p1
%patch21 -p1
%patch22 -p1
%patch23 -p1
%patch24 -p1

# File::Temp
%patch30 -p1
%patch31 -p1
%patch32 -p1
%patch33 -p1

# RedHat
%patch50 -p1
%patch51 -p1
%patch52 -p1
%patch53 -p1
%patch54 -p1
%patch55 -p1
%patch56 -p1
%patch57 -p1
%patch58 -p1
%patch59 -p1
%patch60 -p1
%patch61 -p1
%patch62 -p1
%patch63 -p1
%patch64 -p1
%patch65 -p1
%patch66 -p1

# rename shhopt.h to pbmshhopt.h to avoid namespace conflicts
mv lib/util/{,pbm}shhopt.h
find -type f \( -name '*.[chl]' -o -iname '*makefile*' \) -print0 |
	xargs -r0 grep -FZl shhopt.h -- |
	xargs -r0 subst -p 's/\<shhopt\.h/pbm&/g' --

# rename conflicting functions and variables
sed -i 's/\<getline\>/ppm_&/g' converter/ppm/xpmtoppm.c

# use system jbig library
rm -v converter/other/jbig/{jbig.c,jbig_tab.c,jbig.h}

# use system jasper library
rm -rv converter/other/jpeg2000/libjasper/
sed -i '/^SUBDIRS = libjasper$/d' converter/other/jpeg2000/Makefile

# strict podlator syntax hacks
sed -r -i '/id="seealso"/i</dl>' userguide/pamtohtmltbl.html
sed -r -i '/-Cut here-/,/EndEntry/s/&nbsp;/ /g' userguide/pbmtoppa.html
sed -r -i 's/^<dt>([0-9]+)$/<dt>=\1/' userguide/pnmtojbig.html

%build
cat <<__EOF__ >lib/compile.h
#define COMPILE_TIME "$(LC_ALL=C date '+%%a %%b %%d %%Y')"
#define COMPILED_BY "%packager, %vendor"
__EOF__

cp -av Makefile.config{.in,}
cat <<__EOF__ >>Makefile.config
#
# ALT
#
CC = gcc
CFLAGS = %optflags -D_GNU_SOURCE
CFLAGS_SHLIB = %optflags_shared
SHLIB_CLIB = -lm
TIFFLIB = libtiff.so
JPEGLIB = libjpeg.so
PNGLIB = libpng.so
ZLIB = libz.so
JBIGLIB = %_libdir/libjbig.so
JASPERHDR_DIR = %_includedir/jasper
JASPERLIB = %_libdir/libjasper.so
STRIPFLAG =
pkgdir = %buildroot%prefix
__EOF__

# SMP incompatible
make

%install
%make_install install.bin install.data install.hdr
mkdir -p %buildroot%_libdir %buildroot%_datadir
cp -av lib/lib%name.a lib/lib%name.so* %buildroot%_libdir
mv %buildroot%prefix/misc %buildroot%_datadir/%name
rm -fv %buildroot%_bindir/manweb

# install netpbm-config
sed	-e '/^@/d'				\
	-e 's|@VERSION@|%version|'		\
	-e 's|@DATADIR@|%_datadir/%name|'	\
	-e 's|@LINKDIR@|%_libdir|'		\
	-e 's|@INCLUDEDIR@|%_includedir|'	\
	-e 's|@BINDIR@|%_bindir|'		\
		buildtools/config_template >%buildroot%_bindir/netpbm-config
egrep '@[A-Z]+@' %buildroot%_bindir/netpbm-config && exit 1
chmod +x %buildroot%_bindir/netpbm-config
test "$(%buildroot%_bindir/netpbm-config --datadir)" = %_datadir/%name

mkman()
{
	local section="$1" name="$2"
	local html="userguide/$name.html"
	if [ ! -f "$html" ]
	then
		echo "warning: HTML doc for $name not available" >&2
		return 0
	fi
	perl -ne 's/>GENERAL</>DESCRIPTION</g;				#\
		s{<a name=[^>]*>(.+?)</a>}{$1}gi;			#\
		s{<\?makeman\s+\.\S+\s*(.+?)\s*\?>}{<H1>$1</H1>}g;	#\
		s{<\?makeman\s+(.+?)\s*\?>}{<p>$1</p>}g && s/\\//g;	#\
		s{<[hH][12][^>]*>([A-Z ]+)</[hH][12]>}{<H1>$1</H1>}g;	#\
		$in = 1 if /^<[hH][12][^>]*>(NAME|SYNOPSIS)/;		#\
		last if /^<hr\b|table of contents/i and $in;		#\
		print "<p>" and next if /<p>This program is part of/i;	#\
		print if $in;' "$html" >"pod/$name.html"
	if [ ! -s "pod/$name.html" ]; then
		echo "warning: HTML doc for $name not convertable" >&2
		return 0
	fi
	html2pod "pod/$name.html" >"pod/$name.pod"
	grep -qs '^=head1 NAME' "pod/$name.pod"
	touch -r "$html" "pod/$name.pod"
	pod2man --name="$name" --center=Graphics --release="%name %version" \
		--section="$section" "pod/$name.pod" >"man/$name.$section"
}

mkdir -p pod man %buildroot{%_man1dir,%_man3dir,%_man5dir}
mkman 1 index; mv man/index.1 man/%name.1
subst 's/index 1/%name 1/g' man/%name.1
for f in %buildroot%_bindir/*; do mkman 1 "${f##*/}"; done
for f in libnetpbm libnetpbm_image libnetpbm_ug libpm \
	libpbm libpgm libpnm libppm; do mkman 3 "$f"; done
for f in pam pbm pgm pnm ppm; do mkman 5 "$f"; done
install -p -m644 man/*.1 %buildroot%_man1dir
install -p -m644 man/*.3 %buildroot%_man3dir
install -p -m644 man/*.5 %buildroot%_man5dir

%define pkgdocdir %_docdir/%name-%version
mkdir -p %buildroot%pkgdocdir
cp -a doc/{HISTORY,COPYRIGHT.PATENT,copyright_summary,Netpbm.programming} \
	README %buildroot%pkgdocdir
cp -a userguide %buildroot%pkgdocdir/html

%files -n lib%name
%_libdir/lib%name.so.?*
%dir %pkgdocdir
%pkgdocdir/copyright_summary
%pkgdocdir/COPYRIGHT.PATENT
%pkgdocdir/README

%files -n lib%name-devel
%_libdir/lib%name.so
%_includedir/*.h
%_man3dir/*.*
%dir %pkgdocdir
%pkgdocdir/Netpbm.programming

%files
%_bindir/*
%_man1dir/*.*
%_man5dir/*.*
%_datadir/%name/
%dir %pkgdocdir
%pkgdocdir/HISTORY

%files doc
%dir %pkgdocdir
%pkgdocdir/html/

%if_enabled static
%files -n lib%name-devel-static
%_libdir/lib%name.a
%endif

%changelog
