%set_automake_version 1.11

%define mpiimpl openmpi
%define mpidir %_libdir/%mpiimpl

Name: ngsolve
Version: 6.1
Release: alt1.dev.git20150323.qa1
Summary: NGSolve Finite Element Library
License: GPL or LGPL
Group: Sciences/Mathematics
Url: http://sourceforge.net/projects/ngsolve/
Packager: Eugeny A. Rostovtsev (REAL) <real at altlinux.org>

# git://git.code.sf.net/p/ngsolve/git
Source: %name-%version.tar

BuildPreReq: %mpiimpl-devel libnetgen-devel tcl-devel libscalapack-devel
BuildPreReq: libmumps-devel liblapack-devel libsuperlu-devel chrpath
BuildPreReq: libscotch-devel libparmetis-devel python-devel
BuildPreReq: libgomp-devel boost-python-devel
BuildPreReq: doxygen texlive-latex-recommended

%description
NGSolve is a general purpose Finite Element Library on top of Netgen.
With the basic library one can solve heat flow equations, Maxwell
equations, and solid mechanical problems. Several add-ons are available
for particular application classes.

%package -n lib%name
Summary: Shared libraries of NGSolve
Group: System/Libraries
%py_provides ngslib

%description -n lib%name
NGSolve is a general purpose Finite Element Library on top of Netgen.
With the basic library one can solve heat flow equations, Maxwell
equations, and solid mechanical problems. Several add-ons are available
for particular application classes.

This package contains shared libraries of NGSolve.

%package -n lib%name-devel
Summary: Development files of NGSolve
Group: Development/C++
Requires: lib%name = %version-%release
BuildArch: noarch

%description -n lib%name-devel
NGSolve is a general purpose Finite Element Library on top of Netgen.
With the basic library one can solve heat flow equations, Maxwell
equations, and solid mechanical problems. Several add-ons are available
for particular application classes.

This package contains development files of NGSolve.

%package -n python-module-%name
Summary: Python module of NGSolve
Group: Development/Python
Requires: lib%name = %version-%release

%description -n python-module-%name
NGSolve is a general purpose Finite Element Library on top of Netgen.
With the basic library one can solve heat flow equations, Maxwell
equations, and solid mechanical problems. Several add-ons are available
for particular application classes.

This package contains Python module of NGSolve.

%package demos
Summary: Demos for NGSolve
Group: Development/Documentation
Requires: lib%name = %version-%release
%add_python_req_skip fem

%description demos
NGSolve is a general purpose Finite Element Library on top of Netgen.
With the basic library one can solve heat flow equations, Maxwell
equations, and solid mechanical problems. Several add-ons are available
for particular application classes.

This package contains demos for NGSolve.

%package docs
Summary: Documentation for NGSolve
Group: Development/Documentation
BuildArch: noarch

%description docs
NGSolve is a general purpose Finite Element Library on top of Netgen.
With the basic library one can solve heat flow equations, Maxwell
equations, and solid mechanical problems. Several add-ons are available
for particular application classes.

This package contains development documentation for NGSolve.

%prep
%setup

sed -i 's|@PYVER@|%_python_version|' configure.ac

%build
source %mpidir/bin/mpivars.sh
export OMPI_LDFLAGS="-Wl,--as-needed,-rpath,%mpidir/lib -L%mpidir/lib"

%add_optflags -DPARALLEL -fpermissive
%autoreconf
%configure \
	--enable-parallel \
	--enable-mpi-threads \
	--enable-mumps \
	--enable-python \
	--with-netgen=%prefix \
	--with-lapack="-llapack -lopenblas" \
	--with-superlu=-I%_includedir \
	CXX=mpic++
%make_build -C ngstd libngstd.la
%make_build -C basiclinalg libngbla.la
%make_build -C fem libngfem.la
%make_build -C parallel libparallel.la
%make_build -C multigrid libngmg.la
%make_build -C comp libngcomp.la
%make_build -C linalg libngla.la
%make_build -C solve libngsolve.la
%make_build -C comp clean
%make_build -C comp libngcomp.la LIBNGLA=$PWD/linalg/libngla.la \
	LIBNGSOLVE=$PWD/solve/libngsolve.la
%make_build -C parallel clean
%make_build -C parallel libparallel.la LIBNGLA=$PWD/linalg/libngla.la
%make_build -C linalg clean
%make_build -C linalg LIBNGSOLVE=$PWD/solve/libngsolve.la
%make_build

doxygen
pushd doc
latex -output-format=pdf ngsolve.tex
popd

%install
source %mpidir/bin/mpivars.sh
export OMPI_LDFLAGS="-Wl,--as-needed,-rpath,%mpidir/lib -L%mpidir/lib"

install -d %buildroot%_libdir
install -m644 solve/.libs/*.so linalg/.libs/*.so \
	%buildroot%_libdir
make install DESTDIR=%buildroot \
	LIBPARALLEL=$PWD/parallel/libparallel.la \
	LIBNGSOLVE=$PWD/solve/libngsolve.la LIBNGCOMP=$PWD/comp/libngcomp.la \
	LIBNGLA=$PWD/linalg/libngla.la
install -d %buildroot%_includedir/%name
mv %buildroot%_includedir/*.h* %buildroot%_includedir/%name/

%ifarch x86_64
install -d %buildroot%python_sitelibdir
mv %buildroot%python_sitelibdir_noarch/* %buildroot%python_sitelibdir/
%endif

ln -s %_libdir/ngslib.so %buildroot%python_sitelibdir/

%files
%_bindir/ngsolve.tcl
%_datadir/%name

%files -n lib%name
%_libdir/*.so

%files -n lib%name-devel
%_includedir/*

%files demos
#doc programming_demos/*
%_bindir/*
%exclude %_bindir/ngsolve.tcl

%files docs
%doc doc/*.pdf doxy/html doc/quickstart/*.pdf
#doc %_datadir/%name

%files -n python-module-%name
%python_sitelibdir/*

%changelog
