%define py_geoip_pkg python-module-GeoIP
%define oname nicotine+

Name: nicotine-plus
Version: 1.2.16
Release: alt2.1

Summary: The client program for the SoulSeek filesharing system
Summary(ru_RU.UTF-8): Клиент для файлообменной сети SoulSeek

Group: Networking/File transfer
License: GPL
Url: http://nicotine-plus.sourceforge.net/

Packager: Vitaly Lipatov <lav@altlinux.ru>

Source: http://prdownloads.sf.net/%name/%oname-%version.tar
Source12: nicotine.48.png

Patch: %name-alt-desktop-entry.patch

BuildArch: noarch

Provides: nicotine
Obsoletes: nicotine

# manually removed: eric
# Automatically added by buildreq on Sat May 26 2007
BuildRequires: python-devel python-module-pygobject python-module-pyvorbis python-modules-compiler

BuildPreReq: rpm-build-python

Requires: python-module-sexy python-module-pygtk-libglade

%add_python_req_skip pywintypes win32con win32gui
BuildRequires: desktop-file-utils

# Mozilla does not embedding anymore
%add_python_req_skip gtkmozembed

%description
Nicotine is a feature-complete client for the SoulSeek filesharing network that
is used primarily to share music.

Nicotine supports everything a SoulSeek client is supposed to do, such as
downloading, uploading, searching, chatting, keeping a "buddy" list and has
lots of other features like finding similar users and getting listening
recommendations based on user's preferences.

Nicotine also supports a country code blocker using the GeoIP library.
To enable this functionality install the %py_geoip_pkg package.

Nicotine is a successor to the PySoulSeek project by Alexander Kanavin.

Nicotine supports psyco, an inline optimizer for python code,
you can install it from python-module-psyco package.

%description -l ru_RU.UTF-8
Nicotine -- это полнофункциональный клиент для файлообменной сети SoulSeek,
ориентированной, прежде всего, на обмен музыкой.

Nicotine поддерживает все стандартные для клиента сети SoulSeek функции, такие
как загрузка и пересылка файлов, поиск, чат, ведение списка "друзей", а также
множество других, как, например, поиск похожих пользователей и получение
рекомендаций по музыке на основе пользовательских предпочтений.

Помимо этого, Nicotine умеет блокировать пользователей из определённых стран,
посредством библиотеки GeoIP. Для включения данной функциональности необходимо
дополнительно установить пакет %py_geoip_pkg.

Nicotine является преемником проекта PySoulSeek, который создал Александр Канавин.

Nicotine поддерживает оптимизатор кода psyco, вы можете установить
его из пакета python-module-psyco.

%prep
%setup -n %oname-%version
#patch

%build
%python_build

%install
%python_install

%define _iconstheme    hicolor
%define _iconsbasedir  %_iconsdir/%{_iconstheme}
%define _icons16dir    %{_iconsbasedir}/16x16/apps
%define _icons48dir    %{_iconsbasedir}/48x48/apps

install -D -m644 files/%name-16px.png %buildroot%_icons16dir/%name.png
install -D -m644 files/%name-32px.png %buildroot%_niconsdir/%name.png
install -D -m644 %SOURCE12 %buildroot%_icons48dir/%name.png

rm -rf %buildroot%_datadir/nicotine/documentation/
ln -s nicotine.py %buildroot%_bindir/nicotine

%find_lang nicotine

desktop-file-install --dir %buildroot%_desktopdir \
	--remove-category=Application \
	--add-category=FileTransfer \
	--add-category=P2P \
	%buildroot%_desktopdir/nicotine.desktop

%files -f nicotine.lang
%_bindir/nicotine
%_bindir/nicotine.py
%doc doc/*
%python_sitelibdir/pynicotine/
%_desktopdir/*
%_icons16dir/*
%_niconsdir/*
%_icons48dir/*
%_man1dir/*
%_pixmapsdir/*
%_datadir/nicotine/

%changelog
