# This spec is backported to ALTLinux p8 automatically by rpmbph script from etersoft-build-utils.
#
# check deps/npm/package.json for it
%define npmver 5.6.0
# separate build npm
%def_without npm
# in other case, note: we will npm-@npmver-@release package! fix release if npmver is unchanged

%define major 8.11

#we need ABI virtual provides where SONAMEs aren't enough/not present so deps
#break when binary compatibility is broken
%global nodejs_abi %major

# TODO: really we have no configure option to build with shared libv8
# V8 presently breaks ABI at least every x.y release while never bumping SONAME,
# so we need to be more explicit until spot fixes that
%global v8_abi 6.2
%def_without systemv8

# supports only openssl >= 1.0.2
# see https://github.com/nodejs/node/issues/2783
%define openssl_version 1.0.2n
%def_with systemssl

%global libuv_abi 1.19.1
%def_with systemuv

%global libicu_abi 6.0
%def_without systemicu
# TODO: node has to use icu:: for ICU names
#add_optflags -DU_USING_ICU_NAMESPACE=1

%def_without systemnghttp2

%def_disable check

%define oversion %version

Name: node
Version: %major.4
Release: alt0.M80P.1

Summary: Evented I/O for V8 Javascript

Group: Development/Tools
License: MIT License
Url: http://nodejs.org/

##Source-git: https://github.com/nodejs/node.git
# Source-url: https://nodejs.org/dist/v%version/node-v%version.tar.gz
Source: %name-%version.tar

Source7: nodejs_native.req.files

BuildRequires(pre): rpm-macros-nodejs

BuildRequires: python-devel gcc-c++ zlib-devel

# can we use external gyp (not yet released)
#BuildRequires: gyp
BuildRequires: python-modules-json python-module-simplejson

%if_with systemv8
%define libv8_package libv8-nodejs
BuildRequires: %libv8_package-devel >= %v8_abi-devel
%endif

%if_with systemssl
BuildRequires: openssl-devel >= %openssl_version openssl
# for require strict library version
Requires: openssl >= %openssl_version
%endif

%if_with systemuv
BuildRequires: libuv-devel >= %libuv_abi
%endif

%if_with systemicu
BuildRequires: libicu-devel >= %libicu_abi
%endif

%if_with systemnghttp2
BuildRequires: libnghttp2-devel
%endif

BuildRequires: libhttp-parser-devel
BuildRequires: libcares-devel >= 1.11.0

BuildRequires: curl
Provides: nodejs(engine) = %version
Provides: nodejs = %version-%release
Provides: node.js = %version-%release
Obsoletes: nodejs < %version-%release
Obsoletes: node.js < %version-%release

Provides: nodejs(abi) = %{nodejs_abi}
Provides: nodejs(v8-abi) = %{v8_abi}

%add_python_req_skip TestCommon
%add_findreq_skiplist %{_datadir}/node/sources/*

%description
Node.js is a server-side JavaScript environment that uses an asynchronous
event-driven model.  Node's goal is to provide an easy way to build scalable
network programs.

%package devel
Summary:        Devel package for Node.js
Group:          Development/Other
License:        GPL
BuildArch:      noarch
Provides:	nodejs-devel = %version-%release
Requires:	%name = %version
Requires:       gcc-c++ zlib-devel libcares-devel
%if_with systemv8
Requires:	%libv8_package-devel >= %{v8_abi}
%endif
%if_with systemssl
Requires:	openssl-devel >= %openssl_version
%endif
%if_with systemuv
Requires: libuv-devel >= %libuv_abi
%else
Conflicts:      libuv-devel
%endif

%description devel
Node.js header and build tools


%package doc
Summary: Documentation files
Group: Development/Other
Requires: %name-devel = %version-%release

BuildArch: noarch

%description doc
Documentation files for %name.

%if_with npm
%package -n npm
Version:	%npmver
Group:		Development/Tools
Summary:	A package manager for node
License:	MIT License
Requires:	node
BuildArch:	noarch
AutoReq:	yes,nopython
Requires:	nodejs(abi) = %{nodejs_abi}

%description -n npm
npm is a package manager for node. You can use it to install and publish your
node programs. It manages dependencies and does other cool stuff.
%endif

%prep
%setup
%if_with systemv8
# hack against https://bugzilla.altlinux.org/show_bug.cgi?id=32573#c3
cp -a deps/v8/include/libplatform src
rm -rf deps/v8/
%endif
%if_with systemicu
rm -rf deps/icu-small/
%endif
%if_with systemuv
# TODO:
#rm -rf deps/uv/
%endif
%if_with systemnghttp2
rm -rf deps/nghttp2/
%endif
# TODO:
# rm -rf deps/zlib deps/openssl deps/cares deps/http-parser deps/gtest
%if_without npm
rm -rf deps/npm/
%endif

# use rpm's cflags
%__subst "s|'cflags': \[\],|'cflags': ['%optflags'],|" ./configure

%build
./configure \
    --prefix=%_prefix \
    --shared-zlib \
%if_with systemicu
    --with-intl=system-icu \
%endif
    --shared-http-parser \
    --shared-cares \
%if_with systemssl
    --shared-openssl \
    --shared-openssl-includes=%_includedir \
%endif
%if_without npm
    --without-npm \
%endif
%if_with systemuv
    --shared-libuv \
%endif
%if_with systemnghttp2
    --shared-nghttp2
%endif
%if_with systemv8
    --without-bundled-v8
%endif

%make_build BUILDTYPE=Release
%make doc
#%make jslint

%check
%make_build test

%install
mkdir -p %buildroot%nodejs_sitelib/

%makeinstall_std
install -d %buildroot%_sysconfdir/profile.d
echo 'export NODE_PATH="%{_libexecdir}/node_modules;%{_libexecdir}/node_altmodules"' >%buildroot%_sysconfdir/profile.d/node.sh
echo 'setenv NODE_PATH %{_libexecdir}/node_modules;%{_libexecdir}/node_altmodules' >%buildroot%_sysconfdir/profile.d/node.csh
chmod 0755 %buildroot%_sysconfdir/profile.d/*

%if_without systemuv
#install development headers
mkdir -p %{buildroot}%{_includedir}/node/
cp -p src/*.h %{buildroot}%{_includedir}/node
cp -p deps/uv/include/*.h %{buildroot}%{_includedir}/node
#cp -p deps/uv/include/uv-private/*.h %{buildroot}%{_includedir}/node/uv-private
%endif

%if_with npm
#node-gyp needs common.gypi too
mkdir -p %{buildroot}%{_datadir}/node
cp -p common.gypi %{buildroot}%{_datadir}/node
#tar -xf %{SOURCE0} --directory=%{buildroot}%{_datadir}/node/sources
%endif

# ensure Requires are added to every native module that match the Provides from
# the nodejs build in the buildroot
install -Dpm0755 %{SOURCE7} %buildroot%_rpmlibdir/nodejs_native.req.files
cat << EOF > %buildroot%_rpmlibdir/nodejs_native.req
#!/bin/sh
echo 'nodejs(abi) = %nodejs_abi'
echo 'nodejs(v8-abi) = %v8_abi'
EOF
chmod 0755 %buildroot%_rpmlibdir/nodejs_native.req

rm -rf %buildroot/usr/lib/dtrace/
rm -rf %buildroot/usr/share/doc/node/gdbinit
rm -rf %buildroot/usr/share/doc/node/lldb_commands.py
rm -rf %buildroot/usr/share/doc/node/lldbinit


# drop tapset file
rm -rf %buildroot%_datadir/systemtap/tapset

%files
%doc AUTHORS CHANGELOG.md LICENSE README.md
%_bindir/node
%dir %nodejs_sitelib
#%_datadir/systemtap/tapset/node.stp
%_man1dir/*
%_sysconfdir/profile.d/*

%files doc
%doc README.md out/doc/api

%files devel
%dir %_includedir/node/
#dir %_datadir/node/
%if_without systemuv
%_includedir/node/uv*
%endif
%if_without systemv8
%_includedir/node/v8*
%endif
%_includedir/node/node*
# deps/cares
#_includedir/node/ares*
%_includedir/node/common.gypi
%_includedir/node/config.gypi
%_includedir/node/libplatform/
# deps/http_parser
#_includedir/node/nameser.h
#_datadir/node/common.gypi
%_rpmlibdir/nodejs_native.req*
#%_datadir/node/sources

%if_with npm
%files -n npm
%_bindir/npm
%nodejs_sitelib/npm/
%exclude %_libexecdir/node_modules/npm/node_modules/node-gyp/gyp/tools/emacs
%endif

%changelog
