%define nspr_version 4.21

Summary:	Netscape Network Security Services(NSS)
Name:		nss
Version:	3.45.0
Release:	alt0.M80P.1
License:	MPL/GPL/LGPL
Group:		System/Libraries
Url:		http://www.mozilla.org/projects/security/pki/nss
Packager:	Alexey Gladkov <legion@altlinux.ru>

Source0:	nss-%version.tar
Source1:	nss.pc.in
Source2:	nss-config.in
Source4:	nss-db-%version.tar
Source5:	setup-nsssysinit.sh
Source6:	system-pkcs11.txt
Source7:	nss-pem-%version.tar

Patch0:		nss_with_system_nspr.patch
Patch2:		nss-no-rpath.patch
Patch3:		nss-use-sqlite.patch
Patch4:		nss-use-mozsqlite.patch
Patch5:		nss-fix-objdir.patch
Patch6:		nss-no-tests.patch

# Fedora patches
Patch10:	nss-enable-pem.patch

# Canonical pathes
Patch11:	lp1746947-revert-switch-default-to-sql.patch

BuildRequires:  gcc-c++
BuildRequires:  chrpath zlib-devel libsqlite3-devel
BuildRequires:  rpm-macros-alternatives
BuildRequires:  libnspr-devel >= %nspr_version
Requires:       libnspr       >= %nspr_version

%description
Network Security Services (NSS) is a set of libraries designed
to support cross-platform development of security-enabled server
applications. Applications built with NSS can support SSL v2
and v3, TLS, PKCS #5, PKCS #7, PKCS #11, PKCS #12, S/MIME,
X.509 v3 certificates, and other security standards.  See:
http://www.mozilla.org/projects/security/pki/nss/overview.html

%package -n lib%name
Summary:	Netscape Network Security Services(NSS)
Group:		System/Libraries

Provides:	%name = %version-%release

%description -n lib%name
Network Security Services (NSS) is a set of libraries designed
to support cross-platform development of security-enabled server
applications. Applications built with NSS can support SSL v2
and v3, TLS, PKCS #5, PKCS #7, PKCS #11, PKCS #12, S/MIME,
X.509 v3 certificates, and other security standards.  See:
http://www.mozilla.org/projects/security/pki/nss/overview.html

%package -n lib%name-sysinit
Summary:	System NSS Initilization
Group:		System/Libraries
Requires:	lib%name = %version-%release

Provides:	%name-sysinit
Provides:	%name-system-init

%description -n lib%name-sysinit
Default Operating System module that manages applications loading
NSS globally on the system. This module loads the system defined
PKCS #11 modules for NSS and chains with other NSS modules to load
any system or user configured modules.


%package -n lib%name-devel
Summary:	NSS development kit
Group:		Development/C
Requires:	lib%name = %version-%release

Provides:	%name-devel        = %version-%release
Provides:	%name-pkcs11-devel = %version-%release

%description -n lib%name-devel
NSS development kit

%package -n lib%name-devel-static
Summary:	NSS static libraries
Group:		Development/C
Requires:	lib%name-devel = %version-%release

Provides:	%name-devel-static = %version-%release

%description -n lib%name-devel-static
NSS development kit (static libs)

%if_with checkinstall
%package -n lib%name-nssckbi-checkinstall
Summary: Check p11-kit-trust.so and libnssckbi.so compatibility
Group: Security/Networking
Requires: p11-kit-checkinstall

%description -n lib%name-nssckbi-checkinstall
During installation check that p11-kit-trust.so and libnssckbi.so are
compatible with each other.
This package intedent to be used in the install check step in the build
system only and should not be installed in the real systems.
%endif

%package -n %name-utils
Summary:	Netscape Network Security Services Utilities
Group:		Development/Other
Requires:	lib%name = %version-%release

Provides:	%name-tools

%description -n %name-utils
Netscape Network Security Services Utilities


%prep
%setup -q
%setup -q -T -D -a7
%patch2 -p0
%patch5 -p2
%patch6 -p2

%patch10 -p0
%patch11 -p1

:>nss/coreconf/Werror.mk

pushd nss/tests/ssl
# Create versions of sslcov.txt and sslstress.txt that disable tests
# for SSL2 and EXPORT ciphers.
cat sslcov.txt| sed -r "s/^([^#].*EXPORT|^[^#].*SSL2)/#disabled \1/" > sslcov.noSSL2orExport.txt
cat sslstress.txt| sed -r "s/^([^#].*EXPORT|^[^#].*SSL2)/#disabled \1/" > sslstress.noSSL2orExport.txt
popd

%build
export BUILD_OPT=1 
export NS_USE_GCC=1
export CC_IS_GCC=1
export NSS_NO_SSL2_NO_EXPORT=1
export NSS_ENABLE_ECC=1
export NSS_ENABLE_WERROR=0
export NSS_USE_SYSTEM_SQLITE=1
export USE_SYSTEM_ZLIB=1
export PKG_CONFIG_ALLOW_SYSTEM_LIBS=1
export PKG_CONFIG_ALLOW_SYSTEM_CFLAGS=1
export NSPR_INCLUDE_DIR=/usr/include/nspr
export NSPR_LIB_DIR=%_libdir

# Generate symbolic info for debuggers
export XCFLAGS=$RPM_OPT_FLAGS

%ifarch x86_64
export USE_64=1
%endif

make -C nss/coreconf
make -C nss/coreconf platform 2>/dev/null |grep '^Linux' >destdir
make -C nss/lib/dbm
make -C nss

%install
mkdir -p %buildroot{%_bindir,%_libdir/pkgconfig,%_includedir}

# Get some variables
DESTDIR="$(head -1 destdir)"
NSPR_VERSION="$(nspr-config --version)"
nss_h="nss/lib/nss/nss.h"
NSS_VMAJOR="$(sed -ne 's,^#define[[:space:]]\+NSS_VMAJOR[[:space:]]\+,,p' "$nss_h")"
NSS_VMINOR="$(sed -ne 's,^#define[[:space:]]\+NSS_VMINOR[[:space:]]\+,,p' "$nss_h")"
NSS_VPATCH="$(sed -ne 's,^#define[[:space:]]\+NSS_VPATCH[[:space:]]\+,,p' "$nss_h")"

# Install NSS libraries 
cd dist
cp -aL "$DESTDIR"/bin/* %buildroot%_bindir
cp -aL "$DESTDIR"/lib/* %buildroot%_libdir

# Install NSS headers
cd public
cp -aL nss %buildroot%_includedir

# Install NSS utils
sed -e "s,@libdir@,%_libdir,g" \
    -e "s,@prefix@,%_prefix,g" \
    -e "s,@exec_prefix@,%_prefix,g" \
    -e "s,@includedir@,%_includedir/nss,g" \
    -e "s,@NSPR_VERSION@,$NSPR_VERSION,g" \
    -e "s,@NSS_VERSION@,%version,g" \
	%SOURCE1 > %buildroot/%_libdir/pkgconfig/nss.pc

sed -e "s,@libdir@,%_libdir,g" \
    -e "s,@prefix@,%_prefix,g" \
    -e "s,@exec_prefix@,%_prefix,g" \
    -e "s,@includedir@,%_includedir/nss,g" \
    -e "s,@MOD_MAJOR_VERSION@,$NSS_VMAJOR,g" \
    -e "s,@MOD_MINOR_VERSION@,$NSS_VMINOR,g" \
    -e "s,@MOD_PATCH_VERSION@,$NSS_VPATCH,g" \
    %SOURCE2 > %buildroot/%_bindir/nss-config

chmod 755 %buildroot/%_bindir/nss-config

# Add real RPATH
find "%buildroot%_bindir" "%buildroot%_libdir" -type f | 
while read f; do
  file "$f" | grep -qs ELF || continue
  if chrpath -l "$f" | fgrep -qs "RPATH="; then
    chrpath -d "$f"
  fi
done

# https://wiki.mozilla.org/NSS_Shared_DB
# https://wiki.mozilla.org/NSS_Shared_DB_Samples
# https://wiki.mozilla.org/NSS_Shared_DB_Howto
# https://wiki.mozilla.org/NSS_Shared_DB_And_LINUX
mkdir -p -- %buildroot/%_sysconfdir/pki/nssdb
tar -x -C %buildroot/%_sysconfdir/pki/nssdb -f %SOURCE4
find %buildroot/%_sysconfdir/pki/nssdb -name 'blank-*.db' -printf '%%h %%f\n' |
while read p n; do
	mv -f -- "$p/$n" "$p/${n##blank-}"
done

install -p -m755 %SOURCE5 %buildroot/%_bindir/setup-nsssysinit.sh
install -p -m644 %SOURCE6 %buildroot/%_sysconfdir/pki/nssdb/pkcs11.txt

# alternatives
mkdir -p -- %buildroot/%_libdir/nss
mv -- %buildroot/%_libdir/libnssckbi.so %buildroot/%_libdir/nss/libnssckbi.so

mkdir -p -- %buildroot/%_altdir
cat >%buildroot/%_altdir/libnssckbi-%name <<EOF
%_libdir/libnssckbi.so	%_libdir/nss/libnssckbi.so	10
EOF

%files -n %name-utils
%_bindir/*
%exclude %_bindir/setup-nsssysinit.sh
# Remove tests and samples
%exclude %_bindir/%name-config
%exclude %_bindir/bltest
%exclude %_bindir/dbtest
%exclude %_bindir/mangle
%exclude %_bindir/ocspclnt
%exclude %_bindir/oidcalc
%exclude %_bindir/sdrtest
%exclude %_bindir/shlibsign

%files -n lib%name
%_altdir/libnssckbi-%name
%_libdir/*.so*
%_libdir/*.chk
%_libdir/nss
%dir %_sysconfdir/pki/nssdb
%config(noreplace) %_sysconfdir/pki/nssdb/cert8.db
%config(noreplace) %_sysconfdir/pki/nssdb/key3.db
%config(noreplace) %_sysconfdir/pki/nssdb/secmod.db
%exclude %_libdir/libnsssysinit.so

%files -n lib%name-sysinit
%_libdir/libnsssysinit.so
%config(noreplace) %_sysconfdir/pki/nssdb/cert9.db
%config(noreplace) %_sysconfdir/pki/nssdb/key4.db
%config(noreplace) %_sysconfdir/pki/nssdb/pkcs11.txt
%_bindir/setup-nsssysinit.sh

%files -n lib%name-devel
%_bindir/%name-config
%dir %_includedir/%name
%_includedir/%name
%_libdir/pkgconfig/*

%files -n lib%name-devel-static
%_libdir/*.a

%if_with checkinstall
%files -n lib%name-nssckbi-checkinstall
%endif

# https://developer.mozilla.org/en-US/docs/Mozilla/Projects/NSS/NSS_{version}_release_notes
%changelog
