%def_disable test
%def_disable debug
%def_disable krb

Name: nss_ldap
Version: 265
Release: alt4
Packager: Anton Gorlov <stalker@altlinux.ru>

Summary: NSS library for LDAP
Summary(ru_RU.KOI8-R):  NSS  LDAP
 
License: LGPL
Group: System/Base
Url: http://www.padl.com/

Source0: ftp://ftp.padl.com/pub/%name-%version.tar.gz
Source1: %name-README.ALT
Source2: libc-lock.h

Patch0: %name-226-configure.patch
Patch1: %name-172-null.patch
Patch2: %name-210-explode_rdn-alt.patch
Patch5: nss-fixbuild.patch

Patch10: libdir.fix
#Patch11: alt-saslauxprop.fix


Requires: nscd
Provides: nss-ldap

# Automatically added by buildreq on Wed Aug 31 2005
BuildRequires: libkrb5-devel libldap-devel libsasl2-devel

%description
Nss_ldap is a set of C library extensions which allows X.500 and LDAP
directory servers to be used as a primary source of aliases, ethers,
groups, hosts, networks, protocol, users, RPCs, services and shadow
passwords (instead of or in addition to using flat files or NIS).

Install %name if you need to run LDAP access clients.

%description -l ru_RU.KOI8-R
Nss_ldap  ,   C,      X.500  LDAP    , ,  , , , , RPC,        NIS.

%prep
%setup -q
#patch0 -p0
#patch1 -p1
#patch2 -p1
#%patch3 -p1
#%patch4 -p1
%patch5 -p1

%patch10 -p1
##patch11 -p1

# Override hacked bits/libc_lock.h from glibc
mkdir bits
cp %SOURCE2 bits/libc-lock.h

###
## Install Attention README
###
install -m 0644 %SOURCE1 README.ALT

%build
%autoreconf

%configure \
	--with-ldap-conf-file=%_sysconfdir/nss_ldap.conf \
	--with-ldap-secret-file=%_sysconfdir/nss_ldap.secret \
	--with-ldap-lib=openldap \
	--enable-schema-mapping \
	--enable-paged-results \
%if_enabled krb
	--enable-configurable-krb5-ccname-gssapi \
	--enable-configurable-krb5-ccname-env \
	--with-gssapi-dir=%_includedir/krb5/gssapi \
%endif
%if_enabled debug
	--enable-debugging
%endif

%make_build SYSLIBDIR=/%_lib
%make check

%install

mkdir -p $RPM_BUILD_ROOT{%_sysconfdir,%_libdir,/%_lib}

# Install the nsswitch module.
%make_install  SYSLIBDIR=/%_lib install \
	DESTDIR=$RPM_BUILD_ROOT \
	INST_UID=`id -un` INST_GID=`id -gn`

mv $RPM_BUILD_ROOT%_libdir/* $RPM_BUILD_ROOT/%_lib/
chmod 755 $RPM_BUILD_ROOT/%_lib/*.so*

# Install /etc/nss_ldap.conf, becouse in nss_ldap and pam_ldap we have two the same files /etc/ldap.conf as a config files
# Install the default configuration file, but change the search bases to
# something generic.
sed -e 's/dc=padl/dc=example/g' ldap.conf >$RPM_BUILD_ROOT%_sysconfdir/nss_ldap.conf
sed -i 's/#timelimit 30/timelimit 5/g' $RPM_BUILD_ROOT%_sysconfdir/nss_ldap.conf
sed -i 's/#bind_timelimit 30/bind_timelimit 5/g' $RPM_BUILD_ROOT%_sysconfdir/nss_ldap.conf
sed -i 's/#bind_policy hard/bind_policy soft/g' $RPM_BUILD_ROOT%_sysconfdir/nss_ldap.conf
chmod 644 $RPM_BUILD_ROOT%_sysconfdir/nss_ldap.conf
rm -f $RPM_BUILD_ROOT%_sysconfdir/nsswitch.ldap
rm -f $RPM_BUILD_ROOT%_sysconfdir/ldap.conf

%files
/%_lib/*.so*
%config(noreplace) %_sysconfdir/nss_ldap.conf
%doc ANNOUNCE AUTHORS ChangeLog NEWS README
%doc nsswitch.ldap
%doc ldap.conf
%doc README.ALT
%doc %_man5dir/*
    
#[TODO]
#      krb
#
#

%changelog
