Name: ntfs-3g
Version: 2016.2.22
Release: alt1
Epoch: 2
Summary: third generation Linux NTFS driver
URL: http://www.ntfs-3g.org/
Group: System/Kernel and hardware
License: GPL2
Packager: Valery Inozemtsev <shrek@altlinux.ru>

Requires: lib%name = %epoch:%version-%release
Provides: ntfsprogs = %epoch:%version-%release fuse-ntfs = %epoch:%version-%release
Obsoletes: ntfsprogs fuse-ntfs

Source0: %{name}_ntfsprogs-%version.tgz

BuildRequires: libattr-devel libfuse-devel libgcrypt-devel libgnutls-devel libuuid-devel

%description
The ntfs-3g driver is an open source, freely available read/write NTFS
driver, which provides safe and fast handling of the Windows XP, Windows
Server 2003, Windows 2000 and Windows Vista filesystems. Almost the full
POSIX filesystem functionality is supported, the major exceptions are
changing the file ownerships and the access rights.

This package contains utils for %name

%package -n lib%name
Summary: Shared libraries for %name
Group: System/Libraries
Provides: libntfs = %epoch:%version-%release

%description -n lib%name
The ntfs-3g driver is an open source, freely available read/write NTFS
driver, which provides safe and fast handling of the Windows XP, Windows
Server 2003, Windows 2000 and Windows Vista filesystems. Almost the full
POSIX filesystem functionality is supported, the major exceptions are
changing the file ownerships and the access rights.

This package contains shared libraries for %name

%package -n lib%name-devel
Summary: Development files for %name
Group: Development/C
Requires: lib%name = %epoch:%version-%release
Provides: libntfs-devel = %epoch:%version-%release
Obsoletes: libntfs-devel

%description -n lib%name-devel
The ntfs-3g driver is an open source, freely available read/write NTFS
driver, which provides safe and fast handling of the Windows XP, Windows
Server 2003, Windows 2000 and Windows Vista filesystems. Almost the full
POSIX filesystem functionality is supported, the major exceptions are
changing the file ownerships and the access rights.

This package contains header files for %name

%prep
%setup -q -n %{name}_ntfsprogs-%version

%build
%autoreconf
%configure \
	--sbindir=/sbin \
	--bindir=/bin \
	--with-fuse=external \
	--enable-posix-acls \
	--enable-crypto \
	--disable-ldconfig \
	--disable-static
%make_build

%install
%make DESTDIR=%buildroot install

ln -sf ../bin/ntfs-3g %buildroot/sbin/mount.ntfs

mkdir -p %buildroot/%_lib
for f in %buildroot%_libdir/lib*.so; do
	t=$(readlink "$f")
	ln -sf ../../%_lib/"$t" "$f"
done
mv %buildroot%_libdir/lib*.so.* %buildroot/%_lib/

%files
%doc AUTHORS CREDITS ChangeLog NEWS
/sbin/*
/bin/*
%_man8dir/*

%files -n lib%name
/%_lib/lib*.so.*

%files -n lib%name-devel
%_includedir/ntfs-3g
%_libdir/lib*.so
%_pkgconfigdir/*.pc

%changelog
