%def_with translation

Name: nvidia-settings
Version: 410.73
Release: alt3

Group: System/Configuration/Hardware
Summary: Tool for configuring the NVIDIA driver
Url: ftp://download1.nvidia.com/XFree86/nvidia-settings/
License: GPL

Source: %name-%version.tar.gz
Source1: %name-16.png
Source2: %name-32.png
Source3: %name-48.png
Source4: nvidia-settings.sh
Source5: nvidia-settings.desktop
Source100: gettext.h
Source101: ru.po

Patch1: xlibs.patch
Patch2: cflags.patch
Patch3: alt-ui-modules-dir.patch
Patch100: nvidia-settings-410.73-alt-integrate-translation.patch

# Automatically added by buildreq on Mon May 13 2013 (-bi)
# optimized out: elfutils fontconfig fontconfig-devel glib2-devel libGL-devel libX11-devel libXext-devel libXrender-devel libatk-devel libcairo-devel libfreetype-devel libgdk-pixbuf libgdk-pixbuf-devel libgio-devel libpango-devel libwayland-client libwayland-server pkg-config python-base xorg-randrproto-devel xorg-renderproto-devel xorg-videoproto-devel xorg-xextproto-devel xorg-xf86vidmodeproto-devel xorg-xproto-devel
#BuildRequires: libXrandr-devel libXv-devel libXxf86vm-devel libgtk+2-devel libvdpau-devel ruby ruby-stdlibs
BuildRequires(pre): rpm-build-ubt
BuildRequires: libXrandr-devel libXv-devel libXxf86vm-devel libGL-devel libvdpau-devel
BuildRequires: libdbus-devel
BuildRequires: libgtk+2-devel libgtk+3-devel

%description
The `nvidia-settings` utility is a tool for configuring the NVIDIA
Linux graphics driver.  It operates by communicating with the NVIDIA
X driver, querying and updating state as appropriate.  This
communication is done with the NV-CONTROL X extension.

Values such as brightness and gamma, XVideo attributes, temperature,
and OpenGL settings can be queried and configured via nvidia-settings.

When nvidia-settings starts, it reads the current settings from
its configuration file and sends those settings to the X server.
Then, it displays a graphical user interface (GUI) interface for
configuring the current settings.  When nvidia-settings exits, it
queries the current settings from the X server and saves them to
the configuration file.

%package devel
Group: Development/Other
Summary: Development files for %name
Provides: libXNVCtrl-devel = %version-%release
Obsoletes: libXNVCtrl-devel < %version-%release
%description devel
Development files for %name

%prep
%setup -q
#%patch1 -p1
%patch2 -p1
%patch3 -p1
%if_with translation
mkdir -p po/msg
%patch100 -p2
install -p -m644 %SOURCE100 src/gtk+-2.x/gettext.h
install -p -m644 %SOURCE101 po/msg/ru.po
%endif

sed -i 's|@GUI_LIB_PREFIX@|%_libdir/nvidia-settings|' src/nvidia-settings.c

sed -i -E 's|LIBDIR[[:space:]]+=[[:space:]].*|LIBDIR = $(DESTDIR)$(PREFIX)/%_lib|' utils.mk

%build
#pushd src/libXNVCtrl
#rm -f libXNVCtrl.a
#gcc %optflags -I/usr/include/X11/extensions -c NVCtrl.c
#ar rcs libXNVCtrl.a NVCtrl.o
#popd
%make_build PREFIX=%prefix LOCAL_CFLAGS="%optflags"


%install
make install DESTDIR=%buildroot PREFIX=%prefix bindir=%buildroot/%_bindir mandir=%buildroot/%_man1dir

#mkdir -p %buildroot/%_bindir
#install -m 0755 nvidia-settings %buildroot/%_bindir

for p in %buildroot/%_libdir/%name/* ; do
    new_path=`echo "$p" | sed 's|\.so\..*|.so|'`
    [ "$p" == "$new_path" ] \
	|| ln -s `basename $p` $new_path
done

mkdir -p %buildroot/%_sysconfdir/X11/xinit.d/
install -m 0755 %SOURCE4 %buildroot/%_sysconfdir/X11/xinit.d/%name.sh

mkdir -p %buildroot/%_iconsdir/hicolor/{16x16,32x32,48x48}/apps
install -m 0644 %SOURCE1 %buildroot/%_iconsdir/hicolor/16x16/apps/%name.png
install -m 0644 %SOURCE2 %buildroot/%_iconsdir/hicolor/32x32/apps/%name.png
install -m 0644 %SOURCE3 %buildroot/%_iconsdir/hicolor/48x48/apps/%name.png

mkdir -p %buildroot/%_desktopdir
install -m 0644 %SOURCE5 %buildroot/%_desktopdir/

mkdir -p %buildroot/%_libdir
install -m 0644 src/libXNVCtrl/libXNVCtrl.a %buildroot/%_libdir/

mkdir -p %buildroot/%_includedir/NVCtrl/
install -m 0644 src/libXNVCtrl/*.h %buildroot/%_includedir/NVCtrl/

%find_lang %name

%files -f %name.lang
%doc doc/*.txt
%_man1dir/%name.*
%_bindir/%name
%_libdir/%name/*gtk3*.so*
%_sysconfdir/X11/xinit.d/%name.sh
%_desktopdir/%name.desktop
%_iconsdir/*/*/apps/%name.png

%files devel
%doc doc/FRAMELOCK.txt doc/NV-CONTROL-API.txt samples/README samples/*.{c,h}
%_includedir/NVCtrl/
%_libdir/*.a

%changelog
