
%define tbname         NVIDIA-Linux-x86
%ifarch x86_64
%define tbname         NVIDIA-Linux-x86_64
%endif
%define bin_pkg_name     nvidia_glx
%define module_name    nvidia
%define dirsuffix %nil
%ifarch x86_64
%define dirsuffix -no-compat32
%endif

# version-release
%define nv_version 367
%define nv_release 35
%define nv_minor %nil
%define pkg_rel alt160
%def_enable kernelsource

%define tbver %{nv_version}.%{nv_release}.%{nv_minor}
%if "%nv_minor" == "%nil"
%define tbver %{nv_version}.%{nv_release}
%endif
%define module_version	%nv_version%nv_release%nv_minor
%define module_release	%pkg_rel

%define myGroup System/Kernel and hardware
%define mySummary NVIDIA drivers and OpenGL libraries for XOrg X-server
%define mySummaryRu Драйверы NVIDIA и библиотеки OpenGL для Х-сервера XOrg
%define myUrl http://www.nvidia.com
%define myVendor NVIDIA Corp.
%define myLicense NVIDIA

%define mods /modules
%define exts /modules/extensions
%define drvs /modules/drivers
%define lib_sym_dir %_sysconfdir/X11/%_lib
%define nv_lib_sym_dir %{lib_sym_dir}_nvidia
%define nv_lib32_sym_dir %_sysconfdir/X11/lib_nvidia
%define xdrv_d /usr/libexec/X11/drv.d
%define xdrv_d_old /usr/X11R6/lib/drv.d
%define xdrv_pre_d /usr/libexec/X11/drvpre.d
%define xdrv_pre_d_old /usr/X11R6/lib/drvpre.d

%define xinf_dir %_datadir/hwdatabase/videoaliases/
%define nv_workdirdir %_localstatedir/nvidia
%define tls_lib_dir %_libdir
%define x11_lib_dir %_libdir
%define x11_lib_old /usr/X11R6/lib
%define x11_mod_dir /usr/%_lib/X11%mods
%define x11_mod_old /usr/X11R6/%_lib%mods
%define x11_drv_dir /usr/%_lib/X11%drvs
%define x11_drv_old /usr/%_lib/X11%drvs
%define x11_ext_dir /usr/%_lib/X11%exts
%define x11_ext_old /usr/X11R6/%_lib%exts
%define x11driver_dir %_libdir/X11
%define nv_lib_dir_prefix %_libdir/nvidia_
%define nv_lib_dir_prefix_old /usr/X11R6/%_lib/nvidia_
%define nv_lib_dir %nv_lib_dir_prefix%tbver

#add_findreq_skiplist %nv_lib_dir/
%add_findreq_skiplist %x11_lib_old/*
%add_findreq_skiplist %_bindir/nvidia-bug-report*.sh

%if "%nv_minor" == "%nil"
Name: nvidia_glx_src_%nv_version.%nv_release
Version: %nv_version.%nv_release
%else
Name: nvidia_glx_src_%nv_version.%nv_release.%nv_minor
Version: %nv_version.%nv_release.%nv_minor
%endif
Release: %pkg_rel

Source0: null
Source201: ftp://download.nvidia.com/XFree86/Linux-x86/%tbver/NVIDIA-Linux-x86-%tbver.run
Source202: ftp://download.nvidia.com/XFree86/Linux-x86_64/%tbver/NVIDIA-Linux-x86_64-%tbver-no-compat32.run

Source2: nvidia.xinf
Source100: nvidia_create_xinf

Patch1: alt-fix-build-kernel.patch
Patch2: alt-ignore-dma-remap.patch
Patch3: buildfix_kernel_4.7-1.patch
Patch4: buildfix_kernel_4.7-2.patch

BuildRequires: kernel-build-tools rpm-macros-alternatives
BuildRequires: libXext-devel
#BuildRequires: libGLdispatch libGLX
ExclusiveArch: %ix86 x86_64
#ExcludeArch: ppc64 x86_64 ppc s390 s390x ia64



Group: %myGroup
Summary: %mySummary
Summary(ru_RU.UTF-8): %mySummaryRu
Url: %myUrl
License: %myLicense
%description
Sources for %{bin_pkg_name}_%{version} package


%package -n %{bin_pkg_name}_%{version}
PreReq: %{bin_pkg_name}_common >= %version
Requires(post): x11presetdrv
Requires: libGLdispatch libGLX
#
Group: %myGroup
Summary: %mySummary
Summary(ru_RU.UTF-8): %mySummaryRu
Url: %myUrl
License: %myLicense
#
%description -n %{bin_pkg_name}_%{version}
NVIDIA XFree86 4.x server drivers and OpenGL libraries for GeForce/Quadro
based video cards. Older RIVA 128 and RIVA TNT/TNT2 based video cards are
supported by the server module shipping with XOrg, nv_drv.so. You
should install this package if you have one of the newer cards.

You must also install the NVIDIA_kernel package for your current kernel
if you want NVIDIA module and OpenGL libraries for XOrg X server.
#
%description -n %{bin_pkg_name}_%{version} -l ru_RU.UTF-8
Драйверы и OpenGL-библиотеки для Х-сервера X11 и видеокарт NVIDIA на базе
GeForce/Quadro. Более ранние версии видеокарт на базе RIVA 128 и RIVA TNT/TNT2
поддерживаются модулем nv_drv.so, входящим в состав сервера XOrg.
Если вы имеете одну из этих новых видеокарт, то вам желательно установить данный
пакет.

Если вы желаете использовать модули NVIDIA и библиотеки OpenGL для Х-сервера XOrg,
то вы должны также установить пакет NVIDIA_kernel для текущего ядра.

%package -n kernel-source-%module_name-%module_version
Group: Development/Kernel
Summary: Linux %module_name modules sources
License: %myLicense
Packager: Kernel Maintainer Team <kernel@packages.altlinux.org>
#
%description -n kernel-source-%module_name-%module_version
%module_name modules sources for Linux kernel

%prep
%setup -T -c -n %tbname-%tbver%dirsuffix
rm -rf %_builddir/%tbname-%tbver%dirsuffix
cd %_builddir
%ifarch x86_64
sh %SOURCE202 -x
%else
sh %SOURCE201 -x
%endif
cd %tbname-%tbver%dirsuffix

pushd kernel
#%patch1 -p1
%patch2 -p1
%patch3 -p1
%ifarch x86_64
%patch4 -p1
%endif
rm -rf precompiled
popd


%build


%install
%set_verify_elf_method textrel=relaxed
%brp_strip_none %_libdir/*
%brp_strip_none %nv_lib_dir/*

soname()
{
    readelf -a $1| grep SONAME| sed 's/.*\[//'| sed 's/\].*//'
}

%__mkdir_p %buildroot/%_sbindir
%__mkdir_p %buildroot/%tls_lib_dir
%__mkdir_p %buildroot/%nv_lib_dir
%__mkdir_p %buildroot/%x11_mod_dir
#%__mkdir_p %buildroot/%x11_mod_old
%__mkdir_p %buildroot/%x11_drv_dir
#%__mkdir_p %buildroot/%x11_drv_old
%__mkdir_p %buildroot/%x11_ext_dir
#%__mkdir_p %buildroot/%x11_ext_old
%__mkdir_p %buildroot/%lib_sym_dir
%__mkdir_p %buildroot/%nv_lib_sym_dir
%__mkdir_p %buildroot/%nv_lib32_sym_dir
%__mkdir_p %buildroot/%xdrv_d
#%__mkdir_p %buildroot/%xdrv_d_old
%__mkdir_p %buildroot/%xdrv_pre_d
%__mkdir_p %buildroot/%xinf_dir
%__mkdir_p %buildroot/%nv_workdirdir
%__mkdir_p %buildroot/%_datadir/nvidia/


# install libraries
%__install -m 0644 libnvidia-glcore.so.%tbver %buildroot/%_libdir/
%__install -m 0644 libnvidia-eglcore.so.%tbver %buildroot/%_libdir/
%__install -m 0644 libnvidia-glsi.so.%tbver %buildroot/%_libdir/
%__install -m 0644 tls/libnvidia-tls.so.%tbver %buildroot/%_libdir/

%__ln_s %nv_lib_dir/nvidia.xinf %buildroot/%nv_lib_sym_dir/nvidia.xinf
%__ln_s %nv_lib_dir/nvidia.xinf %buildroot/%xinf_dir/nvidia-%version.xinf
%__install -m 0644 %SOURCE2 %buildroot/%nv_lib_dir/nvidia.xinf

if [ -f nvidia_drv.o ] ; then
    %__install -m 0644 nvidia_drv.o  %buildroot/%nv_lib_dir/
fi
if [ -f nvidia_drv.so ] ; then
    %__install -m 0644 nvidia_drv.so %buildroot/%nv_lib_dir/
fi

[ -f libnvidia-wfb.so.%tbver ] && \
%__install -m 0644 libnvidia-wfb.so.%tbver %buildroot/%nv_lib_dir/libwfb.so

%__install -m 0644 libglx.so.%tbver %buildroot/%nv_lib_dir/libglx.so
%__ln_s libglx.so %buildroot/%nv_lib_dir/libglx.a

%__install -m 0644 libGLdispatch.so.0  %buildroot/%nv_lib_dir/libGLdispatch.so
#
#%__install -m 0644 libGL.so.1.0.0  %buildroot/%nv_lib_dir/libGL.so
%__install -m 0644 libGL.so.%tbver  %buildroot/%nv_lib_dir/libGL.so
#
%__install -m 0644 libEGL.so.1  %buildroot/%nv_lib_dir/libEGL.so
%__install -m 0644 libEGL_nvidia.so.%tbver    %buildroot/%nv_lib_dir/libEGL_nvidia.so
%__install -m 0644 libGLESv2.so.2  %buildroot/%nv_lib_dir/libGLESv2.so
%__install -m 0644 libGLESv2_nvidia.so.%tbver %buildroot/%nv_lib_dir/libGLESv2_nvidia.so
%__install -m 0644 libGLESv1_CM.so.1  %buildroot/%nv_lib_dir/libGLESv1_CM.so
%__install -m 0644 libGLESv1_CM_nvidia.so.%tbver %buildroot/%nv_lib_dir/libGLESv1_CM_nvidia.so
%__install -m 0644 libGLX.so.0  %buildroot/%nv_lib_dir/libGLX.so
%__install -m 0644 libGLX_nvidia.so.%tbver    %buildroot/%nv_lib_dir/libGLX_nvidia.so

%__install -m 0644 libvdpau_nvidia.so.%tbver %buildroot/%nv_lib_dir/libvdpau_nvidia.so
%__install -m 0644 libnvidia-cfg.so.%tbver %buildroot/%nv_lib_dir/libnvidia-cfg.so
/sbin/ldconfig -n %buildroot/%nv_lib_dir

%__install -m 0644 nvidia-application-profiles-%version-rc \
    %buildroot/%_datadir/nvidia/nvidia-application-profiles-%version-rc
%__install -m 0644 nvidia-application-profiles-%version-key-documentation \
    %buildroot/%_datadir/nvidia/nvidia-application-profiles-%version-key-documentation

# kernel-source install
%__rm -rf kernel-source-%module_name-%module_version/
%__mkdir_p %buildroot/%_usrsrc/kernel/sources/ kernel-source-%module_name-%module_version/
%__cp -ar kernel/* kernel-source-%module_name-%module_version/
%__cp LICENSE kernel-source-%module_name-%module_version/
tar -c kernel-source-%module_name-%module_version | bzip2 -c > \
    %buildroot%_usrsrc/kernel/sources/kernel-source-%module_name-%module_version.tar.bz2

# install scripts
mkdir -p %buildroot/%_bindir
install -m 0755 nvidia-bug-report.sh %buildroot/%_bindir/nvidia-bug-report-%version.sh
mkdir -p %buildroot/%_altdir/
cat > %buildroot/%_altdir/%name <<__EOF__
%_bindir/nvidia-bug-report.sh %_bindir/nvidia-bug-report-%version.sh %version
__EOF__


%post -n %{bin_pkg_name}_%{version}
# switch nvidia driver and libraries
if [ -z "$DURING_INSTALL" ]; then
    X11PRESETDRV=`which x11presetdrv 2>/dev/null`
    if [ -n "$X11PRESETDRV" ]; then
	$X11PRESETDRV ||:
    else
	echo "Warning! x11presetdrv program not found!" >&2
    fi
fi

%files -n %{bin_pkg_name}_%{version}
%doc LICENSE
%doc html NVIDIA_Changelog README.txt
#
%_libdir/libnvidia-tls.so.%version
%_libdir/libnvidia-glcore.so.%version
%_libdir/libnvidia-eglcore.so.%version
%_libdir/libnvidia-glsi.so.%version
%_altdir/%name
%_bindir/nvidia-bug-report-%version.sh
%dir %nv_lib_dir
%nv_lib_dir/nvidia_drv.*
%nv_lib_dir/libglx.*
%nv_lib_dir/libGL.so*
%nv_lib_dir/libEGL.so*
%nv_lib_dir/libEGL_nvidia.so*
%nv_lib_dir/libGLESv2.so*
%nv_lib_dir/libGLESv2_nvidia.so*
%nv_lib_dir/libGLESv1_CM.so*
%nv_lib_dir/libGLESv1_CM_nvidia.so*
%nv_lib_dir/libGLX_nvidia.so*
%nv_lib_dir/libGLdispatch.so*
%nv_lib_dir/libGLX.so*
%nv_lib_dir/libnvidia-cfg.so*
%nv_lib_dir/libvdpau_nvidia.so*
%nv_lib_dir/libwfb.so
%nv_lib_dir/libnvidia-wfb.so*
%nv_lib_dir/nvidia.xinf
%xinf_dir/nvidia-%version.xinf
%_datadir/nvidia/nvidia-application-profiles-%version-rc
%_datadir/nvidia/nvidia-application-profiles-%version-key-documentation

%if_enabled kernelsource
%files -n kernel-source-%module_name-%module_version
%_usrsrc/*
%endif

%changelog
