# TEXTREL on i386
#/usr/lib/ocaml/unix.cmxs
#/usr/lib/ocaml/str.cmxs
#/usr/lib/ocaml/nums.cmxs
#/usr/lib/ocaml/bigarray.cmxs
#/usr/lib/ocaml/graphics.cmxs
%set_verify_elf_method textrel=relaxed
# fix for build on armv7
%remove_optflags -fomit-frame-pointer

Name: ocaml
Version: 4.04.2
Release: alt1%ubt

Summary: The Objective Caml compiler and programming environment
License: QPL & LGPL
Group: Development/ML

Url: http://caml.inria.fr/
Packager: %packager

Source0: %name-%version.tar
Source1: %name.desktop
Source2: ocaml-reqprov.ml

Patch1: ocaml-3.12.1-alt-stdlib-pdf.patch
Patch2: ocaml-4.01-alt-mk-reqprov.patch

Requires: rpm-build-ocaml >= 1.1
BuildRequires(pre): rpm-build-ocaml >= 1.1.1
BuildRequires(pre): rpm-build-ubt

Conflicts: ocaml4
Obsoletes: ocaml4
Provides: ocaml4

# Automatically added by buildreq on Mon Sep 23 2013
BuildRequires: texlive-latex-base texlive-latex-recommended

# Better keep those deps explicit, just in case
BuildRequires: libX11-devel

Requires: %name-runtime = %version-%release

%package runtime
Summary: Runtime part of the OCaml system
Group: Development/ML
Provides: %name-runtime = %(v=%version; IFS=.; set $v; echo "$1.$2") 
# For some reason, this is Requires, not Provides.
Requires: %_rpmlibdir/ocaml-reqprov
Obsoletes: ocaml4-runtime

%package graphics
Summary: Graphics primitives
Group: Development/ML
Requires: %name = %version-%release
Requires: %name-graphics-runtime = %version-%release
Provides: ocaml4-graphics
Obsoletes: ocaml4-graphics

%package graphics-runtime
Summary: Graphics primitives
Group: Development/ML
Requires: %name-runtime = %version-%release
Provides: ocaml4-graphics-runtime
Obsoletes: ocaml4-graphics-runtime


%package ocamldoc
Summary: The Objective Caml documentation generator
Group: Development/ML
Requires: %name = %version-%release
Provides: ocaml4-ocamldoc
Obsoletes: ocaml4-ocamldoc

%description
Objective Caml is a high-level, strongly-typed, functional and
object-oriented programming language from the ML family of languages.

This package comprises two batch compilers (a fast bytecode compiler and
an optimizing native-code compiler), an interactive toplevel system,
Lex&Yacc tools, a replay debugger, and a comprehensive library.

%description runtime
Objective Caml is a high-level, strongly-typed, functional and
object-oriented programming language from the ML family of languages.

This package contains the runtime environment needed to run Objective
Caml bytecode.

%description graphics
Objective Caml is a high-level, strongly-typed, functional and
object-oriented programming language from the ML family of languages.

This package provides machine-independent graphics primitives
and additional graphics primitives for the X Windows system.

%description graphics-runtime
Objective Caml is a high-level, strongly-typed, functional and
object-oriented programming language from the ML family of languages.

This package provides machine-independent graphics primitives
and additional graphics primitives for the X Windows system.

%description ocamldoc
Objective Caml is a high-level, strongly-typed, functional and
object-oriented programming language from the ML family of languages.

This package provides OCamldoc, a tool that generates documentation
from special comments embedded in source files.

%prep
%setup -q -T -b 0

%patch1 -p1
%patch2 -p1

%build

sed -i 's@/usr/X11R6/lib\>@%_x11libdir@g' configure

%add_optflags -DUSE_NON_CONST -D_FILE_OFFSET_BITS=64
./configure -with-pthread -fPIC -bindir %_bindir -libdir %_libdir/ocaml -mandir %_mandir
make BYTECCCOMPOPTS="%optflags" NATIVECCCOMPOPTS="%optflags" world.opt
make BYTECCCOMPOPTS="%optflags" NATIVECCCOMPOPTS="%optflags" ocamlopt
make BYTECCCOMPOPTS="%optflags" NATIVECCCOMPOPTS="%optflags" opt opt.opt

install -pD -m644 %SOURCE2 tools/reqprov.ml
make -C tools reqprov

%install
make install BINDIR=%buildroot%_bindir LIBDIR=%buildroot%_libdir/ocaml MANDIR=%buildroot%_mandir
mkdir -p %buildroot%_libdir/ocaml/stublibs

perl -pi -e "s|%buildroot||" %buildroot%_libdir/ocaml/ld.conf

install -p -m644 parsing/asttypes.{mli,cmi} %buildroot%_libdir/ocaml/
install -p -m644 parsing/parsetree.{mli,cmi} %buildroot%_libdir/ocaml/
install -p -m644 bytecomp/cmo_format.{mli,cmi} %buildroot%_libdir/ocaml/
install -p -m644 typing/annot.{mli,cmi} %buildroot%_libdir/ocaml/
install -p -m644 asmcomp/clambda.{mli,cmi,cmo,cmx,o} %buildroot%_libdir/ocaml/
install -p -m644 asmcomp/cmx_format.{mli,cmi} %buildroot%_libdir/ocaml/
# install -p -m644 asmcomp/debuginfo.{mli,cmi,cmx} %buildroot%_libdir/ocaml/

# install -p -m644 tools/depend.{mli,cmi,cmo,cmx,o} %buildroot%_libdir/ocaml/

ln -snf ocamlc.opt %buildroot%_bindir/ocamlc
ln -snf ocamlopt.opt %buildroot%_bindir/ocamlopt
ln -snf ocamldep.opt %buildroot%_bindir/ocamldep
ln -snf ocamllex.opt %buildroot%_bindir/ocamllex

# Option -g not available in native code version.
#ln -snf ocamldoc.opt %buildroot%_bindir/ocamldoc

install -pD -m755 tools/ocamlobjinfo.opt %buildroot%_bindir/ocamlobjinfo
install -pD -m755 tools/reqprov %buildroot%_rpmlibdir/ocaml-reqprov

# Removal of .cmx files prevents global optimization and triggers
# annoying warning 58 introduced in Ocaml 4.03. This is the
# reason for commenting out the following lines.
# find %buildroot%_libdir/ocaml -type f -name '*.cmx' |
# while read f; do [ -f "${f%%.cmx}.o" ] || rm "$f"; done

install -pm644 -D %SOURCE1 %buildroot%_desktopdir/%name.desktop

%files
%doc Changes LICENSE README.adoc
%_bindir/ocaml*
%exclude %_bindir/ocamlrun
%exclude %_bindir/ocamldoc*
%_man1dir/ocaml*
%exclude %_man1dir/ocamldoc*
%_man3dir/*.3o*
%_libdir/ocaml/camlheader
%_libdir/ocaml/camlheader_ur
%_libdir/ocaml/expunge
%_libdir/ocaml/extract_crc
%_libdir/ocaml/VERSION
%_libdir/ocaml/*.*
%_libdir/ocaml/objinfo_helper
%exclude %_libdir/ocaml/ld.conf
%exclude %_libdir/ocaml/*graphics*
%_libdir/ocaml/caml/
%_libdir/ocaml/compiler-libs/
%exclude %_libdir/ocaml/ocamldoc/
%_libdir/ocaml/threads/
%_libdir/ocaml/vmthreads/
%_desktopdir/%name.desktop

%files runtime
%_bindir/ocamlrun
%dir %_libdir/ocaml
%config %_libdir/ocaml/ld.conf
%dir %_libdir/ocaml/stublibs
%_libdir/ocaml/stublibs/dllbigarray.so
%_libdir/ocaml/stublibs/dllnums.so
%_libdir/ocaml/stublibs/dllcamlstr.so
%_libdir/ocaml/stublibs/dllthreads.so
%_libdir/ocaml/stublibs/dllunix.so
%_libdir/ocaml/stublibs/dllvmthreads.so
%dir %_libdir/ocaml/stublibs
%_rpmlibdir/ocaml-reqprov

%files graphics
%_libdir/ocaml/*graphics*

%files graphics-runtime
%_libdir/ocaml/stublibs/dllgraphics.so

%files ocamldoc
%_bindir/ocamldoc*
%_man1dir/ocamldoc*
%_libdir/ocaml/ocamldoc/

%changelog
