%global _unpackaged_files_terminate_build 1

%global oname bolt
Name: ocaml-%oname
Version: 1.4
Release: alt1

Summary: Logging tool for OCaml

BuildRequires(pre): rpm-build-licenses
License: %lgpl3only
Group: Development/ML
Url: http://bolt.x9c.fr

Source: %oname-%version.tar

# "requires unsafe-string", i.e., is not compatible with ocaml >= 4.06
# (Note GPR#1252 for 4.06 in
# http://caml.inria.fr/pub/distrib/ocaml-4.07/notes/Changes )
#
# See these commits in https://github.com/ocaml/opam-repository
# for this statement and alternative patches (abandoned for some reason):
#
# 58859032baa4fdbdca3acd7255010e847fba048d (bolt.1.4 requires unsafe-string)
#
# 2d5340e89100e4f03e5adc7efd99e55793adf347 (Remove bolt patches.
# It reverts the non relevant 48253add766a4e7d0786be39994f2194edcf471d commit)
#
# 48253add766a4e7d0786be39994f2194edcf471d (Add a patch to the bolt tarball
# in order to allow compilation with ocaml-version >= "4.06.0":
# change from String to Bytes)
#
# TODO: discuss this with Sylvain Pogodalla (the author of the patch).
BuildPreReq: ocaml < 4.06.0

BuildRequires: ocaml-ocamlbuild ocaml-camlp4-devel

%description
bolt is a logging tool for OCaml (similar to log4j for Java).

There is also a possibity to use it with Java (according to the authors).

%prep
%setup -n %oname-%version

%build
chmod +x configure
./configure

# Will it work?
#make_build all
%make all

%install
%global path_install %ocamldir/%oname
%make install PATH_INSTALL=%buildroot%path_install
# That was not enough because Makefile hardcode "lib/" and not "lib64/":
#make install PATH_OCAML_PREFIX=%buildroot%_prefix

# Or should we better use findlib instead of manual copying?
cp META -t %buildroot%path_install

%check
%make tests

%files
%path_install
%doc CHANGES COPYING* doc FEATURES README

%changelog
