# on i586: /usr/lib/ocaml/site-lib/cryptokit/cryptokit.cmxs
%set_verify_elf_method textrel=relaxed

%global pkgname cryptokit
%define ocamlsitelib %_libdir/ocaml
%define pkgsitelib %ocamlsitelib/%pkgname
%define ocamlstublib %_libdir/ocaml/stublibs/

Name: ocaml-%pkgname
Version: 1.11
Release: alt3%ubt
Group: Development/ML
Summary: OCaml library of cryptographic and hash functions
License: LGPLv2 with exceptions
Url: http://forge.ocamlcore.org/projects/cryptokit/
Source0: %name-%version.tar
BuildRequires: ocaml ocaml-ocamldoc ocaml-ocamlbuild ocaml-zarith-devel ocaml-findlib zlib-devel chrpath
BuildRequires(pre): rpm-build-ubt
Provides: ocaml-cryptokit-runtime = %version-%release
Obsoletes: ocaml-cryptokit-runtime

%description
The Cryptokit library for Objective Caml provides a variety of
cryptographic primitives that can be used to implement cryptographic
protocols in security-sensitive applications. The primitives provided
include:

* Symmetric-key cryptography: AES, DES, Triple-DES, ARCfour, in ECB,
  CBC, CFB and OFB modes.
* Public-key cryptography: RSA encryption and signature; Diffie-Hellman
  key agreement.
* Hash functions and MACs: SHA-1, SHA-256, RIPEMD-160, MD5, and MACs
  based on AES and DES.
* Random number generation.
* Encodings and compression: base 64, hexadecimal, Zlib compression.

Additional ciphers and hashes can easily be used in conjunction with
the library. In particular, basic mechanisms such as chaining modes,
output buffering, and padding are provided by generic classes that can
easily be composed with user-provided ciphers. More generally, the
library promotes a "Lego"-like style of constructing and composing
transformations over character streams.

%package devel
Summary: Development files for %name
Requires: %name = %version-%release
Group: Development/ML

%description devel
The %name-devel package contains libraries and signature files for
developing applications that use %name.

%prep
%setup

%build
./configure --destdir %buildroot
# Some sort of circular dependency, so sometimes the first make fails.
# Just run make twice.
make ||:
make

chrpath --delete _build/src/dllcryptokit_stubs.so

%install
mkdir -p %buildroot%ocamlstublib
export OCAMLFIND_DESTDIR=%buildroot%ocamlsitelib
make install

%files
%doc LICENSE.txt
%pkgsitelib
%exclude %pkgsitelib/*.mli
%ocamlstublib/*.so*

%files devel
%doc README.txt Changes
%pkgsitelib/*.mli

%changelog
