Name: ocaml-xml-light
Version: 2.4
Release: alt3%ubt
Summary: Minimal XML parser and printer for OCaml

Group: Development/ML
License: LGPLv2+
Url: https://opam.ocaml.org/packages/xml-light/
Source0: %name-%version.tar

BuildRequires: ocaml-ocamldoc ocaml-findlib
BuildRequires(pre):rpm-build-ubt

%description
Xml-Light is a minimal XML parser & printer for OCaml. It provides
functions to parse an XML document into an OCaml data structure, work
with it, and print it back to an XML document. It support also DTD
parsing and checking, and is entirely written in OCaml, hence it does
not require additional C library.

%package devel
Summary: Development files for %name
Group: Development/ML
Requires: %name = %version-%release

%description devel
The %name-devel package contains libraries and signature files for
developing applications that use %name.

%prep
%setup

%build
make all doc
make opt
sed -e 's/@VERSION@/%version/' < META.in > META

%install
export OCAMLFIND_DESTDIR=%buildroot%_libdir/ocaml
mkdir -p $OCAMLFIND_DESTDIR/stublibs
rm -f test.*
ocamlfind install xml-light META *.mli *.cmi *.cma *.a *.cmxa *.cmx

%files
%doc README
%_libdir/ocaml/xml-light
%exclude %_libdir/ocaml/xml-light/*.a
%exclude %_libdir/ocaml/xml-light/*.cmxa
%exclude %_libdir/ocaml/xml-light/*.cmx
%exclude %_libdir/ocaml/xml-light/*.mli

%files devel
%doc README doc/*
%_libdir/ocaml/xml-light/*.a
%_libdir/ocaml/xml-light/*.cmxa
%_libdir/ocaml/xml-light/*.cmx
%_libdir/ocaml/xml-light/*.mli

%changelog
