Name: octave
Version: 4.0.1
Release: alt2

%define docdir %_defaultdocdir/%name-%version

Summary: GNU Octave -- a high-level language for numerical computations
License: GPLv3
Group: Sciences/Mathematics
Url: http://www.octave.org/
Packager: Paul Wolneykien <manowar@altlinux.org>

BuildRequires: flex gcc-c++ gcc-fortran libcurl-devel libfftw3-devel libglpk-devel
BuildRequires: libhdf5-devel liblapack-devel libncurses-devel libpcre-devel
BuildRequires: libreadline-devel libstdc++-devel libtinfo-devel libX11-devel libXext-devel
BuildRequires: libSM-devel libICE-devel liblcms-devel bzlib-devel libltdl-devel
BuildRequires: libGraphicsMagick-c++-devel libGL-devel libGLU-devel libfreetype-devel
BuildRequires: libftgl-devel zlib-devel desktop-file-utils gnuplot less
BuildRequires: texlive-base-bin texlive-generic-recommended
BuildRequires: libarpack-ng-devel
BuildRequires: libqt4-devel
BuildRequires: libqscintilla2-qt4-devel
BuildPreReq: libqhull-devel fontconfig-devel libfltk-devel
BuildPreReq: libqrupdate-devel libsuitesparse-devel gperf libXft-devel
BuildPreReq: libpixman-devel libcairo-devel libXinerama-devel
BuildPreReq: libXfixes-devel
#Added buildreq-src
BuildPreReq: java-devel-default libX11-devel libgl2ps-devel libncurses-devel libpcre-devel libsuitesparse-devel libtinfo-devel llvm-devel pkgconfig(fontconfig) pkgconfig(freetype2) pkgconfig(portaudio-2.0) pkgconfig(sndfile) pkgconfig(xft) texinfo

Source0: %name-%version-%release.tar
Source1: octave.filetrigger

Patch0: octave-include-pcre.patch

Requires: gnuplot

%package devel
Summary: GNU Octave -- development part
Group: Development/C
Requires: %name = %version-%release

%package doc
Summary: GNU Octave -- documentation
Group: Development/Other
BuildArch: noarch

%description
GNU Octave is a high-level language, primarily intended for numerical
computations. It provides a convenient command line interface for
solving linear and nonlinear problems numerically, and for performing
other numerical experiments using a language that is mostly compatible
with Matlab. It may also be used as a batch-oriented language.

Octave has extensive tools for solving common numerical linear algebra
problems, finding the roots of nonlinear equations, integrating
ordinary functions, manipulating polynomials, and integrating ordinary
differential and differential-algebraic equations. It is easily
extensible and customizable via user-defined functions written in
Octave's own language, or using dynamically loaded modules written in
C++, C, Fortran, or other languages.

%description devel
GNU Octave is a high-level language, primarily intended for numerical
computations. It provides a convenient command line interface for
solving linear and nonlinear problems numerically, and for performing
other numerical experiments using a language that is mostly compatible
with Matlab. It may also be used as a batch-oriented language.

This package contains development libraries and header files.

%description doc
GNU Octave is a high-level language, primarily intended for numerical
computations. It provides a convenient command line interface for
solving linear and nonlinear problems numerically, and for performing
other numerical experiments using a language that is mostly compatible
with Matlab. It may also be used as a batch-oriented language.

This package contains extra documentation for GNU Octave.

%define _libexecdir %_libdir

%prep
%setup
%patch0 -p2

%build
%add_optflags $(pkg-config hdf5-seq --cflags) $(pcre-config --cflags)
%add_optflags $(pkg-config fontconfig --cflags) -fpermissive
%autoreconf
%configure --with-blas=openblas \
    --enable-dl --enable-shared \
    --disable-static --disable-rpath \
    --enable-lite-kernel --enable-picky-flags
#smp-unaware
%make

%install
%makeinstall

mkdir -p %buildroot%_datadir/octave/packages
mkdir -p %buildroot%_libdir/octave/packages

gzip -c ChangeLog >ChangeLog.gz

# Install the filetrigger for packages:
install -pm0755 -D %SOURCE1 %buildroot%_rpmlibdir/%name.filetrigger

# required to suppress verify-elf warnings
mkdir -p %buildroot%_rpmmacrosdir
_octave_libs=
for lib in `ls %buildroot%_libdir/%name/%version/lib*.so.?`; do
    lib=${lib##%buildroot}
    _octave_libs="$_octave_libs $lib"
done
cat > %buildroot%_rpmmacrosdir/%{name}.env <<EOF
export RPM_LD_PRELOAD_octave='$_octave_libs'
export RPM_FILES_TO_LD_PRELOAD_octave='%_libdir/%name/packages/*'
EOF

#check
#make check

%files
%doc BUGS COPYING NEWS* README ChangeLog.gz
%_bindir/%{name}*

%_datadir/%name
%_libdir/%name/%version/*.so*
%_libdir/%name/%version/exec
%_libdir/%name/%version/oct
%exclude %_libdir/%name/%version/*.la*

%dir %_libdir/%name
%dir %_libdir/%name/%version
%dir %_datadir/%name/packages
%dir %_libdir/%name/packages

%_infodir/octave.info*
%_infodir/liboctave.info*

%_man1dir/*

%_desktopdir/*.desktop

%_rpmlibdir/%name.filetrigger

%_datadir/appdata/*.appdata.xml
%_datadir/icons/hicolor/*/apps/octave.png
%_datadir/icons/hicolor/*/apps/octave.svg

%files devel
%_includedir/%name-%version
%_bindir/mkoctfile
%_bindir/mkoctfile-%version
%_rpmmacrosdir/%{name}.env

%files doc
%doc doc/interpreter/octave.html doc/liboctave/liboctave.html doc/interpreter/octave.pdf doc/liboctave/liboctave.pdf doc/refcard/refcard*.pdf

%changelog
