# This spec is backported to ALTLinux p8 automatically by rpmbph script from etersoft-build-utils.
#
%define post 35
Name: 	  omi
Version:  1.2.0
Release:  alt1.M80P.2

Summary:  Open Management Infrastructure
License:  MIT
Group:    Other
Url:      https://github.com/Microsoft/omi

Packager: Vitaly Lipatov <lav@altlinux.ru>

# Source-url: https://github.com/Microsoft/omi/archive/v%version-%post.tar.gz
Source:   %name-%version.tar

# Automatically added by buildreq on Fri Jun 02 2017
# optimized out: libcom_err-devel libkrb5-devel libstdc++-devel lsb-release pkg-config python-base python-modules python3 python3-base
BuildRequires: gcc-c++ libpam-devel libssl-devel openssl lsb-core

%description
Open Management Infrastructure (OMI) is an open source project
to further the development of a production quality implementation
of the DMTF CIM/WBEM standards.
The OMI CIMOM is also designed to be portable and highly modular.

In order to attain its small footprint, it is coded in C,
which also makes it a much more viable CIM Object Manager for embedded systems
and other infrastructure components that have memory constraints for their management processor.

%package -n lib%name

Summary: Open Management Infrastructure
Group: Development/C

%description -n lib%name
Open Management Infrastructure (OMI) is an open source project
to further the development of a production quality implementation
of the DMTF CIM/WBEM standards.
The OMI CIMOM is also designed to be portable and highly modular.

In order to attain its small footprint, it is coded in C,
which also makes it a much more viable CIM Object Manager for embedded systems
and other infrastructure components that have memory constraints for their management processor.

%package -n lib%name-devel

Summary: Open Management Infrastructure
Group: Development/C
Requires: lib%name = %version-%release

%description -n lib%name-devel
Development files for %name.

%package -n lib%name-internal-devel

Summary: Open Management Infrastructure
Group: Development/C
Requires: lib%name-devel = %version-%release

%description -n lib%name-internal-devel
Internal development files for %name.


%prep
%setup
%__subst "s|.*-rpath.*|true|g" Unix/buildtool

%build
# FIXME: version
export OMI_BUILDVERSION_MAJOR=1
export OMI_BUILDVERSION_MINOR=2
export OMI_BUILDVERSION_PATCH=0
export OMI_BUILDVERSION_BUILDNR=%post
cd Unix
./configure --prefix=%prefix --localstatedir=/var/omi --sysconfdir=/etc/omi \
	--libdir=%_libdir --includedir=%_includedir/omi --datadir=%_datadir/%name \
	--certsdir=/etc/omi/ssl
#	 --credsdir=/etc/omi/creds

%make_build

%install
cd Unix
%makeinstall_std
mkdir -p %buildroot%_includedir/omi/{pal,base,sock,oi,nits/base}/
cp base/*.h %buildroot%_includedir/omi/base/
cp sock/*.h %buildroot%_includedir/omi/sock/
cp oi/*.h %buildroot%_includedir/omi/oi/
rm -f %buildroot%_includedir/omi/oi/oi_etw.h
cp nits/base/nits.h %buildroot%_includedir/omi/nits/base/
cp common/common.h %buildroot%_includedir/omi/
cp common/localizestr.h %buildroot%_includedir/omi/
cp output/include/config.h %buildroot%_includedir/omi/
cp -a pal/*.h %buildroot%_includedir/omi/pal/
subst "s|common/linux/sal.h|linux/sal.h|g" %buildroot%_includedir/omi/pal/palcommon.h
rm -f %buildroot%_includedir/omi/pal/{strlcat.h,strlcpy.h}
mkdir -p %buildroot%_includedir/omi/linux/
cp -a common/linux/sal.h %buildroot%_includedir/omi/linux/

mkdir -p %buildroot%_libdir/%name/{bin,lib}/
cp output/bin/{chkshlib,mkdep,oigenc,strhash} %buildroot%_libdir/%name/bin/
ln -sr %buildroot%_bindir/omireg %buildroot%_libdir/%name/bin/omireg
ln -sr %buildroot%_bindir/omigen %buildroot%_libdir/%name/bin/omigen
cp output/lib/*.a %buildroot%_libdir/%name/lib/
#cp output/lib/libnits.so %buildroot%_libdir/%name/lib/

#%check
#%make_build check

%files
%dir %_sysconfdir/omi/
%_sysconfdir/omi/omiregister/
%_sysconfdir/omi/ssl/
%config(noreplace) %_sysconfdir/omi/*.conf
%_bindir/*
#_man1dir/*
%doc LICENSE CONTRIBUTING.md README.md

%files -n lib%name
%_libdir/*.so
%_datadir/%name/

%files -n lib%name-devel
%dir %_includedir/omi/
%_includedir/omi/MI.h
%_includedir/omi/micxx/
%_includedir/omi/omiclient/

%files -n lib%name-internal-devel
%_libdir/%name/
%_includedir/omi/common.h
%_includedir/omi/config.h
%_includedir/omi/localizestr.h
%_includedir/omi/linux/
%_includedir/omi/pal/
%_includedir/omi/base/
%_includedir/omi/sock/
%_includedir/omi/oi/
%_includedir/omi/nits/

%changelog
