Name: openbabel
Version: 2.3.2
Release: alt2

Summary: Chemistry software file format converter
License: GPL
Group: Sciences/Chemistry

Url: http://openbabel.sourceforge.net
Source0: http://dl.sf.net/%name/%name-%version.tar.gz
Source1: %name.watch
Patch1: alt-gcc5.patch

Packager: Michael Shigorin <mike@altlinux.org>

# Automatically added by buildreq on Sun Apr 13 2014
# optimized out: cmake-modules fontconfig libcloog-isl4 libgdk-pixbuf libstdc++-devel libwayland-client libwayland-server pkg-config python-base zlib-devel
BuildRequires: cmake eigen2 gcc-c++ libcairo-devel libwxGTK-devel libxml2-devel python-devel xml-utils

BuildPreReq: python-devel eigen2

Summary(ru_RU.UTF-8): Конвертор биохимических форматов данных
Summary(uk_UA.UTF-8): Конвертор біохімічних форматів даних

%description
Open Babel is a project designed to pick up where Babel left off,
as a cross-platform program and library designed to interconvert
between many file formats used in molecular modeling and computational
chemistry.

%description -l ru_RU.UTF-8
Open Babel - продолжение проекта Babel как кросплатформенного
инструмента для конвертирования многочисленных форматов данных,
используемых в молекулярном моделировании и вычислительной химии.

%description -l uk_UA.UTF-8
Open Babel - продовження проекту Babel як кросплатформенного
інструменту для конвертування численних форматів даних, що
використовуються у молекулярному моделюванні та обчислювальній хімії.

%package -n lib%name
Summary: Shared libraries for programs which will use Open Babel
Group: System/Libraries

%package -n lib%name-devel
Summary: Development tools for programs which will use the lib%name library
Group: Development/C++
Requires: lib%name = %version-%release

%package -n python-module-%name
Summary: Python bindings for Open Babel
Group: Development/Python
Requires: lib%name = %version-%release

%if_enabled static
%package -n lib%name-devel-static
Summary: Static development files for lib%name
Group: Development/C++
Requires: lib%name-devel = %version-%release

%description -n lib%name-devel-static
Static development files for lib%name
%endif

%description -n lib%name
Shared libraries for programs which will use Open Babel

%description -n lib%name-devel
The lib%name-devel package includes the header files and static libraries
necessary for developing programs using the lib%name library.

If you are going to develop programs which will use this library
you should install lib%name-devel.  You'll also need to have the
lib%name package installed.

%description -n python-module-%name
Python bindings for Open Babel.

%prep
%setup
%patch1 -p1
echo PYTHON_BINDINGS:BOOL=ON >CMakeCache.txt

%build
%add_optflags -I%_includedir/eigen2
%cmake_insource
%make_build VERBOSE=1
gzip -9nf ChangeLog

%install
%makeinstall_std

# FIXME: 2.3.2 kludge, argh
mkdir -p %buildroot%python_sitelibdir
mv %buildroot%_libdir/{_openbabel.so,*.py*} \
   %buildroot%python_sitelibdir/

%if_enabled static
%else
rm -f %buildroot%_libdir/*.a
rm -f %buildroot%_libdir/%name/{%version/,}*.{a,la}
%endif

%files
%doc AUTHORS ChangeLog* README THANKS 
%doc doc/FAQ* doc/README* doc/dioxin.*
%_bindir/*
%_man1dir/*
%_datadir/%name

%files -n lib%name
%_libdir/*.so.*
%dir %_libdir/%name/
%dir %_libdir/%name/%version/
%_libdir/%name/%version/*.so

%files -n lib%name-devel
%_includedir/*
%_libdir/*.so
%_pkgconfigdir/*.pc
%_libdir/cmake/openbabel2

%files -n python-module-%name
%python_sitelibdir/*

%if_enabled static
%files -n lib%name-devel-static
%_libdir/*.a
%endif

# TODO:
# - BR: eigen3 (FTBFS as of 20140413)

%changelog
