Name: opencascade
Version: 6.8.0
Release: alt1
Summary: Development platform for 3D modeling and numerical simulation
License: BSD-like
Group: Development/Tools
Url: http://www.opencascade.org
Packager: Eugeny A. Rostovtsev (REAL) <real at altlinux.org>

Source: OpenCASCADE_src.tar
Source1: LICENSE_LGPL_21.txt
Source2: OSD_Common.hxx

Requires: lib%name = %version-%release
Requires: %name-common = %version-%release

BuildPreReq: gcc-c++ libX11-devel libGL-devel libGLU-devel
BuildPreReq: tcl-devel tcl-tix libfltk-devel tk-devel libXmu-devel
BuildPreReq: java-devel-default libcoin3d-devel libfreetype-devel
BuildPreReq: python-module-gist libtbb-devel libftgl-devel
BuildPreReq: libgl2ps-devel zlib-devel libfreeimage-devel
BuildPreReq: libXext-devel libvtk6.2-devel libqt4-devel

%description
Open CASCADE Technology version 6.3., a minor release, which introduces quite a
number of new features and improved traditional functionality along with certain
changes over the previous public release and maintenance releases exclusively
available to the customers.

This release makes Open CASCADE Technology even a more powerful and stable
development platform for 3D modeling and numerical simulation applications. 

%package -n lib%name
Summary: Shared libraries of Open CASCADE
Group: System/Libraries

%description -n lib%name
Shared libraries of Open CASCADE, development platform for 3D modeling and
numerical simulation applications.

%package -n lib%name-devel
Summary: Development files for Open CASCADE Technology
Group: Development/C++
Requires: lib%name = %version-%release
Requires: %name-common = %version-%release
Conflicts: svgalib-devel

%description -n lib%name-devel
Development files for Open CASCADE Technology, development platform for 3D
modeling and numerical simulation applications.

%package common
Summary: Architecture independent files of Open CASCADE
Group: Development/C++
BuildArch: noarch
AutoReq: yes, noshebang

%description common
Architecture independent files of Open CASCADE, development platform for 3D
modeling and numerical simulation applications.

%prep
%setup
install -p -m644 %SOURCE1 .
install -p -m644 %SOURCE2 src/OSD

rm -fR data doc samples

%build
export DISTRIBUTIVE_DIR=$PWD
export CASROOT=$PWD
DEFS="-DHAVE_IOSTREAM -DHAVE_IOMANIP -DHAVE_FSTREAM -DHAVE_SYS_IPC_H"
DEFS="$DEFS -DHAVE_IOS -UHAVE_SYS_SEM_H -UUSE_OLD_STREAMS"
DEFS="$DEFS -DSEMOP_NO_REFERENCE=1 -UDECOSF1"
%add_optflags $DEFS -fpermissive
%autoreconf
%configure \
	--with-gl-include=%_includedir \
	--with-gl-library=%_libdir \
	--with-xmu-include=%_includedir/X11/Xmu \
	--with-xmu-library=%_libdir \
	--with-tcl=%_libdir \
	--with-tk=%_libdir \
	--with-x \
	--with-tbb-include=%_includedir/tbb \
	--with-tbb-library=%_libdir \
	--with-freetype=%prefix \
	--with-freeimage=%prefix \
	--with-ftgl=%prefix \
	--disable-static \
	--enable-debug \
	--enable-production \
	--enable-wrappers=yes \
	--enable-wok=yes \
	--enable-draw=yes \
	--with-java-include=%_libexecdir/jvm/java/include \
	--with-gl2ps=%prefix \
	--with-vtk-include=%_includedir/vtk-6.2 \
	--with-vtk-library=%_libdir \
	--with-qt=%_libdir/qt4

for i in $(find ./ -name Makefile) libtool; do
	sed -i 's|\-O2|-O1|g' $i
done
if [ "%__nprocs" = "1" -o "%__nprocs" = "" ]; then
	NPROCS=2
else
	NPROCS=%__nprocs
fi
sed -i 's|define VERSION|define OCCVERSION|' config.h
%make -j$NPROCS
#make

%install
%makeinstall
#sed -i \
#	-e '1s/ksh\ \-f/sh/' \
#	-e '1a\export CASROOT=%_datadir/%name' \
#	-e 's/\/\$OS_NAME//g' \
#	%buildroot%prefix/env_DRAW.sh
#sed -i 's|src|share/%name/src|g' %buildroot%prefix/env_DRAW.sh
#ifarch x86_64
#sed -i 's|/lib|/lib64|g' %buildroot%prefix/env_DRAW.sh
#endif

install -d %buildroot%_datadir/%name
#mv %buildroot%prefix/env_DRAW.sh %buildroot%_datadir/%name/
mv %buildroot%prefix/src %buildroot%_datadir/%name/
mv %buildroot%prefix/inc %buildroot%_includedir
#install -d %buildroot%_datadir/%name/src/jcas
#install -p -m644 src/jcas/* %buildroot%_datadir/%name/src/jcas

install -d %buildroot%_includedir/%name

install -p -m644 src/OSD/OSD_Common.hxx %buildroot%_includedir
pushd %buildroot%_includedir
rm -f config.h
mv ../config.h %name/
for i in $(egrep -R 'config\.h' ./ |awk -F : '{print $1}')
do
	sed -i 's|<config.h>|<%name/config.h>|' $i
done
popd
#sed -i 's|^\(CONFIG_HEADER\).*|\1 = %_includedir/%name/config.h|' \
#	%buildroot%_datadir/%name/src/WOKTclLib/template.min*

#mv %buildroot%_bindir/DRAWEXE  %buildroot%_bindir/DRAWEXE_
#cat <<EOF >%buildroot%_bindir/DRAWEXE
##!/bin/bash
#
#export TCLHOME=%prefix
#source %_datadir/%name/env_DRAW.sh
#DRAWEXE_ "\$@"
#EOF
#chmod +x %buildroot%_bindir/DRAWEXE

mv %buildroot%prefix/*.sh %buildroot%_bindir/
#chmod +x %buildroot%_bindir/custom.sh

%files
%doc LICENSE*
%_bindir/*
#_datadir/%name/env_DRAW.sh

%files -n lib%name
%_libdir/*.so.*

%files -n lib%name-devel
%_libdir/*.so
%_includedir/*

%files common
%dir %_datadir/%name
%_datadir/%name/src

%changelog
