%def_with libproxy
%def_without stoken
%def_without liboath
# openssl or gnutls
%def_with openssl
%def_without gnutls

Name: openconnect
Version: 6.00
Release: alt1
Summary: Open client for Cisco AnyConnect VPN

Group: Networking/Remote access
License: LGPLv2.1+
Url: http://www.infradead.org/openconnect.html

Source: %name-%version.tar
Patch0: openconnect-snapshot.patch

Requires: lib%name = %version-%release
BuildRequires: pkgconfig(libxml-2.0)
BuildRequires: pkgconfig(zlib)
%{?_with_gnutls:BuildRequires: pkgconfig(gnutls) > 2.12.16 pkgconfig(p11-kit-1)}
%{?_with_openssl:BuildRequires: pkgconfig(openssl)}
%{?_with_libproxy:BuildRequires: pkgconfig(libproxy-1.0)}
%{?_with_stoken:BuildRequires: pkgconfig(stoken)}
%{?_with_liboath:BuildRequires: pkgconfig(liboath)}
BuildRequires: vpnc-script
BuildRequires: libkrb5-devel
BuildRequires: python-modules python-modules-xml groff-extra
Requires: vpnc-script
%{?_with_openssl:Requires: openssl >= 1.0.1e}

%description
This package provides a client for Cisco's "AnyConnect" VPN, which uses
HTTPS and DTLS protocols.

%package -n lib%name
Group: System/Libraries
Summary: Shared libraries for %name

%description -n lib%name
%summary

%package -n lib%name-devel
Summary: Development files for %name
Group: Development/C
Requires: lib%name = %version-%release

%description -n lib%name-devel
The %name-devel package contains libraries and header files for
developing applications that use %name.

%prep
%setup -q
%patch0 -p1

%build
%autoreconf
%configure \
	--enable-static=no \
	%{subst_with libproxy} \
	%{subst_with stoken} \
	%{subst_with liboath} \
	--with-system-cafile=/usr/share/ca-certificates/ca-bundle.crt

echo "const char *openconnect_version_str = \"v%version\";" > version.c
%make_build

%install
make DESTDIR=%buildroot install
%find_lang %name

%files -f %name.lang
%doc TODO COPYING.LGPL
%_sbindir/%name
%_man8dir/*

%files -n lib%name
%_libdir/*.so.*

%files -n lib%name-devel
%_includedir/*
%_libdir/*.so
%_pkgconfigdir/*

%changelog
