%define oname openfvm
%define scalar_type complex
%define ldir %_libdir/petsc-%scalar_type

%define mpiimpl openmpi
%define mpidir %_libdir/%mpiimpl
%define gver 4.9
%set_gcc_version %gver

Name: openfvm-%scalar_type
Version: 1.4
Release: alt7.svn20140225
Summary: General three-dimensional Computational Fluid Dynamics (CFD) solver

Group: Sciences/Mathematics
License: GPL v2 or later
URL: http://openfvm.sourceforge.net/
# svn://svn.code.sf.net/p/openfvm/code/trunk
Source: %oname-%version.tar.gz
Source1: openfvm
Packager: Eugeny A. Rostovtsev (REAL) <real at altlinux.org>

Requires: gmsh gnuplot %oname-common = %version-%release

BuildPreReq: python-module-Pyro4 python-module-petsc-config
BuildPreReq: liblaspack-devel libpetsc-%scalar_type-devel
BuildPreReq: texlive-latex-extra libwxGTK3.0-devel libGL-devel
BuildPreReq: libGLUT-devel libamesos10-devel libepetraext10-devel
BuildPreReq: libifpack10-devel libaztecoo10-devel libepetra10-devel
BuildPreReq: libteuchos10-devel libtrilinos10-devel ghostscript-utils
BuildPreReq: chrpath libparmetis-devel libmetis-devel libdakota-devel

%description
OpenFVM is a general CFD solver released under the GPL license. It was
developed to simulate the flow in complex 3D geometries. Therefore, the
mesh can be unstructured and contain control volumes with arbitrary
shape. The code uses the finite volume method to evaluate the partial
differential equations. As well as solving the velocity and pressure
fields, the code is capable of solving non-isothermal multiphase flow.

The code has two implementations: serial and parallel. The serial
version uses LASPACK as the linear matrix solver and the parallel one
uses the PETSc library. Both implementations use the open source tool
Gmsh for pre- and post-processing.

%package -n %oname-common
Summary: Scalar type independent files of OpenFVM
Group: Sciences/Mathematics
BuildArch: noarch

%description -n %oname-common
OpenFVM is a general CFD solver released under the GPL license. It was
developed to simulate the flow in complex 3D geometries. Therefore, the
mesh can be unstructured and contain control volumes with arbitrary
shape. The code uses the finite volume method to evaluate the partial
differential equations. As well as solving the velocity and pressure
fields, the code is capable of solving non-isothermal multiphase flow.

This package contains scalar type independent files of OpenFVM.

%package -n %oname-examples
Summary: Examples for OpenFVM
Group: Sciences/Mathematics
BuildArch: noarch
Requires: %name = %version-%release

%description -n %oname-examples
OpenFVM is a general CFD solver released under the GPL license. It was
developed to simulate the flow in complex 3D geometries. Therefore, the
mesh can be unstructured and contain control volumes with arbitrary
shape. The code uses the finite volume method to evaluate the partial
differential equations. As well as solving the velocity and pressure
fields, the code is capable of solving non-isothermal multiphase flow.

This package contains examples for OpenFVM.

%package -n %oname-doc
Summary: Documentation for for OpenFVM
Group: Documentation
BuildArch: noarch

%description -n %oname-doc
OpenFVM is a general CFD solver released under the GPL license. It was
developed to simulate the flow in complex 3D geometries. Therefore, the
mesh can be unstructured and contain control volumes with arbitrary
shape. The code uses the finite volume method to evaluate the partial
differential equations. As well as solving the velocity and pressure
fields, the code is capable of solving non-isothermal multiphase flow.

This package contains documentation for OpenFVM.

%prep
%setup
%if "%scalar_type" == "real"
install -m755 %SOURCE1 %oname
install -m755 %SOURCE1 %oname.ser
sed -i 's|@SUFF@||' %oname
sed -i 's|@SUFF@|.ser|' %oname.ser
%endif

%build
mpi-selector --set %mpiimpl
source %_bindir/petsc-%scalar_type.sh
export OMPI_LDFLAGS="-Wl,--as-needed,-rpath,%mpidir/lib -L%mpidir/lib"
export MPIDIR=%mpidir

%make_build -C Flow

%install
source %_bindir/petsc-%scalar_type.sh
export OMPI_LDFLAGS="-Wl,--as-needed,-rpath,%mpidir/lib -L%mpidir/lib"
export MPIDIR=%mpidir

%makeinstall_std -C Flow

%if "%scalar_type" == "real"
install -d %buildroot%_bindir
install -m755 %{oname}* %buildroot%_bindir
%endif

for i in %buildroot$PETSC_DIR/bin/*
do
	chrpath -r %mpidir/lib:$PETSC_DIR/lib $i ||:
done

%files
%doc copying
%ldir/bin/*

%if "%scalar_type" == "real"
%files -n %oname-common
%_bindir/*
%exclude %_bindir/%oname-test

%files -n %oname-examples
%dir %_datadir/%oname
%_datadir/%oname/examples
%_bindir/%oname-test

%files -n %oname-doc
%_docdir/%oname
%endif

%changelog
