#%define udapl 1
#define static 1
%define thread 1

%ifdef udapl
%define udaplpkg openmpi-udapl
%define udaplarg --with-udapl
%else
%define udaplpkg openmpi
%define udaplarg --without-udapl
%endif

%ifdef thread
%define threadpkg %udaplpkg-threads
%define threadarg --with-threads=posix --enable-mpi-threads --enable-progress-threads --enable-ft-thread
%else
%define threadpkg %udaplpkg
%define threadarg --disable-ft-thread
%endif

%ifdef static
%define pkgname %threadpkg-static
%define staticarg --enable-static --disable-shared
%else
%define pkgname %threadpkg
%define staticarg --disable-static
%endif

%define arguments %udaplarg %threadarg %staticarg

Name: %pkgname

Version: 1.4.1
Release: alt3

%define mpi_prefix %_libexecdir/%name
%define mpi_sysconfdir %_sysconfdir/%name

Summary: A powerful implementaion of MPI
Summary(ru_RU.UTF8): Открытая реализация MPI
License: BSD
Group: Development/Other
Url: http://www.open-mpi.org/

Packager: Denis Pynkin <dans@altlinux.ru>
Source:  openmpi-%version.tar
Source1: MPI_Status_c2f.3

#Patch: %name-%version-%release.patch

Patch1: openib-rdmacm-qp-fix.patch
Patch2: mellanox-openib-ini-file-update.patch
Patch3: intel-openib-ini-file-update.patch
Patch4: intel-openib-ini-file-update-2.patch
Patch5: chelsio-openib-ini-file-update.patch

BuildPreReq: rpm-macros-mpi-selector
Requires(post,preun): mpi-selector

%ifdef static
BuildPreReq: libibverbs-devel-static >= 1.1.2
%endif

%ifdef udapl
%ifdef static
BuildPreReq: libdapl-devel-static libstdc++-devel-static
%endif
Requires: libdapl >= 1.2.12
BuildPreReq: libdapl-devel
%endif

%ifdef thread
BuildPreReq: glibc-pthread
%endif

Requires: libibverbs >= 1.1.2
BuildPreReq: /proc flex gcc-c++ gcc-fortran
BuildPreReq: libibverbs-devel
BuildPreReq: valgrind-devel libiberty-devel


%package devel
Summary: Development part of %name
Group: Development/Other

Requires: %name = %version-%release
Requires: gcc-c++ gcc-fortran
Requires: libibverbs-devel libibumad-devel

%ifdef udapl
Requires: libdapl-devel
%endif

%package devel-vt
Summary: Development part of %name. VampirTrace related stuff.
Group: Development/Other

Requires: %name-devel = %version-%release
Requires: gcc-c++ gcc-fortran
Requires: libibverbs-devel libibumad-devel 

%description
Open MPI is a project combining technologies and resources from
several other projects (FT-MPI, LA-MPI, LAM/MPI, and PACX-MPI) in
order to build the best MPI library available. A completely new
MPI-2 compliant implementation, Open MPI offers advantages for
system and software vendors, application developers and computer
science researchers.

This part is attended for computing nodes.
#description -l ru_RU.KOI8-R

%description devel
Package for development with Open MPI 

%description devel-vt
Package for development with Open MPI and VampirTrace 

%prep
%setup -q -n openmpi-%version
%__cp -f %SOURCE1 ompi/mpi/man/man3/
%patch1
%patch2
%patch3
%patch4
%patch5

%build
CFLAGS+=" -D_FORTIFY_SOURCE=2"
LDFLAGS+="-Wl,-R%mpi_prefix/lib/openmpi:%mpi_prefix/lib"
echo="/bin/echo"
export CFLAGS LDFLAGS echo

#autoreconf

function buildIt() {
	./configure $* \
			--enable-mpi-f77 \
			--enable-mpi-f90 \
			--prefix=%mpi_prefix \
			--enable-orterun-prefix-by-default \
			--with-ft=cr \
			--sysconfdir=%mpi_sysconfdir \
			--bindir=%mpi_prefix/bin \
			--libdir=%mpi_prefix/lib \
			--datadir=%mpi_prefix/data \
			--includedir=%mpi_prefix/include \
			--mandir=%mpi_prefix/man \
			--docdir=%_docdir/%name-%version \
			--with-gnu-ld \
			--with-wrapper-ldflags="-Wl,--no-as-needed,-Rpath=%mpi_prefix/lib"

	%make_build
}

buildIt %arguments

%install
echo="/bin/echo"
export echo

%make_install DESTDIR=%buildroot install

#ln -s ompi-restart %buildroot%_libexecdir/%name/bin/orte-restart
#ln -s ompi-checkpoint %buildroot%_libexecdir/%name/bin/orte-checkpoint

%find_lang %name

echo -e "btl = tcp,self\n" >> %buildroot%mpi_sysconfdir/openmpi-mca-params.conf

cat>%buildroot/%mpi_prefix/bin/mpivars.sh<<EOF
if ! echo \$PATH | grep -q %mpi_prefix/bin ; then
    PATH=%mpi_prefix/bin:\$PATH
    export PATH
fi

if ! echo \$LD_LIBRARY_PATH | grep -q %mpi_prefix/lib ; then
    LD_LIBRARY_PATH=%mpi_prefix/lib:\$LD_LIBRARY_PATH
    export LD_LIBRARY_PATH
fi

if ! echo \$MANPATH | grep -q %mpi_prefix/man ; then
    MANPATH=%mpi_prefix/man:\$MANPATH
    export MANPATH
fi
EOF

cat >%buildroot%mpi_prefix/bin/mpivars.csh <<EOF
if (\$?path) then
    if ( "\${path}" !~ *%mpi_prefix/bin* ) then
	set path = ( %mpi_prefix/bin \$path )
    endif
else
    set path = ( %mpi_prefix/bin )
endif

if (\$?LD_LIBRARY_PATH) then
    if ( "\$LD_LIBRARY_PATH" !~ *%mpi_prefix/lib* ) then
	setenv LD_LIBRARY_PATH %mpi_prefix/lib:\$LD_LIBRARY_PATH
    endif
else
    setenv LD_LIBRARY_PATH %mpi_prefix/lib
endif

if (\$?MANPATH) then
    if ( "\$MANPATH" !~ *%mpi_prefix/man* ) then
	setenv MANPATH %mpi_prefix/man:\$MANPATH
    endif
else
    setenv MANPATH %mpi_prefix/man
endif
EOF

%post
%post_mpi_selector %name %mpi_prefix/bin

%preun
%preun_mpi_selector %name

%files -f %name.lang
%doc AUTHORS LICENSE NEWS README VERSION 

%dir %mpi_prefix

%dir %mpi_prefix/bin

%mpi_prefix/bin/mpivars.*
%mpi_prefix/bin/mpirun
%mpi_prefix/bin/ompi_info
%mpi_prefix/bin/opal_wrapper
%mpi_prefix/bin/orted
%mpi_prefix/bin/orterun
%mpi_prefix/bin/mpiexec
%mpi_prefix/bin/opari

%mpi_prefix/bin/ompi-*
%mpi_prefix/bin/orte-*
%mpi_prefix/bin/opal-*

%dir %mpi_prefix/lib
%dir %mpi_prefix/lib/openmpi

%ifdef static
%mpi_prefix/lib/lib*
%exclude %mpi_prefix/lib/libvt*
%else
%mpi_prefix/lib/lib*.so.*
%endif

%dir %mpi_sysconfdir
%config(noreplace) %mpi_sysconfdir/*

%dir %mpi_prefix/man
%mpi_prefix/man/man1
%mpi_prefix/man/man7
%mpi_prefix/data

%files devel
%mpi_prefix/bin/mpic++
%mpi_prefix/bin/mpicc
%mpi_prefix/bin/mpiCC
%mpi_prefix/bin/mpicxx
%mpi_prefix/bin/mpif77
%mpi_prefix/bin/mpif90
%mpi_prefix/bin/otf*

%mpi_prefix/include/*
%mpi_prefix/man/man3

%mpi_prefix/lib/mpi.mod

%ifdef static
%mpi_prefix/lib/openmpi/*
%else
%mpi_prefix/lib/lib*.so
%mpi_prefix/lib/openmpi/*.so
%mpi_prefix/lib/*.la
%mpi_prefix/lib/openmpi/*.la
%mpi_prefix/lib/libotf.a
%endif

%files devel-vt
%mpi_prefix/bin/mpic++-vt
%mpi_prefix/bin/mpicc-vt
%mpi_prefix/bin/mpiCC-vt
%mpi_prefix/bin/mpicxx-vt
%mpi_prefix/bin/mpif77-vt
%mpi_prefix/bin/mpif90-vt
%mpi_prefix/bin/vt*
%mpi_prefix/lib/libvt*

%changelog
