# Enable USBIP support
%define with_usbip %{?_with_usbip: 1} %{?!_with_usbip: 0}

Name: opennx
Version: 0.16.e
Release: alt30

Summary: An OpenSource NX client

License: LGPL/GPL
Group: Networking/Remote access
Url: http://sourceforge.net/projects/opennx

Packager: Denis Baranov <baraka@altlinux.org>

Source: ftp://ftp.etersoft.ru/pub/Etersoft/RX@Etersoft/1.1/sources/tarball/%name-%version.tar

%if %with_usbip
Requires: usbip2-nxclient
%endif

# Automatically added by buildreq on Sat Sep 19 2009
BuildRequires: gcc-c++ imake libSM-devel libXmu-devel nx
BuildRequires: libopensc-devel libsmbclient-devel
BuildRequires: xorg-cf-files zip libcups-devel
BuildRequires: libXau-devel
BuildRequires: libwxGTK3.1-devel

%description
opennx is an OSS replacement for Nomachine's NX client.

%prep
%setup

%build
%configure \
    --bindir=%_libdir/%name/bin \
    --datadir=%_datadir/%name \
    --localedir=%_datadir/locale \
%if %with_usbip
    --enable-usbip \
%endif
    --with-nxproto=3.3.0

%make_build

%install
%makeinstall_std

mkdir -p %buildroot{%_bindir,%_desktopdir}

# FIXME: drop using these symlinks
ln -s %_libdir/%name/bin/%name %buildroot%_bindir/%name
ln -s %_datadir/%name %buildroot%_libdir/%name/share
for f in nxesd nxssh nxservice nxproxy ; do
    ln -s  %_bindir/$f %buildroot%_libdir/%name/bin/$f
done

mkdir -p %buildroot%_libdir/%name/%_lib

for lib in libsmbclient.so libcups.so ; do
    test -r %_libdir/$lib.? || exit
    ln -s %_libdir/$lib.? %buildroot%_libdir/%name/%_lib/$lib
done

cp %buildroot%_datadir/%name/applnk/xdg/*.desktop %buildroot%_desktopdir
rm -rf %buildroot%_datadir/%name/applnk
rm -rf %buildroot%_datadir/%name/icons
subst "s|/usr/NX/bin|%_bindir|g" %buildroot%_desktopdir/*

install -d %buildroot{%_niconsdir,%_miconsdir,%_liconsdir}
for f in nx opennx-admin opennx-wizard ; do
    install -m 644 ./extres/16x16/apps/$f.png %buildroot%_miconsdir/$f.png
    install -m 644 ./extres/32x32/apps/$f.png %buildroot%_niconsdir/$f.png
    install -m 644 ./extres/48x48/apps/$f.png %buildroot%_liconsdir/$f.png
done

install -d %buildroot%_iconsdir/hicolor/{16x16,32x32,48x48}/mimetypes/
install -m 644 ./extres/16x16/mimetypes/nx-desktop.png %buildroot%_iconsdir/hicolor/16x16/mimetypes/nx-desktop.png
install -m 644 ./extres/32x32/mimetypes/nx-desktop.png %buildroot%_iconsdir/hicolor/32x32/mimetypes/nx-desktop.png
install -m 644 ./extres/48x48/mimetypes/nx-desktop.png %buildroot%_iconsdir/hicolor/48x48/mimetypes/nx-desktop.png

%if %with_usbip
install -d -m 755 %buildroot%_sysconfdir/udev/rules.d
install -m 644 etc/*.rules %buildroot%_sysconfdir/udev/rules.d
%endif

%find_lang %name

%if %with_usbip
%pre
%_sbindir/groupadd -r opennx || :
%endif

%files -f %name.lang
%_bindir/%name
%_libdir/%name
%_datadir/%name
%_desktopdir/*.desktop
%_liconsdir/*.png
%_niconsdir/*.png
%_miconsdir/*.png
%_iconsdir/hicolor/*/mimetypes/nx-desktop.png
%if %with_usbip
%_sysconfdir/udev
%endif

%changelog
