%def_disable static

Name: opensc
Version: 0.19.0
Release: alt2.M80P.1

Group: System/Configuration/Hardware
Summary: OpenSC library - for accessing SmartCard devices using PC/SC Lite
Url: https://github.com/OpenSC/OpenSC/wiki
License: LGPL

Requires: lib%name = %version-%release

Source: %name-%version.tar
Patch:  %name-%version-alt.patch

BuildRequires: db2latex-xsl docbook-dtds docbook-style-xsl libXt-devel libassuan-devel libltdl7-devel libpcsclite-devel libreadline-devel libssl-devel xsltproc zlib-devel

%package -n lib%name
Group: System/Libraries
Summary: OpenSC library - for accessing SmartCard devices using PC/SC Lite

%package -n lib%name-devel
Group: Development/Other
Summary: OpenSC development files
Requires: lib%name = %version-%release

%package -n lib%name-devel-static
Group: Development/Other
Summary: Static OpenSC libraries
Requires: lib%name-devel = %version-%release

%package -n pam_opensc
Group: System/Base
Summary: OpenSC module for PAM
License: GPL
Requires: lib%name = %version-%release

%description
libopensc is a library for accessing SmartCard devices using PC/SC
Lite middleware package. It is also the core library of the OpenSC
project. Basic functionality (e.g. SELECT FILE, READ BINARY) should
work on any ISO 7816-4 compatible SmartCard. Encryption and decryption
using private keys on the SmartCard is at the moment possible only
with PKCS#15 compatible cards, such as the FINEID (Finnish Electronic
IDentity) card manufactured by Setec.

%description -n lib%name
libopensc is a library for accessing SmartCard devices using PC/SC
Lite middleware package. It is also the core library of the OpenSC
project. Basic functionality (e.g. SELECT FILE, READ BINARY) should
work on any ISO 7816-4 compatible SmartCard. Encryption and decryption
using private keys on the SmartCard is at the moment possible only
with PKCS#15 compatible cards, such as the FINEID (Finnish Electronic
IDentity) card manufactured by Setec.

%description -n lib%name-devel
OpenSC development files.

%description -n lib%name-devel-static
Static OpenSC libraries.

%description -n pam_opensc
OpenSC module for PAM.

%prep
%setup
%patch -p1

%build
%autoreconf
%add_optflags %optflags_shared
PCSC_SONAME="$(objdump -p "%_libdir/libpcsclite.so"| awk '/SONAME/ {print $2}')"
%configure \
     %{subst_enable static} \
    --enable-shared \
    --enable-pcsc \
    --with-pcsc-provider="%_libdir/$PCSC_SONAME" \
    --with-xsl-stylesheetsdir=/usr/share/xml/docbook/xsl-stylesheets \
    --disable-assert

%make_build

%install
%makeinstall_std

mkdir -p %buildroot/%_sysconfdir/
install -p -m644 etc/opensc.conf %buildroot/%_sysconfdir/opensc.conf

%files
%doc NEWS README.md
%exclude %_datadir/doc/%name/NEWS
%_desktopdir/*.desktop
%config %_sysconfdir/bash_completion.d/*
%_bindir/*
%doc %_mandir/*/*

%files -n lib%name
%config(noreplace) %_sysconfdir/opensc.conf
%_libdir/lib*.so.*
%exclude %_libdir/lib*.so
%_libdir/*.so
%dir %_libdir/pkcs11
%_libdir/pkcs11/*.so
%dir %_datadir/opensc
%_datadir/opensc/*.profile

%files -n lib%name-devel
%_libdir/lib*.so
%_libdir/*.la
%_pkgconfigdir/*.pc

%if_enabled static
%files -n lib%name-devel-static
%_libdir/*.a
%endif

%changelog
