%def_disable static

Name: opensc-compat
Version: 0.16.0
Release: alt3.M80P.1

Group: System/Configuration/Hardware
Summary: OpenSC library - for accessing SmartCard devices using PC/SC Lite
Url: https://github.com/OpenSC/OpenSC/wiki
License: LGPL

Requires: lib%name = %version-%release

Source: %name-%version.tar

BuildRequires: db2latex-xsl docbook-dtds docbook-style-xsl libXt-devel libassuan-devel libltdl7-devel libpcsclite-devel libreadline-devel libssl-devel xsltproc zlib-devel

%package -n libopensc4
Group: System/Libraries
Summary: OpenSC library - for accessing SmartCard devices using PC/SC Lite (compat version)

%package -n lib%name-devel
Group: Development/Other
Summary: OpenSC development files
Requires: lib%name = %version-%release

%package -n lib%name-devel-static
Group: Development/Other
Summary: Static OpenSC libraries
Requires: lib%name-devel = %version-%release

%package -n pam_opensc
Group: System/Base
Summary: OpenSC module for PAM
License: GPL
Requires: lib%name = %version-%release

%description
libopensc is a library for accessing SmartCard devices using PC/SC
Lite middleware package. It is also the core library of the OpenSC
project. Basic functionality (e.g. SELECT FILE, READ BINARY) should
work on any ISO 7816-4 compatible SmartCard. Encryption and decryption
using private keys on the SmartCard is at the moment possible only
with PKCS#15 compatible cards, such as the FINEID (Finnish Electronic
IDentity) card manufactured by Setec.

%description -n libopensc4
libopensc is a library for accessing SmartCard devices using PC/SC
Lite middleware package. It is also the core library of the OpenSC
project. Basic functionality (e.g. SELECT FILE, READ BINARY) should
work on any ISO 7816-4 compatible SmartCard. Encryption and decryption
using private keys on the SmartCard is at the moment possible only
with PKCS#15 compatible cards, such as the FINEID (Finnish Electronic
IDentity) card manufactured by Setec.

%description -n lib%name-devel
OpenSC development files.

%description -n lib%name-devel-static
Static OpenSC libraries.

%description -n pam_opensc
OpenSC module for PAM.

%prep
%setup

%build
%autoreconf
%add_optflags %optflags_shared
PCSC_SONAME="$(objdump -p "%_libdir/libpcsclite.so"| awk '/SONAME/ {print $2}')"
%configure \
     %{subst_enable static} \
    --enable-shared \
    --enable-pcsc \
    --with-pcsc-provider="%_libdir/$PCSC_SONAME" \
    --with-xsl-stylesheetsdir=/usr/share/xml/docbook/xsl-stylesheets \
    --disable-assert

%make_build

%install
%makeinstall_std

mkdir -p %buildroot/%_sysconfdir/
install -p -m644 etc/opensc.conf %buildroot/%_sysconfdir/opensc.conf

%files -n libopensc4
%_libdir/lib*.so.*

%changelog
