Name: openssh
Version: 7.2p2
Release: alt2.M80P.2

Summary: OpenSSH free Secure Shell (SSH) implementation
License: BSD-style
Group: Networking/Remote access
Url: http://www.openssh.com/portable.html
# git://git.altlinux.org/gears/o/openssh.git
Source: %name-%version-%release.tar

%define confdir %_sysconfdir/%name
%define _chrootdir /var/empty
%define docdir %_docdir/%name-%version
%def_with pam_userpass
%def_with libedit
%def_with libaudit
%def_with kerberos5
%def_with selinux
%def_with openssl
%def_with ssh1

%{expand: %%global _libexecdir %_libexecdir/openssh}
%define _pamdir /etc/pam.d

Requires: %name-clients = %version-%release
Requires: %name-server = %version-%release

# Automatically added by buildreq on Wed Apr 04 2007
BuildRequires: libssl-devel pam_userpass-devel zlib-devel
%{?_with_libedit:BuildRequires: libedit-devel}
%{?_with_libaudit:BuildRequires: libaudit-devel}
%{?_with_kerberos5:BuildRequires: libkrb5-devel}
%{?_with_selinux:BuildRequires: libselinux-devel}

%package common
Summary: OpenSSH common files
Group: Networking/Remote access
Conflicts: %name < %version-%release
Obsoletes: ssh

%package clients
Summary: OpenSSH Secure Shell protocol clients
Group: Networking/Remote access
Requires: %name-common = %version-%release
Obsoletes: ssh-clients, sftp

%package keysign
Summary: OpenSSH helper program for hostbased authentication
Group: Networking/Remote access
Requires: %name-clients = %version-%release

%package server
Summary: OpenSSH Secure Shell protocol daemon
Group: System/Servers
PreReq: %name-server-control = %version-%release
Requires: %_chrootdir, syslogd-daemon
Obsoletes: ssh-server
# Because of /etc/syslog.d/ feature.
Conflicts: syslogd < 1.4.1-alt11

%package server-control
Summary: Control rules for the OpenSSH server configuration
License: GPLv2+
Group: System/Servers
BuildArch: noarch
Requires: %name-common = %version-%release

%package askpass-common
Summary: OpenSSH common passphrase dialog infrastructure
Group: Networking/Remote access
BuildArch: noarch
Requires: %name-common = %version-%release
Provides: %_libexecdir
Obsoletes: ssh-extras, ssh-askpass, %name-askpass

%description
Ssh (Secure Shell) a program for logging into a remote machine and for
executing commands in a remote machine.  It is intended to replace
rlogin and rsh, and provide secure encrypted communications between
two untrusted hosts over an insecure network.  X11 connections and
arbitrary TCP/IP ports can also be forwarded over the secure channel.

OpenSSH is OpenBSD's rework of the last free version of SSH, bringing it
up to date in terms of security and features, as well as removing all
patented algorithms to seperate libraries (OpenSSL).

%description common
Ssh (Secure Shell) a program for logging into a remote machine and for
executing commands in a remote machine.  It is intended to replace
rlogin and rsh, and provide secure encrypted communications between
two untrusted hosts over an insecure network.  X11 connections and
arbitrary TCP/IP ports can also be forwarded over the secure channel.

OpenSSH is OpenBSD's rework of the last free version of SSH, bringing it
up to date in terms of security and features, as well as removing all
patented algorithms to seperate libraries (OpenSSL).

This package includes common files necessary for both the OpenSSH
client and server.

%description clients
Ssh (Secure Shell) a program for logging into a remote machine and for
executing commands in a remote machine.  It is intended to replace
rlogin and rsh, and provide secure encrypted communications between
two untrusted hosts over an insecure network.  X11 connections and
arbitrary TCP/IP ports can also be forwarded over the secure channel.

OpenSSH is OpenBSD's rework of the last free version of SSH, bringing it
up to date in terms of security and features, as well as removing all
patented algorithms to seperate libraries (OpenSSL).

This package includes the clients necessary to make encrypted connections
to SSH servers.

%description keysign
ssh-keysign is used by ssh(1) to access the local host keys and generate
the digital signature required during hostbased authentication with SSH
protocol version 2.  ssh-keysign is not intended to be invoked by the
user, but from ssh(1).  See ssh(1) and sshd(8) for more information about
hostbased authentication.

%description server
Ssh (Secure Shell) a program for logging into a remote machine and for
executing commands in a remote machine.  It is intended to replace
rlogin and rsh, and provide secure encrypted communications between
two untrusted hosts over an insecure network.  X11 connections and
arbitrary TCP/IP ports can also be forwarded over the secure channel.

OpenSSH is OpenBSD's rework of the last free version of SSH, bringing it
up to date in terms of security and features, as well as removing all
patented algorithms to seperate libraries (OpenSSL).

This package contains the secure shell daemon.  The sshd is the server
part of the secure shell protocol and allows ssh clients to connect to
your host.

%description server-control
This package contains control rules for OpenSSH server configuration.
See control(8) for details.

%description askpass-common
Ssh (Secure Shell) a program for logging into a remote machine and for
executing commands in a remote machine.  It is intended to replace
rlogin and rsh, and provide secure encrypted communications between
two untrusted hosts over an insecure network.  X11 connections and
arbitrary TCP/IP ports can also be forwarded over the secure channel.

OpenSSH is OpenBSD's rework of the last free version of SSH, bringing it
up to date in terms of security and features, as well as removing all
patented algorithms to seperate libraries (OpenSSL).

This package contains OpenSSH passphrase dialog infrastructure.
These dialogs are intended to be called from the ssh-add program and
not invoked directly.

%prep
%setup -n %name-%version-%release

%build
%autoreconf

mkdir build
cd build
%define _configure_script ../configure

export ac_cv_path_LOGIN_PROGRAM_FALLBACK=/bin/login
export ac_cv_path_NROFF=/usr/bin/nroff
export ac_cv_path_PATH_PASSWD_PROG=/usr/bin/passwd
export ac_cv_path_PROG_LASTLOG=/usr/bin/lastlog
export ac_cv_path_xauth_path=/usr/bin/xauth

%configure \
	--sysconfdir=%confdir \
	--without-rpath \
	--disable-strip \
	--with-mantype=doc \
	--with-pam \
	--with-ipaddr-display \
	--with-privsep-user=sshd \
	--with-privsep-path=%_chrootdir \
	--with-default-path=/bin:/usr/bin:/usr/local/bin \
	--with-superuser-path=/sbin:/usr/sbin:/usr/local/sbin:/bin:/usr/bin:/usr/local/bin \
	%{subst_with kerberos5} \
	%{subst_with libedit} \
	%{subst_with openssl} \
	%{subst_with selinux} \
	%{subst_with ssh1} \
	%{?_with_libaudit:--with-audit=linux} \
	#
%make_build

%install
%makeinstall_std -C build

mkdir -p %buildroot{%_libexecdir,%_sysconfdir{,/X11}/profile.d,%systemd_unitdir}
mkdir -p %buildroot%confdir/authorized_keys{,2}
install -pD -m600 alt/sshd.pamd \
	%buildroot%_pamdir/sshd
install -pD -m755 alt/sshd.init \
	%buildroot%_initdir/sshd
install -pD -m600 alt/sshd.sysconfig \
	%buildroot%_sysconfdir/sysconfig/sshd
install -p -m755 alt/rescp \
	%buildroot%_bindir/
install -p -m755 alt/ssh-agent.sh \
	%buildroot%_sysconfdir/X11/profile.d/
install -pD -m755 alt/sftp.control \
        %buildroot%_sysconfdir/control.d/facilities/sftp
install -pD -m755 alt/sshd-allow-groups.control \
        %buildroot%_sysconfdir/control.d/facilities/sshd-allow-groups
install -pD -m755 alt/sshd-password-auth.control \
        %buildroot%_sysconfdir/control.d/facilities/sshd-password-auth

install -pD -m644 alt/sshd.service \
	%buildroot%systemd_unitdir/sshd.service

sed -i 's,@LIBEXECDIR@,%_libexecdir,g' \
        %buildroot%_sysconfdir/control.d/facilities/sftp

install -p -m755 contrib/ssh-copy-id %buildroot%_bindir/
install -p -m644 contrib/ssh-copy-id.1 %buildroot%_man1dir/

chmod 711 %buildroot%_sbindir/*

install -p -m755 alt/ssh-askpass.{sh,csh} \
	%buildroot%_sysconfdir/profile.d/

mkdir -p %buildroot%docdir
install -pm644 CREDITS LICENCE README* PROTOCOL* alt/[CR]* alt/faq.html \
	%buildroot%docdir/

%pre clients
/usr/sbin/groupadd -r -f sshagent

%pre server
/usr/sbin/groupadd -r -f sshd
/usr/sbin/useradd -r -g sshd -d %_chrootdir -s /dev/null -n sshd >/dev/null 2>&1 ||:
%pre_control sftp sshd-allow-groups sshd-password-auth

%post server
%post_control -s enabled sftp
%post_control -s disabled sshd-allow-groups
%post_control -s default sshd-password-auth
if [ $1 -ge 2 ]; then
	/sbin/service sshd condreload ||:
else
	/sbin/chkconfig --add sshd ||:
fi

%preun server
if [ $1 = 0 ]; then
	/sbin/chkconfig --del sshd ||:
fi

%triggerpostun server -- openssh < 0:3.0.2p1-alt3
f=%confdir/moduli
if [ ! -f "$f" ]; then
	if [ -f "$f".rpmsave ]; then
		cp -pf "$f".rpmsave "$f"
	elif [ -f "$f".rpmnew ]; then
		cp -pf "$f".rpmnew "$f"
	fi
fi

%triggerpostun server -- openssh-server < 5.9p1
dirs="$(find /etc/openssh/authorized_keys{,2} -maxdepth 0 -not -empty 2>/dev/null)" &&
[ -n "$dirs" ] || exit 0
dirs="$(printf %%s "$dirs" |tr '\n' ' ' | sed 's/ / and /')"
printf 'bold\nsetaf 1\n' | tput -S 2>/dev/null ||:
cat >&2 << EOF
***** WARNING *** WARNING *** WARNING *** WARNING *** WARNING *** WARNING *****
This installation appears to be using $dirs directory.
Starting with openssh-server-5.9p1, AuthorizedKeysSystemFile option is
deprecated, and files in these directories are treated the same way as other
files specified by AuthorizedKeysFile option.  As result of this change,
.ssh/authorized_keys files are now checked even for those users who have
/etc/openssh/authorized_keys/%%u files.  To configure forced use of
/etc/openssh/authorized_keys/%%u files for certain users, one can override
AuthorizedKeysFile for them using a Match block.
***** WARNING *** WARNING *** WARNING *** WARNING *** WARNING *** WARNING *****
EOF
printf 'op\nsgr0\n' | tput -S 2>/dev/null ||:

%triggerin server -- openssh-server < 7.1p1-alt1
sed -i '1 i\# Added automatically by openssh update script:\nPubkeyAcceptedKeyTypes +ssh-dss,ssh-dss-cert-v01@openssh.com' \
	%confdir/sshd_config
/sbin/service sshd condreload ||:

%files

%files common
%_bindir/scp
%_bindir/ssh-keygen
%_man1dir/scp.*
%_man1dir/ssh-keygen.*
%docdir/

%files clients
%attr(751,root,root) %dir %confdir
%config(noreplace) %confdir/ssh_config
%config(noreplace) %_sysconfdir/X11/profile.d/*
%_bindir/rescp
%_bindir/sftp
%_bindir/ssh
%_bindir/ssh-add
%attr(2711,root,sshagent) %_bindir/ssh-agent
%_bindir/ssh-copy-id
%_bindir/ssh-keyscan
%attr(751,root,root) %dir %_libexecdir
%_libexecdir/ssh-pkcs11-helper
%_man1dir/sftp.*
%_man1dir/ssh.*
%_man1dir/ssh-add.*
%_man1dir/ssh-agent.*
%_man1dir/ssh-copy-id.*
%_man1dir/ssh-keyscan.*
%_man5dir/ssh_config.*
%_man8dir/ssh-pkcs11-helper.*

%files keysign
%attr(751,root,root) %dir %_libexecdir
%_libexecdir/ssh-keysign
%_man8dir/ssh-keysign.*

%files server
%attr(751,root,root) %dir %confdir
%attr(600,root,root) %config %confdir/moduli
%attr(600,root,root) %config(noreplace) %verify(not size md5 mtime) %confdir/sshd_config
%attr(600,root,root) %config(noreplace) %_pamdir/sshd
%attr(600,root,root) %config(noreplace) %_sysconfdir/sysconfig/sshd
%attr(755,root,root) %config %_initdir/sshd
%attr(751,root,root) %dir %confdir/authorized_keys*
%systemd_unitdir/*
%_sbindir/*
%attr(751,root,root) %dir %_libexecdir
%_libexecdir/sftp-server
%_man5dir/moduli.*
%_man5dir/sshd_config.*
%_man8dir/sshd.*
%_man8dir/sftp-server.*

%files server-control
%attr(755,root,root) %_controldir/*

%files askpass-common
%_sysconfdir/profile.d/ssh-askpass.*
%attr(751,root,root) %dir %_libexecdir

%changelog
