%define svnrev 28002
Name: openttd
Version: 1.9.1
Release: alt1

Summary: An open source clone of the Microprose game "Transport Tycoon Deluxe".
License: GPL
Group: Games/Strategy
URL: https://www.openttd.org/
Requires: TiMidity++
Requires: fonts-ttf-dejavu
Requires: %name-data = %version-%release
Requires: openttd-3rd-party >= 0.5.5

Source: %name-%version.tar
Source1: %name.watch

Patch0: %name-%version-alt.patch

BuildRequires: libSDL-devel libpng-devel libfreetype-devel fontconfig-devel gcc-c++ liblzo2-devel liblzma-devel

%description
An open source clone of the Microprose game "Transport Tycoon Deluxe".

%package data
Buildarch: noarch
Summary: Data files for %name
Requires: %name
Group: Games/Strategy
Requires: %name-3rd-party

%description data
Data files for %name

%prep
%setup
%patch0 -p1

%build
echo "%version	%svnrev	0	%version" >.ottdrev

./configure \
    --prefix-dir=%_prefix \
    --with-sdl \
    --with-png \
    --with-freetype \
    --with-fontconfig \
    --without-libtimidity
    
%make_build WITH_SDL=1 UNIX=1 RELEASE=%version INSTALL=1 WITH_NETWORK=1 ISTAG=1 ISSTABLETAG=1 \
    USE_HOMEDIR=1 VERBOSE=1 PERSONAL_DIR=.%name \
    PREFIX=%_prefix DATA_DIR=share/games/%name \
	
%install
mkdir -p %buildroot%_prefix/games
mkdir -p %buildroot%_datadir/games/%name/gm
mkdir -p %buildroot%_datadir/games/%name/lang
mkdir -p %buildroot%_datadir/games/%name/ai
mkdir -p %buildroot%_man6dir

install -m755 -s bin/%name %buildroot%_prefix/games/%name
cp -a bin/baseset %buildroot%_datadir/games/%name
cp -a bin/ai/*.nut %buildroot%_datadir/games/%name/ai/
cp -a bin/lang/*.lng %buildroot%_datadir/games/%name/lang
chmod -x %buildroot%_datadir/games/%name/baseset/*

#menu

install -dm 755 %buildroot%_datadir/applications
install -m644 media/%name.desktop %buildroot%_datadir/applications/%name.desktop

# icons
install -pD -m644 media/%name.16.png %buildroot%_miconsdir/%name.png
install -pD -m644 media/%name.32.png %buildroot%_niconsdir/%name.png
install -pD -m644 media/%name.48.png %buildroot%_liconsdir/%name.png
install -pD -m644 docs/%name.6 %buildroot%_man6dir/


%files
%_prefix/games/%name

%files data
%doc docs/* bin/scripts README.md known-bugs.txt changelog.txt COPYING
%_datadir/games/%name
%_datadir/applications/%name.desktop
%_niconsdir/%name.png
%_miconsdir/%name.png
%_liconsdir/%name.png
%_man6dir/*

%changelog
