%def_enable shared
%def_enable static
# qt3|qt4
%define gui qt4

%{!?x86_64:%define x86_64 x86_64}

%define Name OProfile
Name: oprofile
%define lname lib%name
Summary: System wide profiler
Version: 0.9.9
Release: alt2
License: GPLv2+
Group: Development/Tools
URL: http://%name.sourceforge.net
Source: %name-%version.tar
Patch0: %name-%version-%release.patch
Patch1: %name-0.9.9-xen.patch
ExclusiveArch: %ix86 ia64 %x86_64 ppc ppc64 s390 s390x alpha alphaev6 sparcv9 sparc64

BuildRequires: docbook-style-xsl gcc-c++ libiberty-devel libpopt-devel xorg-cf-files xsltproc
%ifdef gui
%if "x%gui" == "xqt4"
BuildRequires: libqt4-devel
%else
BuildRequires: libqt3-devel
%endif
%endif

%description
%Name is a profiling system for systems running Linux. The profiling
runs transparently during the background, and profile data can be
collected at any time. %Name makes use of the hardware performance
counters provided on Intel P6, and AMD Athlon family processors, and
can use the RTC for profiling on other x86 processor types.


%package -n %lname
Summary: Libraries required for %Name
Group: System/Libraries

%description -n %lname
This package includes %Name library.


%package -n %lname-devel
Summary: Header files and libraries for developing apps which will use %Name
Group: Development/C
Provides: %lname-devel-static = %version-%release

%description -n %lname-devel
Header files and libraries for developing apps which will use %Name.


%package -n %lname-devel-static
Summary: Static libraries for developing apps which will use %Name
Group: Development/C
Requires: %lname = %version-%release

%description -n %lname-devel-static
Static libraries for developing apps which will use %Name.


%package gui
Summary: GUI for %Name
Group: Development/Tools
Provides: oprof_start = %version-%release

%description gui
The oprof_start GUI for %Name.


%package -n libopagent
Summary: Libraries required for profiling Java and other JITed code
Group: System/Libraries

%description -n libopagent
This package includes a base JIT support library, as well as a Java
agent library.


%package -n libopagent-devel
Summary: Files for development with libopagent
Group: Development/C
Requires: libopagent-devel = %version-%release

%description -n libopagent-devel
Files for development with libopagent.


%package -n libopagent-devel-static
Summary: Static libraries required for profiling Java and other JITed code
Group: Development/C

%description -n libopagent-devel-static
This package includes a base JIT support static library.


%prep
%setup -q
%patch0 -p1
%patch1 -p1


%build
#%%autoreconf
./autogen.sh
%configure \
	%{subst_enable shared} \
	%{subst_enable static} \
%ifdef gui
	--enable-gui=%gui \
%else
	--disable-gui \
%endif
	--with-kernel-support

%make_build


%install
%make_install DESTDIR=%buildroot pkglibdir=%_libdir install

#hack to make header files available
install -d -m 0755 %buildroot{%_includedir,%_libdir,%_localstatedir/%name}
install -m 0644 lib{db/odb,op/op_{events,cpu_type,config,sample_file},util/op_{types,list}}.h %buildroot%_includedir/

#hack to make .a files available
install -m 0644 lib{op/libop,db/libodb}.a %buildroot%_libdir/
for i in util util++ abi; do
	install -m 0644 lib$i/lib$i.a %buildroot%_libdir/libop$i.a
done

mv %buildroot%_docdir/%name{,-%version}


%pre
groupadd -r -f _%name &> /dev/null
useradd -r -g _%name -d %_localstatedir/%name -r -u 16 -s /sbin/nologin \
	-c "Special user account to be used by %Name" _%name &> /dev/null ||:


%files
%doc %_docdir/%name-%version
%_bindir/*
%exclude %_bindir/oprof_start
%_man1dir/*
%_datadir/%name
%attr(775,root,_%name) %dir %_localstatedir/%name


%files -n %lname-devel
%_includedir/odb.h
%_includedir/op_*
%_libdir/*.a
%exclude %_libdir/libopagent*


%files gui
%_bindir/oprof_start
%attr(775,root,_%name) %dir %_localstatedir/%name


%files -n libopagent
%_libdir/libopagent.so.*


%files -n libopagent-devel
%_includedir/opagent.h
%_libdir/libopagent.so


%files -n libopagent-devel-static
%_libdir/libopagent.a


%changelog
