%define ver_major 0.4
%def_enable check

Name: orc
Version: %ver_major.27
Release: alt1.M80P.1

Summary: The Oil Runtime Compiler
Group: Development/Other
License: BSD
URL: http://code.entropywave.com/projects/orc/

# VCS: git://anongit.freedesktop.org/gstreamer/orc
Source: https://gstreamer.freedesktop.org/src/orc/%name-%version.tar.xz
#Source: %name-%version.tar

BuildRequires: gtk-doc
BuildRequires: glib2-devel >= 2.10.0
%{?_with_valgrind:BuildRequires: valgrind-devel}

%description
Orc is a library and set of tools for compiling and executing very
simple programs that operate on arrays of data.
The languag is a generic assembly language that represents many of
the features available in SIMD architectures, including saturated
addition and subtraction, and many arithmetic operations.

%package -n lib%name
Summary: The Oil Runtime Compiler library
Group: System/Libraries

%description -n lib%name
Orc is a library and set of tools for compiling and executing very
simple programs that operate on arrays of data.
The languag is a generic assembly language that represents many of
the features available in SIMD architectures, including saturated
addition and subtraction, and many arithmetic operations.

This package contains the Orc library.

%package -n lib%name-devel
Summary: Development files for liborc
Group: Development/C
Requires: lib%name = %version-%release

%description -n lib%name-devel
Orc is a library and set of tools for compiling and executing very
simple programs that operate on arrays of data.
The languag is a generic assembly language that represents many of
the features available in SIMD architectures, including saturated
addition and subtraction, and many arithmetic operations.

This package contains development files for the Orc library.

%package -n lib%name-test
Summary: The Oil Runtime Compiler library
Group: System/Libraries

%description -n lib%name-test
Orc is a library and set of tools for compiling and executing very
simple programs that operate on arrays of data.
The languag is a generic assembly language that represents many of
the features available in SIMD architectures, including saturated
addition and subtraction, and many arithmetic operations.

This package contains the Orc test library.

%package -n lib%name-test-devel
Summary: Development test files for liborc
Group: Development/C
Requires: lib%name-test = %version-%release
Requires: lib%name-devel = %version-%release

%description -n lib%name-test-devel
Orc is a library and set of tools for compiling and executing very
simple programs that operate on arrays of data.
The languag is a generic assembly language that represents many of
the features available in SIMD architectures, including saturated
addition and subtraction, and many arithmetic operations.

This package contains development files for the Orc test library.

%package doc
Summary: Dcumentation for Orc
Group: Development/Documentation
BuildArch: noarch

%description doc
Orc is a library and set of tools for compiling and executing very
simple programs that operate on arrays of data.
The languag is a generic assembly language that represents many of
the features available in SIMD architectures, including saturated
addition and subtraction, and many arithmetic operations.

This package contains documentation for Orc.

%prep
%setup

%build
%autoreconf
%configure \
	--enable-gtk-doc \
	--disable-static
%make_build

%install
%makeinstall_std

%check
%{?_enable_check:%make check}

%files
%_bindir/orc-bugreport
%_bindir/orcc

%files -n lib%name
%_libdir/liborc-%ver_major.so.*

%files -n lib%name-test
%_libdir/liborc-test-%ver_major.so.*

%files -n lib%name-devel
%dir %_includedir/orc-%ver_major
%_includedir/orc-%ver_major/orc
%_libdir/liborc-%ver_major.so
%_pkgconfigdir/orc-%ver_major.pc
%_datadir/aclocal/orc.m4

%files -n lib%name-test-devel
%_includedir/orc-%ver_major/orc-test
%_libdir/liborc-test-%ver_major.so

%files doc
%_datadir/gtk-doc/html/orc

%changelog
