%define ver_major 3.24

Name: orca
Version: %ver_major.0
Release: alt2.M80P.1

Summary: A screen reader that provides access to the GNOME desktop by people with visual impairments
Summary(ru_RU.UTF-8): Программа экранного доступа для людей с ограничениями по зрению
Group: Accessibility
License: LGPL
URL: http://wiki.gnome.org/Projects/Orca

Source: ftp://ftp.gnome.org/pub/gnome/sources/%name/%ver_major/%name-%version.tar.xz
Source1: voiceman-server
Source2: %name.watch
Source3: orca-autostart.desktop
Source4: ru.po

#Patch1: orca-3.2.1-alt-voiceman.patch
Patch2: orca-3.2.1-alt-punc.patch

#Requires: voiceman

BuildArch: noarch

BuildRequires(pre): rpm-build-python3

BuildPreReq: /proc
BuildRequires: intltool >= 0.40
BuildRequires: gnome-doc-utils
BuildRequires: libgtk+3-devel >= 3.2
BuildRequires: libgtk+3-gir
BuildRequires: libat-spi2-core-devel
BuildRequires: at-spi2-atk-devel
BuildRequires: python3-module-pygobject3-devel >= 3.0
BuildRequires: python3-module-dbus-devel
BuildRequires: python3-module-pycairo-devel
BuildRequires: python3-module-pyxdg
BuildRequires: python3-base
BuildRequires: yelp-tools
BuildRequires: python3-module-speechd

Requires: python3-module-speechd

%description
A flexible, scriptable, extensible screen reader for the GNOME platform
that provides access via speech synthesis, braille, and magnification.
Use gnome-default package to prepare GNOME for using with Orca. There can be problems 
if only gnome-minimal is installed.

%description -l ru_RU.UTF-8
Orca - это программа экранного доступа для людей с ограничениями по
зрению. Она предоставляет речевой интерфейс для работы в среде GNOME,
а также средства для увеличения изображения на экране.
Функциональность Orca очень близка к возможностям популярного пакета
Jaws For Windows компании Freedom Scientific.

%prep
%setup
#%patch1 -p1
%patch2 -p1
cp -f %SOURCE4 po/ru.po

%build
%autoreconf
%configure
%make_build

%install
%make_install DESTDIR=%buildroot pyexecdir=%python3_sitelibdir install

#%__install -d -m755 %buildroot%_datadir/%name/emacspeak-servers/
#echo voiceman > %buildroot%_datadir/%name/emacspeak-servers/.servers
#%__install -pD -m755 %SOURCE1 %buildroot%_datadir/%name/emacspeak-servers/voiceman

install -D -m0644 %SOURCE3 %buildroot%_datadir/gdm/greeter/autostart/orca-autostart.desktop

%find_lang --with-gnome %name

%files -f %name.lang
%doc AUTHORS ChangeLog NEWS README TODO
%_bindir/%name
%python3_sitelibdir/%name/
#%_datadir/applications/*
%_iconsdir/hicolor/*/apps/%name.png
%_iconsdir/hicolor/scalable/apps/%name.svg
%_iconsdir/hicolor/symbolic/apps/%name-symbolic.svg
%_man1dir/*
%_datadir/%name/
%_sysconfdir/xdg/autostart/%name-autostart.desktop
%_datadir/gdm/greeter/autostart/%name-autostart.desktop

%changelog
