%define cid            langpack-ru@palemoon.org
%define cid_dir        %palemoon_noarch_extensionsdir/%cid

%define cid_dict       ru@dictionaries.addons.mozilla.org
%define cid_dict_dir   %palemoon_noarch_extensionsdir/%cid_dict

%define min_version	27.8.0
%define max_version	27.7.*

%define bname		newmoon
%define sdir		searchplugins
%define newmoon_dir 	%_datadir/%bname-data/browser/
%define search_dir 	%newmoon_dir%sdir

Name: palemoon-ru

# commit db3903541364659a9299cae4016a1210b5f5fbd2
# Author: wolfbeast <mcwerewolf@gmail.com>
# Date:   Thu Mar 1 08:02:43 2018 +0100
#
#    Run release pack 27.8.0


Version: 27.8.0
Release: alt1

Summary: Russian (RU) Language Pack for Pale Moon
License: MPL/GPL/LGPL

Group: Networking/WWW
Url: http://www.palemoon.org/langpacks.shtml
BuildArch: noarch

Packager: Hihin Ruslan <ruslandh@altlinux.ru>

Source:  ru_palemoon_%version.xpi
Source2: searchplugins.tar

Patch:   %name-27.1.1-search.patch
#Patch2:	 %name-27.3.0-advanced.patch

Requires: palemoon >= 27.7.0
Requires: hunspell-ru
Obsoletes: palemoon-ru_yo-dictionary palemoon-ru_ie-dictionary
Provides: palemoon-ru_yo-dictionary palemoon-ru_ie-dictionary

BuildRequires(pre):	rpm-build-palemoon 
# Automatically added by buildreq on Mon Jul 13 2015
BuildRequires: libdb4-devel unzip

%description
The Palemoon Russian translation and dictionary.

%package -n palemoon-searchplugins
Summary: The Palemoon Russian translation and dictionary.
Group:   Networking/WWW
BuildArch: noarch
Conflicts:  palemoon-ru < 27.7.0

%description -n palemoon-searchplugins
The set of search plugins for Palemoon

%description -n palemoon-searchplugins -l ru_RU.UTF8
Набор Поисковых плагинов для Palemoon


%prep
%setup -c -n %name-%version/%cid

%patch -p2

#patch2 -p2

tar -xf %SOURCE2



%install
cd ..

mkdir -p -- \
	%buildroot/%cid_dir \
	%buildroot/%cid_dict_dir/dictionaries

install -d -m 755 %buildroot/%newmoon_dir/

# Install translation
cp -r -- %cid/* %buildroot/%cid_dir


cd -

cp -r -- %sdir  %buildroot/%search_dir/


#sed -r -i \
#    -e 's,<em:maxVersion>4.0</em:maxVersion>,<em:maxVersion>4.*</em:maxVersion>,g' \
#    -e 's,<em:minVersion>4.0</em:minVersion>,<em:minVersion>4.0</em:minVersion>,g' \
#    %buildroot/%cid_dir/install.rdf

# Install dictionary
cat > %buildroot/%cid_dict_dir/install.rdf <<-EOF
	<?xml version="1.0"?>
	<RDF xmlns="http://www.w3.org/1999/02/22-rdf-syntax-ns#"
	     xmlns:em="http://www.mozilla.org/2004/em-rdf#">
	  <Description about="urn:mozilla:install-manifest"
	               em:id="%cid_dict"
	               em:name="Russian (RU) Dictionary"
	               em:version="%version"
	               em:type="64"
	               em:unpack="true"
	               em:creator="Mozilla Russia">
	    <em:targetApplication>
	      <Description>
	        <em:id>{8de7fcbb-c55c-4fbe-bfc5-fc555c87dbc4}</em:id>
	        <em:minVersion>%min_version</em:minVersion>
	        <em:maxVersion>%max_version.*</em:maxVersion>
	      </Description>
	    </em:targetApplication>
	  </Description>
	</RDF>
EOF
ln -s %_datadir/myspell/ru_RU.aff %buildroot/%cid_dict_dir/dictionaries/ru.aff
ln -s %_datadir/myspell/ru_RU.dic %buildroot/%cid_dict_dir/dictionaries/ru.dic


%files
%cid_dir
%cid_dict_dir

%files -n palemoon-searchplugins
%search_dir



%changelog
