Name: pam-config
Version: 1.7.0
Release: alt1

Summary: Systemwide PAM config files
License: GPLv2+
Group: System/Base
BuildArch: noarch

Source0: %name-%version.tar
Source1: %name-deps.sh

Source2: pam_mktemp.control
Source3: system-auth.control

%define _pamdir %_sysconfdir/pam.d

# All pam dependencies now provided/required by subpackages.
AutoReqProv: nopam

PreReq: %name-control = %version-%release
Requires: libpasswdqc >= 0:1.1.0-alt0.2
Requires: glibc-crypt_blowfish >= 1.2
Provides: %_pamdir, /etc/security
Provides: pam-common = %version-%release
Obsoletes: pam-common

# due to %_pamdir/other
Conflicts: pam < 0:0.75-alt21
# due to pam_mktemp.so
Conflicts: openssh-server < 0:4.6p1

BuildPreReq: rpm-build >= 0:4.0.4-alt98.15

%package control
Summary: Control rules for the systemwide PAM config files
Group: System/Base

%package -n pam0-config
Summary: Systemwide PAM config files for Linux-PAM
Group: System/Base
PreReq: %name = %version-%release
# This is quite low-level code; synced with rpm-build-4.0.4-alt98.15.
Requires: %([ -x "%SOURCE1" ] && RPM_LIB=%_lib RPM_LIBDIR=%_libdir PAM_SO_SUFFIX= PAM_NAME_SUFFIX=0 RPM_BUILD_ROOT=%buildroot %SOURCE1 %SOURCE0 req || echo unknown)
Provides: %([ -x "%SOURCE1" ] && PAM_SO_SUFFIX= PAM_NAME_SUFFIX=0 RPM_BUILD_ROOT=%buildroot %SOURCE1 %SOURCE0 prov || echo unknown)
# Compatibility.
Provides: pam(system-auth), pam(system-auth-use_first_pass), pam(other)

%package -n pam2-config
Summary: Systemwide PAM config files for OpenPAM
Group: System/Base
PreReq: %name = %version-%release
# This is quite low-level code; synced with rpm-build-4.0.4-alt98.15.
Requires: %([ -x "%SOURCE1" ] && RPM_LIB=%_lib RPM_LIBDIR=%_libdir PAM_SO_SUFFIX=.2 PAM_NAME_SUFFIX=2 RPM_BUILD_ROOT=%buildroot %SOURCE1 %SOURCE0 req || echo unknown)
Provides: %([ -x "%SOURCE1" ] && PAM_SO_SUFFIX=.2 PAM_NAME_SUFFIX=2 RPM_BUILD_ROOT=%buildroot %SOURCE1 %SOURCE0 prov || echo unknown)

%description
PAM (Pluggable Authentication Modules) is a system security tool
which allows system administrators to set authentication policy
without having to recompile programs which do authentication.

This package contains systemwide PAM config files.
This package also contains common files and directories
shared by various PAM implementations.

%description control
This package contains control rules for systemwide PAM config files.
See control(8) for details.

%description -n pam0-config
PAM (Pluggable Authentication Modules) is a system security tool
which allows system administrators to set authentication policy
without having to recompile programs which do authentication.

This package contains systemwide config files for Linux-PAM.

%description -n pam2-config
PAM (Pluggable Authentication Modules) is a system security tool
which allows system administrators to set authentication policy
without having to recompile programs which do authentication.

This package contains systemwide config files for OpenPAM.

%prep
%setup

%install
mkdir -p %buildroot{%_pamdir,%_controldir,/etc/security}

cp -a * %buildroot%_pamdir/
chmod 644 %buildroot%_pamdir/*

for f in pam_mktemp system-auth; do
	install -pm755 %_sourcedir/$f.control %buildroot%_controldir/$f
done

%pre
%pre_control pam_mktemp
for f in %_pamdir/system-auth %_pamdir/system-auth-use_first_pass; do
	if [ -f "$f" -a ! -L "$f" ]; then
		mv -f "$f" "$f-local" &&
		ln -f "$f-local" "$f-local.rpmsave" &&
		touch "/var/run/${f##*/}-local.update" &&
		ln -s "${f##*/}-local" "$f" ||:
	fi
done
%pre_control system-auth

%post
cd %_pamdir
for f in system-auth system-auth-use_first_pass; do
	if [ -f "/var/run/$f-local.update" -a -f "$f-local.rpmsave" ]; then
		[ -f "$f-local.rpmnew" ] ||
			ln -f "$f-local" "$f-local.rpmnew" ||:
		mv -f "$f-local.rpmsave" "$f-local" &&
			rm -f "/var/run/$f-local.update" ||:
		cmp -s "$f-local" "$f-local.rpmnew" &&
			rm -f "$f-local.rpmnew" ||:
	fi
done
if [ ! -f system-auth ]; then
	if [ -f system-auth.rpmsave ]; then
		cp -af system-auth.rpmsave system-auth
	elif [ -f system-auth.rpmnew ]; then
		cp -af system-auth.rpmnew system-auth
	fi
fi
%post_control -s enabled pam_mktemp
%post_control -s local system-auth

%triggerpostun -- pam <= 0:0.75-alt8
[ $2 -gt 0 ] || exit 0
cd %_pamdir
if [ ! -f system-auth ]; then
	if [ -f system-auth.rpmsave ]; then
		cp -pf system-auth.rpmsave system-auth
	elif [ -f system-auth.rpmnew ]; then
		cp -pf system-auth.rpmnew system-auth
	fi
fi

%files
%dir %_pamdir
%config %_pamdir/other
%config(noreplace) %_pamdir/*-local
%config(noreplace) %_pamdir/*-ldap
%config(noreplace) %_pamdir/*-krb5
%config(noreplace) %_pamdir/*-krb5_ccreds
%config(noreplace) %_pamdir/*-multi
%config(noreplace) %_pamdir/*-pkcs11
%config(noreplace) %_pamdir/*-winbind
%config(noreplace) %_pamdir/common-login*
%_pamdir/system-auth
%_pamdir/system-auth-use_first_pass
/etc/security

%files control
%config %_controldir/*

%files -n pam0-config

%changelog
