Name: pam_mktemp
Version: 1.1.1
Release: alt3

Summary: Pluggable private /tmp space support for interactive (shell) sessions
License: BSD-style
Group: System/Base
Url: http://www.openwall.com/pam/

# ftp://ftp.openwall.com/pub/projects/pam/modules/pam_mktemp/pam_mktemp-%version.tar.gz
Source: pam_mktemp-%version.tar
Patch: pam_mktemp-%version-%release.patch

%def_enable selinux

# due to PAM policy.
BuildRequires(pre): libpam-devel
# due to change in format of PAM modules requirements.
BuildRequires: rpm-build >= 0:4.0.4-alt55
# due to ext2fs/ext2_fs.h
BuildRequires: libe2fs-devel
%{?_enable_selinux:BuildRequires: libselinux-devel}

%set_pam_name %name

%package -n %pam_name
Summary: Pluggable private /tmp space support for interactive (shell) sessions
License: BSD-style
Group: System/Base
Requires(post): coreutils
Provides: %name = %version-%release
Obsoletes: %name

%description
pam_mktemp is a PAM module which may be used with a PAM-aware login
service to provide per-user private directories under /tmp as a part
of PAM session or account management.

%description -n %pam_name
pam_mktemp is a PAM module which may be used with a PAM-aware login
service to provide per-user private directories under /tmp as a part
of PAM session or account management.

%prep
%setup
%patch -p1

%build
%make_build CFLAGS="%optflags %optflags_shared -Werror" \
	%{?_enable_selinux:USE_SELINUX=1}

%install
%makeinstall_std SECUREDIR=/%_lib/security
mkdir -pm755 %buildroot/tmp/.private

%post -n %pam_name
mkdir -p -m755 /tmp/.private

%files -n %pam_name
/%_lib/security/*
%ghost %attr(755,root,root) /tmp/.private
%doc LICENSE README

%changelog
