Name: pam_mount 
Version: 2.16
Release: alt0.M80P.1

Summary: Pluggable Authentication Module that can mount volumes for a user session 
License: GPLv2+ and LGPLv2+
Group: System/Libraries

BuildRequires: glib2-devel pam-devel openssl-devel libHX-devel libxml2-devel libavahi-devel
BuildRequires: libcryptsetup-devel libmount-devel libpcre-devel

Source0: %name-%version.tar
Patch: %name-%version-%release.patch

%description
This module is aimed at environments with central file servers that
a user wishes to mount on login and unmount on logout, such as
(semi-)diskless stations where many users can logon and where statically
mounting the entire /home from a server is a security risk, or listing
all possible volumes in /etc/fstab is not feasible.

%prep
%setup -q
%patch -p1

%build
%autoreconf
%configure \
	--with-slibdir=/%_lib \
	--with-ssbindir=/sbin
%make_build

%install
%make DESTDIR=%buildroot install
mv %buildroot%_libdir/lib*.so.* %buildroot/%_lib/

%files
%doc doc/*.txt
%config(noreplace) %_sysconfdir/security/%name.conf.xml
/%_lib/security/*
%_sbindir/*
/sbin/*
/%_lib/*.so.*
%_mandir/man?/*

%changelog
