# vim: set ft=spec: -*- rpm -spec -*-

Name: pam_pkcs11
Version: 0.6.10
Release: alt3.M80P.1

Summary: PKCS #11 PAM Module and Login Tools
Group: System/Base
License: LGPL
Url: https://github.com/OpenSC/pam_pkcs11

Source: %name-%version.tar
Patch: %name-%version-alt-cumulative.patch
Patch1: pam_pkcs11-0.6.9-build-with-LibreSSL.patch
Patch2: pam_pkcs11-0.6.9-elvis-gost-support.patch

%add_findreq_skiplist %_sysconfdir/pam.d/*
Requires: pam-config PAM(pam_mkhomedir.so) PAM(pam_pkcs11.so) PAM(pam_succeed_if.so)
Requires: pcsc-lite pcsc-lite-ccid

BuildRequires: docbook-style-xsl flex libldap-devel libpam-devel libpcsclite-devel LibreSSL-devel xsltproc
BuildRequires: doxygen
BuildRequires: docbook-dtds

BuildRequires: libopensc-devel

BuildPreReq: gcc-c++
# SCARD_READERSTATE_A will change to SCARD_READERSTATE afterwards:
BuildPreReq: libpcsclite-devel >= 1.7.4

BuildRequires: libpwquality-devel

%description
This Linux-PAM login module allows a X.509 certificate based user login.
The certificate and its dedicated private key are thereby accessed by
means of an appropriate PKCS #11 module. For the verification of the
user certificates, locally stored CA certificates as well as either
online or locally accessible CRLs are used.

Adittional included pam_pkcs11 related tools:

 - pkcs11_eventmgr: Generate actions on card insert/removal/timeout
   events
 - pklogin_finder: Get the loginname that maps to a certificate
 - pkcs11_inspect: Inspect the contents of a certificate

%package pcsc
Summary: PCSC-Lite extra tools for pam_pkcs11
Group: System/Base
Requires: %name = %version-%release

%description pcsc
This package contains pam_pkcs11 tools that relies on PCSC-Lite library:

 - card_eventmgr: Generate card insert/removal events.

%package ldap
Summary: LDAP Cert-to-Login mapper for pam_pkcs11
Group: System/Base
Requires: %name = %version-%release

%description ldap
This package contains a Certificate-To-Login mapper based on queries
to a LDAP server. As it depends on extra libraries, is distributed
as a separate package.

- ldap_mapper.so: LDAP-based mapper module.

%package isbc
Summary: ISBC (ESMART) low-level modules for pam_pkcs11
Group: System/Base
Requires: %name = %version-%release

%description isbc
This package contains ISBC (ESMART) low-level modules for pam_pkcs11

%prep
%setup
%patch -p1
%patch1 -p1
%patch2 -p2

# fixup configs
sed -i -e '
	s,/usr/lib/pam_pkcs11/,/%_lib/%name/,g;
	s,/usr/lib/,%_libdir/,g;
	s,/etc/pam_pkcs11/,%_sysconfdir/security/%name/,g;
	' etc/*.example doc/*.in doc/*.xml

%build
%autoreconf
#	--disable-rpath \
%configure \
	--libdir=/%_lib \
	--disable-static \
	--enable-shared \
	--enable-debug \
	--with-ldap \
	--with-confdir=%_sysconfdir/security/%name \
    --with-pwquality \
	#
%make_build docdir=%_datadir/doc/%name-%version
cd doc
./generate-api.sh

%install
%makeinstall_std docdir=%_datadir/doc/%name-%version


mkdir -p %buildroot%_sysconfdir/security/%name/{cacerts,crls}

# Cleanup .la files
rm %buildroot/%_lib/*/*.la

%find_lang %name

%post
[ ! -e %_sysconfdir/security/%name/openssl.cnf ] || \
    mv -v %_sysconfdir/security/%name/openssl.cnf \
          %_sysconfdir/security/%name/openssl.cnf.rpmold

%files -f %name.lang
%doc AUTHORS README
%doc doc/pam_pkcs11.html
%doc doc/mappers_api.html
%doc doc/README.autologin
%doc doc/README.mappers
%doc etc/pam.d_login.example
%dir %_sysconfdir/security/%name
%dir %_sysconfdir/security/%name/cacerts
%dir %_sysconfdir/security/%name/crls
%config(noreplace) %_sysconfdir/security/%name/pam_pkcs11.conf
%config(noreplace) %_sysconfdir/security/%name/pkcs11_eventmgr.conf
%config(noreplace) %_sysconfdir/security/%name/*_mapping
%_bindir/*
%exclude %_bindir/card_eventmgr
%dir /%_lib/%name
/%_lib/%name/openssh_mapper.so
/%_lib/%name/opensc_mapper.so
%_pam_modules_dir/pam_pkcs11.so
%_man1dir/pkcs11_eventmgr.1*
%_man1dir/pkcs11_inspect.1*
%_man1dir/pkcs11_listcerts.1*
%_man1dir/pkcs11_setup.1*
%_man1dir/pklogin_finder.1*
%_man1dir/pkcs11_make_hash_link.1*
%_man8dir/pam_pkcs11.8*
%config(noreplace) %_sysconfdir/pam.d/*
%_unitdir/*

%files pcsc
%doc doc/README.eventmgr
%config(noreplace) %_sysconfdir/security/%name/card_eventmgr.conf
%_bindir/card_eventmgr
%_mandir/man1/card_eventmgr.1*

%files ldap
%doc doc/README.ldap_mapper
/%_lib/%name/ldap_mapper.so

%files isbc
/%_lib/%name/ll_isbc.so

%changelog
