Name: papi
License: BSD-like
Group: Development/Tools
Summary: Performance Application Programming Interface
Version: 5.3.0
Release: alt1
Url: http://icl.cs.utk.edu/papi/
Packager: Eugeny A. Rostovtsev (REAL) <real at altlinux.org>

Source: %name-%version.tar.gz
Patch: papi-5.0.1-alt-i586.patch

Requires: lib%name = %version-%release

BuildPreReq: libncurses-devel gcc-fortran /proc libsensors3-devel
BuildPreReq: libltdl-devel doxygen graphviz

%description
PAPI aims to provide the tool designer and application engineer with a
consistent interface and methodology for use of the performance counter hardware
found in most major microprocessors. PAPI enables software engineers to see, in
near real time, the relation between software performance and processor events.

%package -n lib%name
Summary: Shared libraries of PAPI (Performance Application Programming Interface)
Group: System/Libraries

%description -n lib%name
PAPI aims to provide the tool designer and application engineer with a
consistent interface and methodology for use of the performance counter hardware
found in most major microprocessors. PAPI enables software engineers to see, in
near real time, the relation between software performance and processor events.

This package contains shared libraries of PAPI.

%package -n lib%name-devel
Summary: Development files of Performance Application Programming Interface
Group: Development/C
Requires: lib%name = %version-%release

%description -n lib%name-devel
PAPI aims to provide the tool designer and application engineer with a
consistent interface and methodology for use of the performance counter hardware
found in most major microprocessors. PAPI enables software engineers to see, in
near real time, the relation between software performance and processor events.

This package contains development files of PAPI.

%package doc
Summary: Documentation for Performance Application Programming Interface
Group: Documentation
#BuildArch: noarch

%description doc
PAPI aims to provide the tool designer and application engineer with a
consistent interface and methodology for use of the performance counter hardware
found in most major microprocessors. PAPI enables software engineers to see, in
near real time, the relation between software performance and processor events.

This package contains documentation for PAPI.

%prep
%setup
#ifarch %ix86
#patch -p1
#endif

rm -fR src/perfctr-*
cp -f src/Rules.pfm src/Rules.perfctr
cp -f src/Rules.pfm src/Rules.perfctr-pfm

%build
cd src

pushd components/lmsensors
%autoreconf
%configure \
	--with-sensors_incdir=%_includedir/sensors \
	--with-sensors_libdir=%_libdir
popd

#cp Makefile.inc Makefile.inc.bak
#sed -i -e 's/\-Werror//g' libpfm-3.?/config.mk
%add_optflags %optflags_shared
%autoreconf
%configure \
%ifarch x86_64
	--with-bitmode=64 \
%else
	--with-bitmode=32 \
%endif
	--with-ffsll \
	--with-static-lib=no \
	--with-virtualtimer=clock_thread_cputime_id \
	--with-perf-events \
	--with-libpfm3 \
	--with-components="appio coretemp lmsensors mx net rapl stealtime"
#cp -f Makefile.inc.bak Makefile.inc
#make libpapi.a
%make_build

%make -C ../doc html man

%install
cd src
%makeinstall_std
%make_install DESTDIR=%buildroot install-man

install -d %buildroot%_docdir/%name
cp -fR ../doc/html/* %buildroot%_docdir/%name/

ln -s libpapi.so %buildroot%_libdir/libpapi64.so
ln -s libpfm.so %buildroot%_libdir/libpfm64.so

%files
%doc *.txt README
%_bindir/*
%_man1dir/*
%_datadir/%name

%files -n lib%name
%_libdir/*.so.*

%files -n lib%name-devel
%_libdir/*.so
%_includedir/*
%_man3dir/*

%files doc
%_docdir/%name

%changelog
