Name: parole
Version: 0.9.1
Release: alt0.M80P.1

# '1' for gstreamer-1.0
# '0' or undefined for gstreamer-0.10
%ifnarch %arm
%define gstreamer1 1
%else
%define gstreamer1 0
%endif

%def_enable clutter

%define _unpackaged_files_terminate_build 1

Summary: Media player for the Xfce desktop
License: %gpl2plus
Group: Video

URL: http://goodies.xfce.org/projects/applications/parole
# git://git.xfce.org/apps/parole
Source: %name-%version.tar
Patch: %name-%version-%release.patch
Packager: Xfce Team <xfce@packages.altlinux.org>

BuildRequires(pre): rpm-build-licenses

BuildPreReq: rpm-build-xfce4 xfce4-dev-tools
BuildPreReq: libxfce4ui-gtk3-devel libxfce4util-devel libxfconf-devel
BuildRequires: libgtk+3-devel libnotify-devel libtag-devel
%if %{?gstreamer1}%{!?gstreamer1:0}
BuildRequires: gstreamer1.0-devel gst-plugins1.0-devel
%else
BuildRequires: gstreamer-devel gst-plugins-devel
%endif
BuildRequires: libdbus-glib-devel libdbus-devel
%{?_enable_clutter:BuildRequires: libclutter-devel libclutter-gtk3-devel}
BuildRequires: intltool gtk-doc

%if %{?gstreamer1}%{!?gstreamer1:0}
Requires: gstreamer1.0
Requires: gst-plugins-base1.0 gst-plugins-good1.0 gst-plugins-bad1.0 gst-plugins-ugly1.0 gst-libav
%else
Requires: gstreamer
Requires: gst-plugins-base gst-plugins-good gst-plugins-bad gst-plugins-ugly gst-ffmpeg
%endif

%description
Parole is a modern simple media player based on the GStreamer framework
and written to fit well in the Xfce desktop. Parole features playback of
local media files, DVD/CD and live streams. Parole is extensible via
plugins.

%package devel
Summary: Development files for %name
Group: Development/C
Requires: libgtk+3-devel
BuildArch: noarch

%description devel
This package contains header files and documentation
for developing plugins for %name.

%prep
%setup
%patch -p1
mkdir m4

%build
%xfce4reconf
%configure \
	--disable-static \
	--enable-maintainer-mode \
	--enable-taglib \
%if %{?gstreamer1}%{!?gstreamer1:0}
	--with-gstreamer=1.0 \
%else
	--with-gstreamer=0.10 \
%endif
	%{subst_enable clutter} \
	--enable-gtk-doc \
	--enable-debug=minimal
%make_build

%install
%makeinstall_std
%find_lang %name

%files -f %name.lang
%doc AUTHORS README THANKS
%_bindir/%name
%_libdir/%name-*/
%exclude %_libdir/%name-*/*.la
%_desktopdir/*.desktop
%_datadir/appdata/%name.appdata.xml
%_iconsdir/hicolor/*/apps/*
%_datadir/%name/

%files devel
%_includedir/*
%doc %_datadir/gtk-doc/html/*

%changelog
